/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.influencers;

import com.ibm.smarts.fields.recommender.core.AbstractAnalysisStep;
import com.ibm.smarts.fields.recommender.core.BaseFieldsAnalysisContext;
import com.ibm.smarts.fields.recommender.core.influencers.InfluencersAnalysisContext;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumericMetadataEvaluation
extends AbstractAnalysisStep<InfluencersAnalysisContext> {
    private static final String OUTLIER_ID = "http://www.ibm.com/ontologies/waca/application#HasOutlier";
    private static final Logger LOGGER = LoggerFactory.getLogger(NumericMetadataEvaluation.class);

    @Override
    public void execute(@Nonnull InfluencersAnalysisContext rfac) {
        ArrayList toPurge = new ArrayList(rfac.getInfluencersCandidates().size());
        rfac.getInfluencersCandidates().iterator().forEachRemaining(r -> {
            if (this.isDegenerated((InfluencersAnalysisContext.InfluencerCandidate)r)) {
                toPurge.add(r);
                LOGGER.info("purged candidate [{}] in dataset [{}]", (Object)r.getField().getId(), (Object)r.getTableID());
            }
        });
        rfac.getInfluencersCandidates().removeAll(toPurge);
        this.adjustScoreViaCorr(rfac);
        rfac.getInfluencersCandidates().iterator().forEachRemaining(r -> {
            if (r.getField().getSemanticInfo().getConcepts().stream().anyMatch(c -> OUTLIER_ID.equals(c.getConceptID()))) {
                r.setStatsScore(r.getStatsScore() + 0.5f);
            }
            this.adjustScoreViaDataQuality((InfluencersAnalysisContext.InfluencerCandidate)r);
        });
    }

    private boolean isDegenerated(InfluencersAnalysisContext.InfluencerCandidate r) {
        return r.getField().getSemanticInfo().getConcepts().stream().anyMatch(this::isDegenerated);
    }

    private void adjustScoreViaCorr(InfluencersAnalysisContext rfac) {
        DatasetInfo targetTable = this.getTargetTable(rfac);
        if (Optional.ofNullable(targetTable.getBivariateStatistics()).isPresent()) {
            Map<Pair<String, String>, BivariateStatistics> bvMap = this.getBVMapAndStoreIfAbsent(rfac, targetTable);
            ArrayList targetBVs = new ArrayList();
            SmartsModuleUtil.getFlattenedColumns((BaseItemObject)targetTable).forEach(col -> {
                BivariateStatistics bv = this.getBivariate(bvMap, rfac.getTargetFieldID(), col.getId());
                if (bv != null && (this.valueInRange(bv, rfac, CORR_MEASURE) || this.isInfluential(bv, rfac))) {
                    targetBVs.add(bv);
                }
            });
            rfac.getInfluencersCandidates().stream().filter(can -> can.getTableID().equals(targetTable.getId())).forEach(can -> this.adjustScoreViaCorr((InfluencersAnalysisContext.InfluencerCandidate)can, targetBVs, rfac));
        } else {
            LOGGER.warn("The target dataset [{}] doesn't have bivariates", (Object)targetTable.getName());
        }
    }

    private boolean isInfluential(BivariateStatistics bv, InfluencersAnalysisContext rfac) {
        String otherField = rfac.getTargetFieldID().equals(bv.getColumn1()) ? bv.getColumn2() : bv.getColumn1();
        InfluencersAnalysisContext.InfluencerCandidate influencerCandidate = rfac.getCandidatesMap().get(this.toFieldUID(otherField, rfac.getTargetFieldTableID()));
        if (null == influencerCandidate) {
            return false;
        }
        return Float.compare(influencerCandidate.getInfluentialScore(), 0.0f) > 0;
    }

    private void adjustScoreViaCorr(InfluencersAnalysisContext.InfluencerCandidate can, List<BivariateStatistics> bvs, BaseFieldsAnalysisContext rfac) {
        bvs.stream().filter(bv -> this.hasFieldInBivarite(can.getField().getId(), (BivariateStatistics)bv)).forEach(bv -> {
            if (this.isWithinCorrelationLimit((BivariateStatistics)bv, rfac, CORR_MEASURE)) {
                can.setStatsScore(can.getStatsScore() + 1.0f);
            } else {
                can.setStatsScore(can.getStatsScore() + 0.5f);
            }
        });
    }

    private void adjustScoreViaDataQuality(InfluencersAnalysisContext.InfluencerCandidate r) {
        if (Optional.ofNullable(r.getField().getStatistics()).isPresent()) {
            float f = this.computeNullScore(r);
            float stats = r.getStatsScore() - f;
            r.setStatsScore(Float.compare(stats, 0.0f) > 0 ? stats : 0.0f);
        }
    }

    private float computeNullScore(InfluencersAnalysisContext.InfluencerCandidate r) {
        List stats = r.getField().getStatistics();
        Optional<Statistic> totalCnt = stats.stream().filter(st -> st.getType() == StatisticType.TOTAL_COUNT).findFirst();
        Optional<Statistic> nullCnt = stats.stream().filter(st -> st.getType() == StatisticType.NULL_COUNT).findFirst();
        if (totalCnt.isPresent() && nullCnt.isPresent()) {
            long totalCount = totalCnt.get().getValue().longValue();
            long nullCount = nullCnt.get().getValue().longValue();
            return totalCount == 0L || nullCount == totalCount ? 1.0f : (float)nullCount / (float)totalCount;
        }
        return 0.0f;
    }
}

