/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.targets;

import com.ibm.smarts.fields.recommender.core.AnalysisStep;
import com.ibm.smarts.fields.recommender.core.targets.TargetsAnalysisContext;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import com.ibm.smarts.schema.FieldsRecommendation;
import com.ibm.smarts.schema.FieldsRecommendationType;
import com.ibm.smarts.schema.util.Builder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Emsemble
implements AnalysisStep<TargetsAnalysisContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Emsemble.class);

    @Override
    public void execute(@Nonnull TargetsAnalysisContext tac) {
        FieldsRecommendation recommendation = (FieldsRecommendation)Builder.create(FieldsRecommendation.class).with(fr -> fr.setType(FieldsRecommendationType.TARGET)).build();
        ArrayList records = new ArrayList(tac.getTargetCandidates().size());
        tac.getTargetCandidates().forEach(t -> {
            if (Float.compare(t.getStatsScore(), 0.0f) >= 0) {
                t.setStatsScore((float)(1.0 - Math.exp(-t.getStatsScore())));
                t.setConfidence((float)((double)t.getConceptScore() * 0.3 + (double)t.getStatsScore() * 0.7));
                if ("_global_calculations".equals(t.getTableID())) {
                    t.setConfidence((float)Math.min(1.0, 2.0 * (double)t.getConfidence()));
                }
                records.add(Builder.create(FieldRecommendationRecord.class).with(frr -> frr.setFieldID(t.getField().getId())).with(frr -> frr.setFieldIDForExpression(t.getField().getIdForExpression())).with(frr -> frr.setTableID(t.getTableID())).with(frr -> frr.setConfidence(t.getConfidence())).build());
            } else {
                LOGGER.info("purged field [{}] in dataset [{}]", (Object)t.getField().getId(), (Object)t.getTableID());
            }
        });
        List results = records.stream().sorted(Comparator.comparing(FieldRecommendationRecord::getConfidence).reversed().thenComparing(FieldRecommendationRecord::getFieldID)).collect(Collectors.toList());
        recommendation.getRecommendedFields().addAll(results);
        tac.setRecommenddation(recommendation);
    }
}

