/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.targets;

import com.ibm.smarts.fields.recommender.core.FieldInsightsDiscoverer;
import com.ibm.smarts.fields.recommender.core.targets.Emsemble;
import com.ibm.smarts.fields.recommender.core.targets.NumericMetadataEvaluation;
import com.ibm.smarts.fields.recommender.core.targets.TargetsAnalysisContext;
import com.ibm.smarts.fields.recommender.core.targets.TargetsCandidateDiscovery;
import com.ibm.smarts.fields.recommender.core.targets.TargetsDiscoveryPipeline;
import com.ibm.smarts.fields.recommender.core.targets.TargetsInputScopeValidation;
import com.ibm.smarts.schema.FieldsRecommendation;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetsDiscoverer
implements FieldInsightsDiscoverer<TargetsAnalysisContext, FieldsRecommendation> {
    private final TargetsDiscoveryPipeline pipeline = this.constructPipeline();
    private static final Logger LOGGER = LoggerFactory.getLogger(TargetsDiscoverer.class);

    private TargetsDiscoveryPipeline constructPipeline() {
        TargetsDiscoveryPipeline pl = new TargetsDiscoveryPipeline();
        pl.register(new TargetsInputScopeValidation());
        pl.register(new TargetsCandidateDiscovery());
        pl.register(new NumericMetadataEvaluation());
        pl.register(new Emsemble());
        return pl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsRecommendation recommend(@Nonnull TargetsAnalysisContext tac) {
        Instant before = Instant.now();
        try {
            this.pipeline.getIterator().forEachRemaining(step -> {
                Instant b = Instant.now();
                step.execute(tac);
                LOGGER.warn(String.format("%s step took [%s]ms", step.getName(), Duration.between(b, Instant.now()).toMillis()));
            });
            LOGGER.warn(String.format("** Interesting fields recommendation took [%s]ms", Duration.between(before, Instant.now()).toMillis()));
            FieldsRecommendation fieldsRecommendation = tac.getFieldsRecommendation();
            return fieldsRecommendation;
        }
        finally {
            tac.dispose();
        }
    }
}

