/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.prescriptive.recommender.internal;

import com.ibm.smarts.prescriptive.recommender.api.GoalSpecifications;
import com.ibm.smarts.prescriptive.recommender.api.IPrescription;
import com.ibm.smarts.prescriptive.recommender.api.Metric;
import com.ibm.smarts.prescriptive.recommender.api.MetricType;
import com.ibm.smarts.prescriptive.recommender.api.Prescription;
import com.ibm.smarts.prescriptive.recommender.api.PrescriptionItem;
import com.ibm.smarts.prescriptive.recommender.api.TargetValueType;
import com.ibm.smarts.prescriptive.recommender.internal.PrescriptiveException;
import com.ibm.smarts.prescriptive.recommender.internal.PrescriptiveStatus;
import com.ibm.smarts.prescriptive.recommender.ml.IRegressor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrescriptiveIssuer {
    private static final int NUMBER_OF_STEPS = 50;
    static final Logger LOGGER = LoggerFactory.getLogger(PrescriptiveIssuer.class);
    private IRegressor regressor;
    private GoalSpecifications goalSpec;
    private double targetValue;
    private double originalValue;

    public PrescriptiveIssuer(IRegressor regressor, GoalSpecifications goalSpec, double targetValue, double originalValue) {
        this.regressor = regressor;
        this.goalSpec = goalSpec;
        this.targetValue = targetValue;
        this.originalValue = originalValue;
    }

    public List<IPrescription> getPrescriptions(int numberOfPrescriptions) throws PrescriptiveException {
        int colNo = this.regressor.getInputSize();
        double[] values = new double[colNo];
        double[] maxValues = new double[colNo];
        double[] minValues = new double[colNo];
        LinkedList<Integer> colIndexes = new LinkedList<Integer>();
        for (int c = 0; c < colNo; ++c) {
            values[c] = this.goalSpec.getTargetRow().get(this.regressor.getFeatureColumnsIndexes().get(c)).doubleValue();
            maxValues[c] = this.regressor.getInputColStatistics().get(c + 1).getMax();
            minValues[c] = this.regressor.getInputColStatistics().get(c + 1).getMin();
            colIndexes.add(c);
        }
        double[] stepSzie = this.getStepSize(maxValues, minValues);
        ArrayList<IPrescription> prescriptions = new ArrayList<IPrescription>();
        for (int i = 0; i < numberOfPrescriptions; ++i) {
            prescriptions.add(this.prescriptionsSeek(stepSzie, colNo, values, maxValues, minValues, colIndexes));
            int temp = (Integer)colIndexes.get(0);
            colIndexes.remove(0);
            colIndexes.add(temp);
        }
        return prescriptions;
    }

    private IPrescription prescriptionsSeek(double[] stepSzie, int colNo, double[] originalValues, double[] maxValues, double[] minValues, List<Integer> colIndexes) throws PrescriptiveException {
        int colIdx;
        double[][] row = new double[colNo][1];
        double[] values = new double[colNo];
        for (int c = 0; c < colNo; ++c) {
            values[c] = originalValues[c];
            row[c][0] = values[c];
        }
        double calibrationFactor = this.regressor.predict(row) - this.originalValue;
        LOGGER.debug("calibrate factor for value {} is {}", (Object)this.originalValue, (Object)calibrationFactor);
        double newPredict = Double.NaN;
        Iterator<Integer> iterator = colIndexes.iterator();
        while (iterator.hasNext() && !this.isTargetAchieved(newPredict = this.prescriptionsSeekForCol(colIdx = iterator.next().intValue(), stepSzie, values, maxValues, minValues, row, calibrationFactor))) {
            for (int c = 0; c < colNo; ++c) {
                row[c][0] = values[c];
            }
        }
        return this.createPrescription(colNo, values, newPredict);
    }

    private double searchByIncreasing(double[][] row, int colIdx, double[] maxValues, double calibrationFactor, double[] stepSzie, double[] values) throws PrescriptiveException {
        double predict = this.regressor.predict(row) - calibrationFactor;
        double newPredict = Double.NaN;
        for (int i = 0; i < 50 && !(row[colIdx][0] >= maxValues[colIdx]) && !this.isTargetAchieved(newPredict); ++i) {
            double[] dArray = row[colIdx];
            dArray[0] = dArray[0] + stepSzie[colIdx];
            if (row[colIdx][0] > maxValues[colIdx]) {
                row[colIdx][0] = maxValues[colIdx];
            }
            if (!this.isCloserToTarget(predict, newPredict = this.regressor.predict(row) - calibrationFactor)) continue;
            values[colIdx] = row[colIdx][0];
            predict = newPredict;
        }
        return predict;
    }

    private double searchByDecreasing(double[][] row, int colIdx, double[] minValues, double calibrationFactor, double[] stepSzie, double[] values) throws PrescriptiveException {
        double predict = this.regressor.predict(row) - calibrationFactor;
        double newPredict = Double.NaN;
        for (int i = 0; i < 50 && !(row[colIdx][0] <= minValues[colIdx]) && !this.isTargetAchieved(newPredict); ++i) {
            double[] dArray = row[colIdx];
            dArray[0] = dArray[0] - stepSzie[colIdx];
            if (row[colIdx][0] < minValues[colIdx]) {
                row[colIdx][0] = minValues[colIdx];
            }
            if (!this.isCloserToTarget(predict, newPredict = this.regressor.predict(row) - calibrationFactor)) continue;
            values[colIdx] = row[colIdx][0];
            predict = newPredict;
        }
        return predict;
    }

    private double prescriptionsSeekForCol(int colIdx, double[] stepSzie, double[] values, double[] maxValues, double[] minValues, double[][] row, double calibrationFactor) throws PrescriptiveException {
        double orignalColValue = values[colIdx];
        double predictIncreasing = this.searchByIncreasing(row, colIdx, maxValues, calibrationFactor, stepSzie, values);
        if (this.isTargetAchieved(predictIncreasing)) {
            return predictIncreasing;
        }
        double valueIncreasing = values[colIdx];
        row[colIdx][0] = orignalColValue;
        double predictDecreasing = this.searchByDecreasing(row, colIdx, minValues, calibrationFactor, stepSzie, values);
        if (this.isTargetAchieved(predictDecreasing)) {
            return predictDecreasing;
        }
        MetricType metricType = this.goalSpec.getMetric().getMetricType();
        return this.findClosestToTarget(colIdx, values, predictIncreasing, valueIncreasing, predictDecreasing, metricType);
    }

    private double findClosestToTarget(int colIdx, double[] values, double predictIncreasing, double valueIncreasing, double predictDecreasing, MetricType metricType) {
        double predict;
        if (metricType == MetricType.INCREASE) {
            if (predictIncreasing > predictDecreasing) {
                values[colIdx] = valueIncreasing;
                predict = predictIncreasing;
            } else {
                predict = predictDecreasing;
            }
        } else if (predictIncreasing > predictDecreasing) {
            predict = predictDecreasing;
        } else {
            values[colIdx] = valueIncreasing;
            predict = predictIncreasing;
        }
        return predict;
    }

    private IPrescription createPrescription(int colNo, double[] values, double newPredict) throws PrescriptiveException {
        boolean goalAchieved = this.isTargetAchieved(newPredict);
        List<Integer> featureColumnsId = this.regressor.getFeatureColumnsIndexes();
        ArrayList<PrescriptionItem> prescriptionItems = new ArrayList<PrescriptionItem>();
        for (int c = 0; c < colNo; ++c) {
            double newFeatureValue;
            double featureValue = this.goalSpec.getTargetRow().get(featureColumnsId.get(c)).doubleValue();
            if (featureValue == (newFeatureValue = values[c])) continue;
            prescriptionItems.add(new PrescriptionItem(this.regressor.getColId(featureColumnsId.get(c)), this.createMetric(featureValue, newFeatureValue)));
        }
        double targetOriginalValue = this.goalSpec.getTargetRow().get(this.regressor.getTragetColumnIndex()).doubleValue();
        Metric prescriptionMetric = this.createMetric(targetOriginalValue, newPredict);
        return new Prescription(goalAchieved, prescriptionMetric, prescriptionItems);
    }

    private Metric createMetric(double oldValue, double newValue) {
        Metric metric = oldValue < newValue ? new Metric(MetricType.INCREASE, newValue - oldValue, TargetValueType.COUNT) : new Metric(MetricType.DECREASE, oldValue - newValue, TargetValueType.COUNT);
        return metric;
    }

    private double[] getStepSize(double[] maxValues, double[] minValues) throws PrescriptiveException {
        if (maxValues.length != minValues.length || minValues.length < 1) {
            throw new PrescriptiveException(PrescriptiveStatus.SIZE_IS_INCORRECT);
        }
        int inputSize = maxValues.length;
        double[] stepSize = new double[inputSize];
        for (int i = 0; i < inputSize; ++i) {
            stepSize[i] = (maxValues[i] - minValues[i]) / 50.0;
        }
        return stepSize;
    }

    private boolean isTargetAchieved(double predectedValue) throws PrescriptiveException {
        MetricType metricType = this.goalSpec.getMetric().getMetricType();
        return metricType == MetricType.INCREASE && predectedValue >= this.targetValue || metricType == MetricType.DECREASE && predectedValue <= this.targetValue;
    }

    private boolean isCloserToTarget(double oldPredectedValue, double newPredectedValue) {
        MetricType metricType = this.goalSpec.getMetric().getMetricType();
        return metricType == MetricType.INCREASE && newPredectedValue > oldPredectedValue || metricType == MetricType.DECREASE && newPredectedValue < oldPredectedValue;
    }
}

