/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.similarity.classifier.common.core;

import com.ibm.smarts.similarity.classifier.common.core.NormedVector;
import com.ibm.smarts.similarity.classifier.common.core.VectorUtility;

public class WordEmbeddingUtility {
    private WordEmbeddingUtility() {
    }

    public static double cosine(float[] x, float[] y) {
        double normX = VectorUtility.norm(x);
        double normY = VectorUtility.norm(y);
        if (normX == 0.0 || normY == 0.0) {
            return 0.0;
        }
        return VectorUtility.dot(x, y) / (normX * normY);
    }

    public static double cosine(NormedVector x, NormedVector y) {
        double normX = x.getNorm();
        double normY = y.getNorm();
        if (normX == 0.0 || normY == 0.0) {
            return 0.0;
        }
        return VectorUtility.dot(x.getVector(), y.getVector()) / (normX * normY);
    }
}

