/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.content;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.core.impl.content.CaContentRestClient;
import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.Ensure;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.common.content.ContentObject;
import com.ibm.smarts.schema.util.JAXBHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.core.MediaType;

public class CaMoserRestClient
extends CaRestClient {
    public CaMoserRestClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        super(rccf, requestContext, uri);
    }

    public CompletableFuture<String> postFileAsync(String filename, InputStream data) {
        String path = "/bi/v1/metadata/base_modules/files";
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("filename", new String[]{filename});
        MediaType mediaType = filename.contains(".xls") ? MediaType.APPLICATION_XML_TYPE : MediaType.TEXT_PLAIN_TYPE;
        return this.postAsync(path, data, queryParams, mediaType).thenApply(json -> {
            String id = this.parseId((String)json);
            this.notifyCreated(id, filename, "uploadedFile");
            return id;
        });
    }

    public String postFile(String filename, InputStream data) {
        CompletableFuture<String> future = this.postFileAsync(filename, data);
        return (String)this.get(future);
    }

    public CompletableFuture<Module> getBaseModuleMetadataAsync(String baseModuleId) {
        String path = String.format("/bi/v1/metadata/base_modules/%s/metadata?shortIdForExpression=true", baseModuleId);
        return this.getAsync(path).thenApply(json -> this.parseModule((String)json));
    }

    public Module getBaseModuleMetadata(String baseModuleId) {
        CompletableFuture<Module> future = this.getBaseModuleMetadataAsync(baseModuleId);
        return (Module)this.get(future);
    }

    public CompletableFuture<String> postBusinessModuleAsync(Module module, String location) {
        String moduleContent;
        Ensure.notNull((String)"module", (Object)module);
        Ensure.nonBlank((String)"location", (String)location);
        try {
            moduleContent = MAPPER.writeValueAsString((Object)module);
        }
        catch (JsonProcessingException e) {
            throw new InternalException((Throwable)e, "Failed to post business module.", new Object[0]);
        }
        String path = "/bi/v1/metadata/modules";
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("location", new String[]{location});
        return this.postAsync("/bi/v1/metadata/modules", moduleContent, queryParams).thenApply(json -> this.parseId((String)json));
    }

    public String postBusinessModule(Module module, String location) {
        CompletableFuture<String> future = this.postBusinessModuleAsync(module, location);
        return (String)this.get(future);
    }

    public CompletableFuture<String> updateBusinessModuleAsync(String moduleId, Module module) {
        String moduleContent;
        Ensure.notNull((String)"module", (Object)module);
        Ensure.nonBlank((String)"moduleId", (String)moduleId);
        try {
            moduleContent = MAPPER.writeValueAsString((Object)module);
        }
        catch (JsonProcessingException e) {
            throw new InternalException((Throwable)e, "Failed to update business module.", new Object[0]);
        }
        String path = Paths.modulePath(moduleId);
        return this.putAsync(path, moduleContent).thenApply(json -> json);
    }

    public String updateBusinessModule(String moduleId, Module module) {
        CompletableFuture<String> future = this.updateBusinessModuleAsync(moduleId, module);
        return (String)this.get(future);
    }

    public CompletableFuture<Module> getBusinessModuleAsync(String businessModuleId) {
        String path = Paths.modulePath(businessModuleId);
        return this.getAsync(path).thenApply(json -> this.parseModule((String)json));
    }

    public Module getBusinessModule(String businessModuleId) {
        CompletableFuture<Module> future = this.getBusinessModuleAsync(businessModuleId);
        return (Module)this.get(future);
    }

    public CompletableFuture<Module> getBusinessModuleMetadataAsync(String businessModuleId) {
        String path = Paths.moduleMetadataPath(businessModuleId);
        return this.getAsync(path).thenApply(json -> this.parseModule((String)json));
    }

    public Module getBusinessModuleMetadata(String businessModuleId) {
        CompletableFuture<Module> future = this.getBusinessModuleMetadataAsync(businessModuleId);
        return (Module)this.get(future);
    }

    public CompletableFuture<Boolean> deleteModuleAsync(String moduleId) {
        String path = String.format("/bi/v1/metadata/modules/%s", moduleId);
        return this.deleteAsync(path).thenApply(json -> {
            this.notifyDeleted(moduleId);
            return Boolean.TRUE;
        });
    }

    public Boolean deleteModule(String moduleId) {
        CompletableFuture<Boolean> future = this.deleteModuleAsync(moduleId);
        return (Boolean)this.get(future);
    }

    public CompletableFuture<List<ContentObject>> getDatasourceSchemasAsync(String connectionId, String ... fields) {
        String path = Paths.sourceSchemasPath(connectionId);
        return this.getAsync(path).thenApply(json -> CaContentRestClient.parseObjects(json, fields));
    }

    public List<ContentObject> getDatasourceSchemas(String connectionId, String ... fields) {
        CompletableFuture<List<ContentObject>> future = this.getDatasourceSchemasAsync(connectionId, fields);
        return (List)this.get(future);
    }

    public CompletableFuture<ContentObject> getDatasourceSchemaAsync(String connectionId, String schemaName, String ... fields) {
        return this.getDatasourceSchemasAsync(connectionId, fields).thenApply(schemas -> {
            ContentObject result = null;
            for (ContentObject schema : schemas) {
                if (!schemaName.equals(schema.defaultName)) continue;
                result = schema;
                break;
            }
            return result;
        });
    }

    public ContentObject getDatasourceSchema(String connectionId, String schemaName, String ... fields) {
        CompletableFuture<ContentObject> future = this.getDatasourceSchemaAsync(connectionId, schemaName, fields);
        return (ContentObject)this.get(future);
    }

    public CompletableFuture<String> postDatasourceSchemaAsync(String connectionId, String catalog, String defaultName, String schema, String schemaType, String type) {
        String path = Paths.sourceSchemasPath(connectionId);
        JSONObject schemaObject = new JSONObject();
        schemaObject.put((Object)"catalog", (Object)catalog);
        schemaObject.put((Object)"defaultName", (Object)defaultName);
        schemaObject.put((Object)"schema", (Object)schema);
        schemaObject.put((Object)"schemaType", (Object)schemaType);
        schemaObject.put((Object)"status", (Object)"pending");
        schemaObject.put((Object)"type", (Object)type);
        return this.postAsync(path, schemaObject.toString()).thenApply(json -> json);
    }

    public String postDatasourceSchema(String connectionId, String catalog, String defaultName, String schema, String schemaType, String type) {
        CompletableFuture<String> future = this.postDatasourceSchemaAsync(connectionId, catalog, defaultName, schema, schemaType, type);
        return (String)this.get(future);
    }

    public CompletableFuture<String> loadSchemaMetadataAsync(String schemaId) {
        String path = Paths.baseModulePath(schemaId);
        return this.postAsync(path, null).thenApply(json -> json);
    }

    public String loadSchemaMetadata(String schemaId) {
        CompletableFuture<String> future = this.loadSchemaMetadataAsync(schemaId);
        return (String)this.get(future);
    }

    public CompletableFuture<List<ContentObject>> getModulesAsync() {
        return this.getAsync("/bi/v1/metadata/modules").thenApply(json -> this.parseModuleInfoList((String)json));
    }

    public List<ContentObject> getModules() {
        CompletableFuture<List<ContentObject>> future = this.getModulesAsync();
        return (List)this.get(future);
    }

    private List<ContentObject> parseModuleInfoList(String json) {
        ArrayList<ContentObject> moduleList = new ArrayList<ContentObject>();
        try {
            JSONArray jsonList = JSONArray.parse((String)json);
            for (int i = 0; i < jsonList.size(); ++i) {
                JSONObject obj = (JSONObject)jsonList.get(i);
                ContentObject content = new ContentObject((String)obj.get((Object)"id"), "module", (String)obj.get((Object)"name"), Long.valueOf("1"));
                JSONArray ancestors = (JSONArray)obj.get((Object)"ancestors");
                content.addField("location", this.parseLocationfromAncestors(ancestors));
                moduleList.add(content);
            }
            return moduleList;
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e, "Failed to parse mdoule list from response json.", new Object[0]);
        }
    }

    private String parseLocationfromAncestors(JSONArray ancestors) {
        StringBuilder location = new StringBuilder();
        for (int j = 0; j < ancestors.size(); ++j) {
            JSONObject ancestor = (JSONObject)ancestors.get(j);
            String type = (String)ancestor.get((Object)"type");
            if (!"folder".equals(type) && !"content".equals(type)) continue;
            if (location.length() > 0) {
                location.append(" > ");
            }
            location.append((String)ancestor.get((Object)"name"));
        }
        return location.toString();
    }

    private String parseId(String json) {
        try {
            JSONObject jsonObject = JSONObject.parse((String)json);
            return (String)jsonObject.get((Object)"id");
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e, "Failed to parse id from response json.", new Object[0]);
        }
    }

    private Module parseModule(String json) {
        try {
            return (Module)JAXBHelper.unmarshalJaxbAnnotatedObjectFromJSON(Module.class, (String)json);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e, "Failed to parse response JSON into Module: " + json, new Object[0]);
        }
    }

    public static class ModuleTypes {
        public static final String UPLOADED_FILE = "uploadedFile";
        public static final String MODULE = "module";
    }

    public static class Paths {
        public static final String METADATA = "/bi/v1/metadata";
        public static final String BASE_MODULES = "/bi/v1/metadata/base_modules";
        public static final String BASE_MODULE = "/bi/v1/metadata/base_modules/%s";
        public static final String BASE_MODULE_FILES = "/bi/v1/metadata/base_modules/files";
        public static final String BASE_MODULE_METADATA = "/bi/v1/metadata/base_modules/%s/metadata?shortIdForExpression=true";
        public static final String MODULES = "/bi/v1/metadata/modules";
        public static final String MODULE = "/bi/v1/metadata/modules/%s";
        public static final String MODULE_METADATA = "/bi/v1/metadata/modules/%s/metadata?shortIdForExpression=true";
        public static final String SOURCES = "/bi/v1/metadata/sources";
        public static final String SOURCE_SCHEMAS = "/bi/v1/metadata/sources/%s/schemas";

        public static String modulePath(String id) {
            return String.format(MODULE, id);
        }

        public static String moduleMetadataPath(String id) {
            return String.format(MODULE_METADATA, id);
        }

        public static String sourceSchemasPath(String id) {
            return String.format(SOURCE_SCHEMAS, id);
        }

        public static String baseModulePath(String id) {
            return String.format(BASE_MODULE, id);
        }
    }
}

