/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.modeling;

import com.ibm.smarts.ca.core.impl.SmartsCaCoreHelper;
import com.ibm.smarts.ca.core.impl.modeling.ModuleProposalsResponse;
import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.RequestContext;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public class CaSmartsModelingClient
extends CaRestClient {
    public CaSmartsModelingClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        super(rccf, requestContext, uri);
    }

    public CompletableFuture<ModuleProposalsResponse> getModuleProposalsAsync(String intent, String moduleUri, int maxNumberOfProposals) {
        String path = "/bi/v1/smarts/modeling/module-proposals";
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("intent", new String[]{intent});
        queryParams.add("moduleUri", new String[]{moduleUri});
        queryParams.add("maxNumberOfProposals", new String[]{String.valueOf(maxNumberOfProposals)});
        return this.getAsync(path, queryParams).thenApply(json -> (ModuleProposalsResponse)CommonJAXBHelper.unmarshalFromJSON(ModuleProposalsResponse.class, (String)json));
    }

    public ModuleProposalsResponse getModuleProposals(String intent, String moduleUri, int maxNumberOfProposals) {
        CompletableFuture<ModuleProposalsResponse> future = this.getModuleProposalsAsync(intent, moduleUri, maxNumberOfProposals);
        return (ModuleProposalsResponse)this.get(future);
    }

    public CompletableFuture<ModuleProposalsResponse> getModuleProposalsByIdAsync(String intent, String moduleId, int maxNumberOfProposals) {
        return this.getModuleProposalsAsync(intent, SmartsCaCoreHelper.buildModuleUriPath(moduleId), maxNumberOfProposals);
    }

    public ModuleProposalsResponse getModuleProposalsById(String intent, String moduleId, int maxNumberOfProposals) {
        return this.getModuleProposals(intent, SmartsCaCoreHelper.buildModuleUriPath(moduleId), maxNumberOfProposals);
    }

    public CompletableFuture<ModuleProposalsResponse> getJoinProposalsByIdAsync(String moduleId, Collection<String> querySubjects, int maxNumberOfProposals) {
        String path = String.format("/bi/v1/smarts/modeling/module/%s/join-proposals", moduleId);
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("maxNumberOfProposals", new String[]{String.valueOf(maxNumberOfProposals)});
        queryParams.add("querySubjects", querySubjects.toArray(new String[querySubjects.size()]));
        return this.getAsync(path, queryParams).thenApply(json -> ModuleProposalsResponse.fromJson(json));
    }

    public ModuleProposalsResponse getJoinProposalsById(String moduleId, Collection<String> querySubjects, int maxNumberOfProposals) {
        CompletableFuture<ModuleProposalsResponse> future = this.getJoinProposalsByIdAsync(moduleId, querySubjects, maxNumberOfProposals);
        return (ModuleProposalsResponse)this.get(future);
    }

    public static class Paths {
        public static final String SMARTS_MODELING = "/bi/v1/smarts/modeling";
        public static final String SMARTS_MODULE_PROPOSALS = "/bi/v1/smarts/modeling/module-proposals";
        public static final String SMARTS_MODULE_JOIN_PROPOSALS = "/bi/v1/smarts/modeling/module/%s/join-proposals";
    }
}

