/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.store;

import com.ibm.smarts.ca.core.impl.SmartsCaClientManager;
import com.ibm.smarts.ca.core.impl.content.CaContentRestClient;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.util.JaxRs20Helper;
import com.ibm.smarts.core.util.ObjectCreator;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.store.api.provider.IPersistenceProvider;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;

public class SmartsCaPersistenceProvider
implements IPersistenceProvider {
    @Nonnull
    public SmartsModule getProgress(@Nonnull RequestContext requestContext, @Nonnull String moduleId, @Nonnull AnalysisScope analysisScope, @Nonnull SmartsModuleOptions smartsModuleOptions) {
        Function<CaContentRestClient, SmartsModule> func = c -> c.fetchStatus(moduleId, analysisScope, smartsModuleOptions);
        return this.execute(requestContext, func);
    }

    public IRecord<SmartsModule> get(RequestContext requestContext, String moduleId, List<String> tags, SmartsModuleOptions smartsModuleOptions) {
        Function<CaContentRestClient, IRecord> func = c -> c.getSmartsModuleRecord(moduleId, tags, smartsModuleOptions);
        return this.execute(requestContext, func);
    }

    public CompletableFuture<IRecord<SmartsModule>> getAsync(RequestContext requestContext, String moduleId, List<String> tags, SmartsModuleOptions smartsModuleOptions) {
        Function<CaContentRestClient, CompletableFuture> func = c -> c.getSmartsModuleRecordAsync(moduleId, tags, smartsModuleOptions);
        return this.execute(requestContext, func);
    }

    public StoreStatus create(RequestContext requestContext, String smartsModuleName, IRecord<SmartsModule> moduleRecord, List<String> tags) {
        return this.createOrReplace(requestContext, smartsModuleName, moduleRecord, tags, null);
    }

    public StoreStatus update(RequestContext requestContext, String smartsModuleName, IRecord<SmartsModule> moduleRecord, List<String> tags, String resourceURI) {
        return this.createOrReplace(requestContext, smartsModuleName, moduleRecord, tags, resourceURI);
    }

    public StoreStatus delete(RequestContext requestContext, String moduleId, String moduleRecordVersion, List<String> listUri) {
        Function<CaContentRestClient, Boolean> func = listUri != null && !listUri.isEmpty() ? c -> c.deleteSmartsModule(listUri) : c -> c.deleteSmartsModule(moduleId);
        return new StoreStatus(this.execute(requestContext, func).booleanValue(), Collections.emptyList());
    }

    public SmartsModule getById(RequestContext requestContext, String moduleId) {
        Function<CaContentRestClient, SmartsModule> func = c -> c.getObjectSmartsModule(moduleId);
        return this.execute(requestContext, func);
    }

    public SmartsModule getByIdAndTags(RequestContext requestContext, String moduleId, List<String> tags, SmartsModuleOptions smartsModuleOptions) {
        Function<CaContentRestClient, SmartsModule> func = c -> c.getObjectSmartsModule(moduleId, tags, smartsModuleOptions);
        return this.execute(requestContext, func);
    }

    public StoreStatus createOrReplace(RequestContext requestContext, String smartsModuleName, IRecord<SmartsModule> moduleRecord, List<String> tags, String resourceURI) {
        Function<CaContentRestClient, Response> func = resourceURI == null ? c -> c.createObjectSmartsModule(moduleRecord.getId(), smartsModuleName, (SmartsModule)moduleRecord.getRecord(), tags, true) : c -> c.updateObjectSmartsModule(resourceURI, smartsModuleName, (SmartsModule)moduleRecord.getRecord(), moduleRecord.getRecordVersion(), tags);
        Response response = this.execute(requestContext, func);
        if (JaxRs20Helper.statusInFamily((Response)response, (Response.Status.Family)Response.Status.Family.SUCCESSFUL)) {
            String resource = JaxRs20Helper.getHeaderString((Response)response, (String)"Location");
            return new StoreStatus(true, Collections.emptyList(), resource);
        }
        Object entity = response.getEntity();
        String responseString = entity == null ? null : entity.toString();
        InternalException e = new InternalException(responseString, new Object[0]);
        return new StoreStatus(false, Collections.singletonList(e));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(RequestContext requestContext, Function<CaContentRestClient, T> func) {
        try (SmartsCaClientManager cm = (SmartsCaClientManager)((Object)((ObjectCreator)requestContext.getRequestAttribute("com.ibm.smarts.rest.clientManager")).create(requestContext));){
            CaContentRestClient caContentRestClient = func.apply(cm.getContentClient());
            return (T)((Object)caContentRestClient);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e, "Failed to close CaContentRestClient.", new Object[0]);
        }
    }
}

