/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.useractions;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.ca.core.rest.client.CaRestClient;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.RequestContext;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaUserActionRestClient
extends CaRestClient {
    public static final String JSON_FIELD_ID = "id";
    public static final String JSON_FIELD_CONTENT = "smartscontent";
    private static final Logger LOGGER = LoggerFactory.getLogger(CaUserActionRestClient.class);

    public CaUserActionRestClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        super(rccf, requestContext, uri);
    }

    public CompletableFuture<JSONObject> getUserActionStoredAsync(String type) {
        String path = Paths.userActionStoragePath(type);
        return this.getAsync(path).thenApply(json -> this.parseJson((String)json));
    }

    public CompletableFuture<String> getUserActionStoredAsyncAsJsonString(String type) {
        String path = Paths.userActionStoragePath(type);
        return this.getAsync(path);
    }

    private JSONObject parseJson(String json) {
        try {
            JSONArray jsonArray = JSONArray.parse((String)json);
            if (!jsonArray.isEmpty()) {
                return (JSONObject)jsonArray.get(0);
            }
            return null;
        }
        catch (IOException e) {
            LOGGER.warn("User action storage failed to parse expected JSON response: " + json);
            return null;
        }
    }

    public void putUserActionStoredAsync(JSONObject jsonBlob, String type) {
        String itemId = this.getItemId(type);
        if (itemId != null) {
            String path = Paths.userActionStoragePath(type, itemId);
            this.putAsync(path, jsonBlob.toString());
        } else {
            String path = Paths.userActionStoragePath(type);
            this.postAsync(path, jsonBlob.toString());
        }
    }

    public void putUserActionStoredAsync(String json, String type) {
        String itemId = this.getItemId(type);
        if (itemId != null) {
            String path = Paths.userActionStoragePath(type, itemId);
            this.putAsync(path, json);
        } else {
            String path = Paths.userActionStoragePath(type);
            this.postAsync(path, json);
        }
    }

    private String getItemId(String type) {
        JSONObject currentJsonBlob = null;
        try {
            currentJsonBlob = this.getUserActionStoredAsync(type).get();
        }
        catch (Exception e) {
            LOGGER.error("Exception while doing 'get' on user profile service: ", (Throwable)e);
            return null;
        }
        if (currentJsonBlob != null && currentJsonBlob.containsKey((Object)JSON_FIELD_ID)) {
            return (String)currentJsonBlob.get((Object)JSON_FIELD_ID);
        }
        return null;
    }

    public void deleteUserActionStored(String type) {
        String itemId = null;
        do {
            if ((itemId = this.getItemId(type)) == null) continue;
            String path = Paths.userActionStoragePath(type, itemId);
            this.delete(path);
        } while (itemId != null);
    }

    public static class Paths {
        public static final String USERS = "/bi/v1/users/~";

        public static String userActionStoragePath(String id) {
            return "/bi/v1/users/~/" + id;
        }

        public static String userActionStoragePath(String id, String itemId) {
            return "/bi/v1/users/~/" + id + "/" + itemId;
        }
    }
}

