/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.rest.client.simple;

import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class SimpleRestClientConfig {
    protected String scheme = "http";
    protected String server = "localhost";
    protected String pathRoot = "";
    protected int port = 80;
    protected URI baseURI;
    protected Map<String, Header> requestHeaders = new HashMap<String, Header>();

    public void setRequestHeader(String name, String value) {
        if (value == null) {
            this.requestHeaders.remove(name.toLowerCase());
        } else {
            this.requestHeaders.put(name.toLowerCase(), (Header)new BasicHeader(name, value));
        }
    }

    public void clearRequestHeaders() {
        this.requestHeaders.clear();
    }

    public Collection<Header> getRequestHeaders() {
        return this.requestHeaders.values();
    }

    public Header getRequestHeader(String name) {
        return this.requestHeaders.get(name.toLowerCase());
    }

    public URI getBaseURI() throws URISyntaxException {
        if (this.baseURI == null) {
            URI hostURI = new URI(this.scheme, null, this.server, this.port, "/", null, null);
            String path = this.pathRoot;
            if (path != null && !path.isEmpty()) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                this.baseURI = hostURI.resolve(path);
            } else {
                this.baseURI = hostURI;
            }
        }
        return this.baseURI;
    }

    public List<HttpCookie> getCookies() {
        Header cookieHeader = this.getRequestHeader("cookie");
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        if (cookieHeader != null && cookieHeader.getValue() != null && !cookieHeader.getValue().isEmpty()) {
            String[] cookieStrings;
            for (String cookieString : cookieStrings = cookieHeader.getValue().split(";")) {
                String[] cookieParts;
                if (!StringUtils.isNotBlank((CharSequence)cookieString) || (cookieParts = cookieString.split("=")) == null || cookieParts.length != 2 || !StringUtils.isNotBlank((CharSequence)cookieParts[0].trim()) || !StringUtils.isNotBlank((CharSequence)cookieParts[1].trim())) continue;
                HttpCookie cookie = HttpCookie.parse(cookieString).get(0);
                cookies.add(cookie);
            }
        }
        return cookies;
    }
}

