/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.rest.client.util;

import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.WebApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletableFutureHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletableFutureHelper.class);

    private CompletableFutureHelper() {
    }

    public static <T> T get(CompletableFuture<T> mf) throws WebApplicationException {
        try {
            return mf.get();
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted getting value from future", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new InternalException((Throwable)e, "Interrupted getting value from future", new Object[0]);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof JaxRs20Exceptions.ProcessingException) {
                JaxRs20Exceptions.ProcessingException rpex = (JaxRs20Exceptions.ProcessingException)cause;
                throw rpex;
            }
            if (cause instanceof WebApplicationException) {
                throw (WebApplicationException)cause;
            }
            LOGGER.error(String.format("REST call failed caused by: %s", cause.getMessage()), cause);
            throw new InternalException(cause, String.format("REST call failed caused by: %s", cause.getMessage()), new Object[0]);
        }
    }
}

