/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.rest.server;

import com.ibm.smarts.core.rest.server.RestHandlers;
import com.ibm.smarts.core.rest.server.exceptions.InvalidClientJsonException;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.Request;
import com.ibm.smarts.core.util.RequestContext;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;

public abstract class BaseRestApi
implements RestHandlers {
    @Context
    protected javax.ws.rs.core.Request request;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders httpHeaders;
    protected final DateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    protected String toString(Object o) {
        if (o == null) {
            return "NULL";
        }
        return o.toString();
    }

    protected <T> Class<T> getSubResource(Class<T> klass) {
        return klass;
    }

    protected <T> T getClientJson(String json, Class<T> klass) {
        try {
            Object ret = JsonParserHelper.fromJson((String)json, klass);
            return (T)ret;
        }
        catch (Throwable th) {
            throw new InvalidClientJsonException(json);
        }
    }

    protected Response get(RequestContext rc, CompletableFuture<Response> rf) {
        try {
            return rf.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return this.handleException(rc, e);
        }
        catch (ExecutionException e) {
            return this.handleException(rc, e);
        }
    }

    protected Response handleRest(Function<RequestContext, Response> func) {
        return this.handleRest(func, null);
    }

    protected Response handleRest(Function<RequestContext, Response> handler, Consumer<RequestContext> cleanUp) {
        try {
            RequestContext rc = this.extractRequestContext();
            return this.handleRest(this.request, this.uriInfo, this.httpHeaders, rc, handler, cleanUp);
        }
        catch (Throwable th) {
            return this.handleException(th);
        }
    }

    protected Response handleStreaming(final StreamWriterFunction handler) {
        final RequestContext rc = this.extractRequestContext();
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                handler.apply(rc, os);
                os.flush();
            }
        };
        return Response.ok((Object)stream).build();
    }

    protected RequestContext extractRequestContext() {
        Locale locale = this.getLocale();
        Locale productLocale = this.getProductLocale();
        boolean isTracing = true;
        Request req = new Request(locale, productLocale, true);
        RequestContext ret = new RequestContext(req);
        Map<String, List<String>> headers = BaseRestApi.buildHeaderMap(this.httpHeaders);
        req.setHttpHeaders(headers);
        return ret;
    }

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    protected Locale getProductLocale() {
        return Locale.getDefault();
    }

    private static Map<String, List<String>> buildHeaderMap(HttpHeaders httpHeaders) {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        MultivaluedMap mm = httpHeaders.getRequestHeaders();
        for (String key : mm.keySet()) {
            ArrayList<String> newValues = new ArrayList<String>();
            List values = httpHeaders.getRequestHeader(key);
            if (values != null) {
                for (String value : values) {
                    newValues.add(value);
                }
            }
            ret.put(key, newValues);
        }
        return ret;
    }

    protected Set<String> getFieldSet(String fields) {
        Set<String> ret;
        if (fields == null) {
            ret = new HashSet<String>();
        } else {
            List<String> list = this.splitByComma(fields);
            ret = this.set(list);
        }
        return ret;
    }

    protected Set<String> set(List<String> strings) {
        return new HashSet<String>(strings);
    }

    protected List<String> splitByComma(String fields) {
        String[] ret = null;
        if (fields != null) {
            ret = fields.split(",");
        }
        return ret == null ? null : Arrays.asList(ret);
    }

    protected boolean useGzip(HttpHeaders headers) {
        List hs = headers.getRequestHeader("Accept-Encoding");
        boolean ret = hs == null ? false : hs.contains("gzip");
        return ret;
    }

    public static interface StreamWriterFunction {
        public void apply(RequestContext var1, OutputStream var2) throws IOException, WebApplicationException;
    }
}

