/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.rest.server;

import com.ibm.smarts.core.util.RequestContext;
import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRequestLoggingHelper {
    private final Request request;
    private final UriInfo uriInfo;
    private final HttpHeaders httpHeaders;
    private final RequestContext rc;
    private static final Logger LOGGER = LoggerFactory.getLogger(RestRequestLoggingHelper.class);
    private final String prefix;

    public RestRequestLoggingHelper(Request request, UriInfo uriInfo, HttpHeaders httpHeaders, RequestContext rc) {
        this.request = request;
        this.uriInfo = uriInfo;
        this.httpHeaders = httpHeaders;
        this.rc = rc;
        this.prefix = RestRequestLoggingHelper.buildPrefix(this.request, this.uriInfo);
    }

    public void logEntry() {
        StringBuilder sb = new StringBuilder(this.prefix);
        sb.append("ENTER");
        String msg = sb.toString();
        LOGGER.info(msg);
    }

    public void logExit(Response resp) {
        StringBuilder sb = new StringBuilder(this.prefix);
        sb.append("EXIT SUCCESS");
        sb.append(" status=");
        sb.append(resp.getStatus());
        String msg = sb.toString();
        LOGGER.info(msg);
    }

    public void logExit(Throwable th) {
        StringBuilder sb = new StringBuilder(this.prefix);
        sb.append("EXIT FAILURE");
        String msg = sb.toString();
        LOGGER.info(msg);
    }

    private static String buildPrefix(Request request, UriInfo uriInfo) {
        StringBuilder sb = new StringBuilder();
        if (request != null) {
            sb.append(request.getMethod());
        } else {
            sb.append("UNKNOWN-METHOD");
        }
        sb.append(" [");
        if (uriInfo != null) {
            sb.append(uriInfo.getAbsolutePath());
            boolean decodeValues = true;
            MultivaluedMap qps = uriInfo.getQueryParameters(true);
            if (qps.size() > 0) {
                boolean firstValue = true;
                sb.append("?");
                for (String name : qps.keySet()) {
                    List values = (List)qps.get((Object)name);
                    for (String value : values) {
                        if (firstValue) {
                            firstValue = false;
                        } else {
                            sb.append("&");
                        }
                        sb.append(name);
                        sb.append("=");
                        sb.append(value);
                    }
                }
            }
        } else {
            sb.append("UNKNOWN URL");
        }
        sb.append("] ");
        String ret = sb.toString();
        return ret;
    }
}

