/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.api.content;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.content.recommender.api.content.IRColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IRCombination {
    private List<IRColumn> columnCombinations = new ArrayList<IRColumn>();
    private List<BaseFilter> filters = new ArrayList<BaseFilter>();
    private final double score;

    public void setColumnCombinations(List<IRColumn> columnCombinations) {
        this.columnCombinations = columnCombinations;
    }

    @JsonCreator
    public IRCombination(@JsonProperty(value="columnCombinations") List<IRColumn> columnCombinations, @JsonProperty(value="filters") List<BaseFilter> filters, @JsonProperty(value="score") double score) {
        if (columnCombinations != null) {
            this.columnCombinations.addAll(columnCombinations);
        }
        if (filters != null) {
            this.filters.addAll(filters);
        }
        this.score = score;
    }

    public IRCombination(IRCombination source) {
        List<BaseFilter> filters;
        List<IRColumn> combinations = source.getColumnCombinations();
        if (combinations != null) {
            this.columnCombinations.addAll(combinations);
        }
        if ((filters = source.getFilters()) != null) {
            this.filters.addAll(filters);
        }
        this.score = source.getScore();
    }

    public void setFilters(List<BaseFilter> filters) {
        this.filters.clear();
        this.filters.addAll(filters);
    }

    public List<IRColumn> getColumnCombinations() {
        return this.columnCombinations;
    }

    public List<BaseFilter> getFilters() {
        return this.filters;
    }

    public double getScore() {
        return this.score;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IRCombination)) {
            return false;
        }
        IRCombination that = (IRCombination)o;
        return Double.compare(that.getScore(), this.getScore()) == 0 && this.getColumnCombinations().equals(that.getColumnCombinations()) && Objects.equals(this.getFilters(), that.getFilters());
    }

    public int hashCode() {
        return Objects.hash(this.getColumnCombinations(), this.getFilters(), this.getScore());
    }

    public String toString() {
        return "IRCombination{columnCombinations=" + this.columnCombinations + ", filters=" + this.filters + ", score=" + this.score + '}';
    }
}

