/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.context.drivers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.ibm.smarts.content.recommender.internal.context.drivers.Driver;
import com.ibm.smarts.content.recommender.internal.context.drivers.Node;
import com.ibm.smarts.content.recommender.internal.context.drivers.Target;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DecisionTree {
    private Target target;
    private Map<String, Driver> driversMap = new HashMap<String, Driver>();
    public final Node node;

    @JsonCreator
    public DecisionTree(@JsonProperty Node node) {
        this.node = node;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public Driver getDriver(String id) {
        return this.driversMap.get(id);
    }

    public List<Driver> getDrivers() {
        return this.driversMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public void setDrivers(List<Driver> drivers) {
        drivers.forEach(d -> this.driversMap.put(d.id, (Driver)d));
    }

    public Node getNode() {
        return this.node;
    }

    public static List<DecisionTree> fromJSON(String json) {
        try {
            ArrayList<DecisionTree> trees = new ArrayList<DecisionTree>();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode obj = objectMapper.readTree(json);
            ArrayNode results = (ArrayNode)obj.get("results");
            for (JsonNode result : results) {
                JsonNode details = result.get("details");
                if (details == null) continue;
                JsonNode structure = details.get("structure");
                JsonNode fields = result.get("fields");
                JsonNode target = fields.get("target");
                Target treeTarget = (Target)objectMapper.treeToValue((TreeNode)target, Target.class);
                ArrayNode inputs = (ArrayNode)fields.get("inputs");
                Driver[] drivers = (Driver[])objectMapper.treeToValue((TreeNode)inputs, Driver[].class);
                DecisionTree tree = (DecisionTree)objectMapper.treeToValue((TreeNode)structure, DecisionTree.class);
                tree.setTarget(treeTarget);
                tree.setDrivers(Arrays.asList(drivers));
                trees.add(tree);
            }
            return trees;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }
}

