/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.compare;

import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilterType;
import com.ibm.smarts.common.modifiers.TopBottomFilteringMethod;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.content.IRColumn;
import com.ibm.smarts.content.recommender.api.content.IRCombination;
import com.ibm.smarts.content.recommender.api.content.IRContent;
import com.ibm.smarts.content.recommender.internal.CompareCardLabel;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ComparisonContext;
import com.ibm.smarts.content.recommender.internal.pipeline.compare.ComparisonUtils;
import com.ibm.smarts.content.recommender.internal.pipeline.compare.ICompareStep;
import com.ibm.smarts.content.recommender.internal.util.Pair;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RecommendFilter
implements ICompareStep {
    private static final double ADD_FILTER_CONFIDENCE = 0.8;
    private static final int FILTER_COUNT_DOMAIN_SIZE = 10;
    private static final int MAX_RESULTS = 5;
    private RequestContext requestContext;

    public RecommendFilter(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    @Override
    public void accept(ComparisonContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        IRContent inputContent = context.getInputIRContent();
        if (!inputContent.getGlobalFilters().isEmpty()) {
            return;
        }
        if (inputContent.getCombinations().stream().filter(c -> !c.getFilters().isEmpty()).findAny().isPresent()) {
            return;
        }
        inputContent.getCombinations().stream().filter(c -> !RecommendFilter.isJoin(c, context.getIndexedSmartsModule())).forEach(combination -> this.processCombination(context, inputContent, (IRCombination)combination));
    }

    private static boolean isJoin(IRCombination combo, QuickAccessSmartsModule quick) {
        DatasetInfo lastDs = null;
        for (IRColumn column : combo.getColumnCombinations()) {
            if (lastDs == null) {
                lastDs = quick.getDatasetInfo(column.getId());
                continue;
            }
            if (lastDs == quick.getDatasetInfo(column.getId())) continue;
            return true;
        }
        return false;
    }

    private void processCombination(ComparisonContext context, IRContent content, IRCombination combination) {
        List<Pair<IRColumn, ColumnInfo>> columns = combination.getColumnCombinations().stream().map(c -> {
            ColumnInfo info = context.getIndexedSmartsModule().getColumnInfo(c.getId());
            return new Pair<IRColumn, ColumnInfo>((IRColumn)c, info);
        }).filter(Objects::nonNull).filter(pair -> ((IRColumn)pair.getLeft()).getAutoGrouping() == null).collect(Collectors.toList());
        List allMeasures = columns.stream().flatMap(c -> {
            DatasetInfo dataset = context.getIndexedSmartsModule().getDatasetInfo(((ColumnInfo)c.getRight()).getIdForExpression());
            if (dataset == null) {
                return Stream.empty();
            }
            return context.getIndexedSmartsModule().getAllMeasures(dataset.getId()).stream();
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List<Pair> measures = columns.stream().filter(c -> allMeasures.contains(c.getRight())).filter(Objects::nonNull).collect(Collectors.toList());
        columns.removeAll(measures);
        if (columns.isEmpty()) {
            return;
        }
        BiConsumer<Pair, TopBottomFilterType> createFilter = (pair, type) -> {
            TopBottomFilter filter = new TopBottomFilter(((ColumnInfo)((Pair)columns.get(0)).getRight()).getIdForExpression(), type, TopBottomFilteringMethod.COUNT, ((ColumnInfo)pair.getRight()).getIdForExpression(), 10);
            filter.setLabel(((ColumnInfo)((Pair)columns.get(0)).getRight()).getPrettyName());
            ArrayList<BaseFilter> filters = new ArrayList<BaseFilter>();
            filters.add((BaseFilter)filter);
            IRCombination deltaCombination = new IRCombination(combination);
            deltaCombination.setFilters(filters);
            IRContent deltaContent = new IRContent(content);
            deltaContent.getCombinations().remove(combination);
            deltaContent.getCombinations().add(deltaCombination);
            deltaContent.setScore(0.8);
            deltaContent.setDetails(CompareCardLabel.RECOMMEND_FILTER.name());
            context.addToResult(deltaContent);
        };
        measures.forEach(m -> {
            createFilter.accept((Pair)m, TopBottomFilterType.TOP);
            createFilter.accept((Pair)m, TopBottomFilterType.BOTTOM);
        });
        if (measures.isEmpty()) {
            List<Pair<IRColumn, ColumnInfo>> candidateMeasures = ComparisonUtils.findComparableMeasures(context, this.requestContext, columns);
            candidateMeasures.stream().limit(5L).forEach(candidate -> {
                createFilter.accept((Pair)candidate, TopBottomFilterType.TOP);
                createFilter.accept((Pair)candidate, TopBottomFilterType.BOTTOM);
            });
        }
    }
}

