/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.compare;

import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.FilterTypeConversionException;
import com.ibm.smarts.common.modifiers.NumericFilter;
import com.ibm.smarts.common.modifiers.NumericRangeFilter;
import com.ibm.smarts.common.modifiers.PreOrPostAggregation;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.content.IRColumn;
import com.ibm.smarts.content.recommender.api.content.IRCombination;
import com.ibm.smarts.content.recommender.api.content.IRContent;
import com.ibm.smarts.content.recommender.internal.CompareCardLabel;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ComparisonContext;
import com.ibm.smarts.content.recommender.internal.pipeline.compare.ComparisonUtils;
import com.ibm.smarts.content.recommender.internal.pipeline.compare.ICompareStep;
import com.ibm.smarts.content.recommender.internal.util.CommonUtil;
import com.ibm.smarts.content.recommender.internal.util.Pair;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReplaceMeasure
implements ICompareStep {
    private static final double REPLACE_LOGICAL_GRP_MEASURE_CONFIDANCE = 1.0;
    private static final double REPLACE_REPLACE_MEASURE_CONFIDANCE = 0.5;
    private RequestContext requestContext;
    private static final int RELATED_COMBINATION_LIMIT = 5;

    public ReplaceMeasure(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    @Override
    public void accept(ComparisonContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        IRContent inputContent = context.getInputIRContent();
        inputContent.getCombinations().forEach(combination -> this.processCombination(context, inputContent, (IRCombination)combination));
    }

    private void processCombination(ComparisonContext context, IRContent content, IRCombination combination) {
        List columns = combination.getColumnCombinations().stream().map(c -> {
            ColumnInfo info = context.getIndexedSmartsModule().getColumnInfo(c.getId());
            if (info != null) {
                return new Pair<IRColumn, ColumnInfo>((IRColumn)c, info);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List allMeasures = columns.stream().flatMap(c -> {
            DatasetInfo dataset = context.getIndexedSmartsModule().getDatasetInfo(((ColumnInfo)c.getRight()).getIdForExpression());
            if (dataset == null) {
                return Stream.empty();
            }
            return context.getIndexedSmartsModule().getAllMeasures(dataset.getId()).stream();
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List measures = columns.stream().filter(c -> allMeasures.contains(c.getRight())).filter(Objects::nonNull).collect(Collectors.toList());
        BiFunction<IRColumn, IRColumn, IRContent> createCombination = (replaceable, comparable) -> {
            IRCombination deltaCombination = new IRCombination(combination);
            Optional<IRColumn> replaced = deltaCombination.getColumnCombinations().stream().filter(c -> c.getId().equals(replaceable.getId())).findFirst();
            List<IRColumn> deltaColumns = deltaCombination.getColumnCombinations().stream().filter(c -> replaced.isPresent() ? !c.equals(replaced.get()) : true).collect(Collectors.toList());
            deltaColumns.add((IRColumn)comparable);
            deltaCombination.setColumnCombinations(deltaColumns);
            if (replaced.isPresent() && context.isFilterFollowMeasureReplacment()) {
                String replacedColumnId = replaced.get().getId();
                deltaCombination.setFilters(deltaCombination.getFilters().stream().map(f -> {
                    if (f.getType().equals((Object)FilterType.NUMERICRANGE)) {
                        NumericRangeFilter range = null;
                        try {
                            range = f.toNumericRangeFilter();
                        }
                        catch (FilterTypeConversionException exc) {
                            return f;
                        }
                        if (this.shouldDiscardNumericRangeFilter(range, (IRColumn)comparable, context.getIndexedSmartsModule())) {
                            range = null;
                        }
                        return range;
                    }
                    if (f.getColumnId().equals(replacedColumnId)) {
                        if (f.getType().equals((Object)FilterType.TOP_BOTTOM)) {
                            TopBottomFilter topBottom = null;
                            try {
                                topBottom = f.toTopBottomFilter();
                            }
                            catch (FilterTypeConversionException exc) {
                                return f;
                            }
                            TopBottomFilter deltaTopBottom = new TopBottomFilter(topBottom);
                            deltaTopBottom.setColumnId(comparable.getId());
                            return deltaTopBottom;
                        }
                        if (f.getType().equals((Object)FilterType.NUMERIC)) {
                            NumericFilter numeric = null;
                            try {
                                numeric = f.toNumericFilter();
                            }
                            catch (FilterTypeConversionException exc) {
                                return f;
                            }
                            NumericFilter deltaNumeric = new NumericFilter(numeric);
                            deltaNumeric.setColumnId(comparable.getId());
                            return deltaNumeric;
                        }
                    }
                    return f;
                }).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            IRContent deltaContent = new IRContent(content);
            deltaContent.getCombinations().remove(combination);
            deltaContent.getCombinations().add(deltaCombination);
            deltaContent.setDetails(CompareCardLabel.REPLACE_COMPARABLE_MEASURE.name());
            return deltaContent;
        };
        BiConsumer<IRContent, Double> addCombination = (delta, score) -> {
            delta.setScore((double)score);
            context.addToResult((IRContent)delta);
        };
        Set inputCols = context.getInputIRContent().getCombinations().stream().flatMap(comb -> comb.getColumnCombinations().stream()).map(IRColumn::getId).collect(Collectors.toSet());
        measures.stream().filter(m -> ((IRColumn)m.getLeft()).getAutoGrouping() == null).forEach(m -> {
            List<String> comparableMeasure = ComparisonUtils.findComparableLogicalGroupMeasure(((ColumnInfo)m.getRight()).getIdForExpression(), context);
            comparableMeasure.forEach(comparable -> {
                if (!inputCols.contains(comparable)) {
                    addCombination.accept((IRContent)createCombination.apply(new IRColumn(((IRColumn)m.getLeft()).getId(), ((IRColumn)m.getLeft()).getAggregation(), ((IRColumn)m.getLeft()).getAutoGrouping()), new IRColumn((String)comparable)), 1.0);
                }
            });
            if (comparableMeasure.isEmpty()) {
                List<Pair<IRColumn, ColumnInfo>> candidateMeasures = ComparisonUtils.findComparableMeasures(context, this.requestContext, columns);
                candidateMeasures.stream().filter(candidate -> ((IRColumn)candidate.getLeft()).getAutoGrouping() == null).filter(candidate -> !inputCols.contains(((ColumnInfo)candidate.getRight()).getIdForExpression())).limit(5L).forEach(comparable -> addCombination.accept((IRContent)createCombination.apply(new IRColumn(((IRColumn)comparable.getLeft()).getId()), new IRColumn(((ColumnInfo)comparable.getRight()).getIdForExpression())), 0.5));
            }
        });
    }

    private boolean shouldDiscardNumericRangeFilter(NumericRangeFilter originalRangeFilter, IRColumn comparable, QuickAccessSmartsModule indexedSM) {
        return CommonUtil.isIrColumnWithNulls(comparable, indexedSM) || originalRangeFilter.getFilterAggregation() == null || originalRangeFilter.getFilterAggregation().getPreOrPostAggregation().equals((Object)PreOrPostAggregation.POST);
    }
}

