/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.compare;

import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.content.IRColumn;
import com.ibm.smarts.content.recommender.api.content.IRCombination;
import com.ibm.smarts.content.recommender.api.content.IRContent;
import com.ibm.smarts.content.recommender.internal.CompareCardLabel;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ComparisonContext;
import com.ibm.smarts.content.recommender.internal.pipeline.compare.ComparisonUtils;
import com.ibm.smarts.content.recommender.internal.pipeline.compare.ICompareStep;
import com.ibm.smarts.content.recommender.internal.util.Pair;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.schema.ColumnInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ReplaceMeasureInTopBottomFilter
implements ICompareStep {
    private static final double REPLACE_LOGICAL_GRP_MEASURE_CONFIDANCE = 1.0;
    private static final double REPLACE_REPLACE_MEASURE_CONFIDANCE = 0.5;
    private static final int MAX_RESULTS = 5;
    private RequestContext requestContext;

    public ReplaceMeasureInTopBottomFilter(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    @Override
    public void accept(ComparisonContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        this.process(context);
    }

    private void process(ComparisonContext context) {
        IRContent inputContent = context.getInputIRContent();
        inputContent.getGlobalFilters().forEach(srcFilter -> this.processGlobalFilter(context, inputContent, (BaseFilter)srcFilter));
        inputContent.getCombinations().forEach(combination -> combination.getFilters().forEach(f -> this.processFilterInCombination(context, inputContent, (IRCombination)combination, (BaseFilter)f)));
    }

    private void processGlobalFilter(ComparisonContext context, IRContent content, BaseFilter srcFilter) {
        if (!srcFilter.getType().equals((Object)FilterType.TOP_BOTTOM)) {
            return;
        }
        BiConsumer<List, Double> processFilters = (invertedFilters, score) -> invertedFilters.forEach(f -> {
            IRContent deltaIRContent = new IRContent(content);
            List<BaseFilter> deltaFilters = ComparisonUtils.replaceFilter(deltaIRContent.getGlobalFilters(), (BaseFilter)f);
            deltaIRContent.setGlobalFilters(deltaFilters);
            deltaIRContent.setScore((double)score);
            deltaIRContent.setDetails(CompareCardLabel.REPLACE_COMPARABLE_MEASURE_TOP_BOTTOM.name());
            context.addToResult(deltaIRContent);
        });
        List<TopBottomFilter> invertedFilters2 = this.createComparableFiltersLogicalGroup(context, (TopBottomFilter)srcFilter);
        processFilters.accept(invertedFilters2, 1.0);
        if (invertedFilters2.isEmpty()) {
            invertedFilters2 = this.createComparableFiltersMeasureReplacement(context, (TopBottomFilter)srcFilter);
            processFilters.accept(invertedFilters2, 0.5);
        }
    }

    private void processFilterInCombination(ComparisonContext context, IRContent content, IRCombination combination, BaseFilter srcFilter) {
        if (!srcFilter.getType().equals((Object)FilterType.TOP_BOTTOM)) {
            return;
        }
        BiConsumer<List, Double> processFilters = (invertedFilters, score) -> invertedFilters.forEach(f -> {
            IRCombination deltaCombination = new IRCombination(combination);
            List<BaseFilter> deltaFilters = ComparisonUtils.replaceFilter(deltaCombination.getFilters(), (BaseFilter)f);
            deltaCombination.setFilters(deltaFilters);
            IRContent deltaContent = new IRContent(content);
            deltaContent.getCombinations().remove(combination);
            deltaContent.getCombinations().add(deltaCombination);
            deltaContent.setScore((double)score);
            deltaContent.setDetails(CompareCardLabel.REPLACE_COMPARABLE_MEASURE_TOP_BOTTOM.name());
            context.addToResult(deltaContent);
        });
        List<TopBottomFilter> invertedFilters2 = this.createComparableFiltersLogicalGroup(context, (TopBottomFilter)srcFilter);
        processFilters.accept(invertedFilters2, 1.0);
        if (invertedFilters2.isEmpty()) {
            invertedFilters2 = this.createComparableFiltersMeasureReplacement(context, (TopBottomFilter)srcFilter);
            processFilters.accept(invertedFilters2, 0.5);
        }
    }

    private List<TopBottomFilter> createComparableFiltersLogicalGroup(ComparisonContext context, TopBottomFilter srcFilter) {
        String measureId = srcFilter.getByColumn();
        if (measureId == null) {
            return Collections.emptyList();
        }
        List<String> comparableMeasure = ComparisonUtils.findComparableLogicalGroupMeasure(measureId, context);
        Function<String, TopBottomFilter> createFilter = measure -> {
            TopBottomFilter newFilter = new TopBottomFilter(srcFilter);
            newFilter.setByColumn(measure);
            return newFilter;
        };
        return comparableMeasure.stream().map(measure -> (TopBottomFilter)createFilter.apply((String)measure)).collect(Collectors.toList());
    }

    private List<TopBottomFilter> createComparableFiltersMeasureReplacement(ComparisonContext context, TopBottomFilter srcFilter) {
        String measureId = srcFilter.getByColumn();
        if (measureId == null) {
            return Collections.emptyList();
        }
        List<String> comparableMeasure = ComparisonUtils.findComparableLogicalGroupMeasure(measureId, context);
        ArrayList<TopBottomFilter> result = new ArrayList<TopBottomFilter>();
        Function<String, TopBottomFilter> createFilter = measure -> {
            TopBottomFilter newFilter = new TopBottomFilter(srcFilter);
            newFilter.setByColumn(measure);
            return newFilter;
        };
        result.addAll(comparableMeasure.stream().map(measure -> (TopBottomFilter)createFilter.apply((String)measure)).collect(Collectors.toList()));
        if (comparableMeasure.isEmpty()) {
            ArrayList<Pair<IRColumn, ColumnInfo>> columns = new ArrayList<Pair<IRColumn, ColumnInfo>>();
            ColumnInfo columnInfo = context.getIndexedSmartsModule().getColumnInfo(srcFilter.getByColumn());
            if (columnInfo != null) {
                columns.add(new Pair<IRColumn, ColumnInfo>(new IRColumn(columnInfo.getIdForExpression()), columnInfo));
                ColumnInfo primary = context.getIndexedSmartsModule().getColumnInfo(srcFilter.getColumnId());
                if (primary != null) {
                    columns.add(new Pair<IRColumn, ColumnInfo>(new IRColumn(columnInfo.getIdForExpression()), columnInfo));
                }
                List<Pair<IRColumn, ColumnInfo>> candidateMeasures = ComparisonUtils.findComparableMeasures(context, this.requestContext, columns);
                result.addAll(candidateMeasures.stream().limit(5L).map(comparable -> (TopBottomFilter)createFilter.apply(((ColumnInfo)comparable.getRight()).getIdForExpression())).collect(Collectors.toList()));
            }
        }
        return result;
    }
}

