/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.content;

import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.content.recommender.internal.ResolvedTopic;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.content.recommender.internal.pipeline.content.IContentStep;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AnalysisScopeResolution
implements IContentStep {
    private void resolveTopic(ContentsContext context, TopicScope topic, ResolvedTopic resolvedTopic) {
        Pair<DatasetInfo, ColumnInfo> dsCiPair = AnalysisScopeResolution.findDatasetColumnPair(context.getScope().getSmartsModule(), topic.getId());
        if (dsCiPair == null) {
            throw new ContentException(SmartsStatus.DATASET_COLUMN_PAIRS_MISSING);
        }
        resolvedTopic.getTopicsToDatasets().put(topic.getId(), (DatasetInfo)dsCiPair.getLeft());
        resolvedTopic.getTopicsToColumns().put(topic.getId(), (ColumnInfo)dsCiPair.getRight());
    }

    @Override
    public void accept(ContentsContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        ResolvedTopic resolvedTopic = new ResolvedTopic();
        context.setResolvedTopic(resolvedTopic);
        if (context.getScope() != null && context.getScope().getSmartsModule() != null) {
            if (context.getScope().getPrimaryTopic().isPresent()) {
                this.resolveTopic(context, context.getScope().getPrimaryTopic().get(), resolvedTopic);
            }
            for (TopicScope topic : context.getScope().getSecondaryTopics()) {
                this.resolveTopic(context, topic, resolvedTopic);
            }
        } else {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT_SCOPE);
        }
    }

    private static ColumnInfo findColumnInfo(DatasetInfo ds, String columnId) {
        for (ColumnInfo ci : SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds)) {
            if (!ci.getIdForExpression().equals(columnId)) continue;
            return ci;
        }
        return null;
    }

    private static Pair<DatasetInfo, ColumnInfo> findDatasetColumnPair(SmartsModule smartsModule, String columnId) {
        for (DatasetInfo ds : smartsModule.getDatasets()) {
            ColumnInfo ci = AnalysisScopeResolution.findColumnInfo(ds, columnId);
            if (ci == null) continue;
            return new ImmutablePair((Object)ds, (Object)ci);
        }
        return null;
    }
}

