/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.content;

import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.content.IRColumn;
import com.ibm.smarts.content.recommender.api.content.IRCombination;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.content.recommender.internal.pipeline.content.IContentStep;
import com.ibm.smarts.content.recommender.internal.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class GuidedContentStep
implements IContentStep {
    private static final double GUIDED_HIGH_SCORE = 20000.0;
    private static final double MIN_SIZE = 1.0;

    @Override
    public void accept(ContentsContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        if (context.getScope() == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT_SCOPE);
        }
        ArrayList<String> cols = new ArrayList<String>();
        if (context.getScope().getPrimaryTopic().isPresent()) {
            cols.add(context.getScope().getPrimaryTopic().get().getId());
        }
        cols.addAll(context.getScope().getSecondaryTopics().stream().map(c -> c.getId()).collect(Collectors.toList()));
        if ((double)cols.size() <= 1.0) {
            return;
        }
        if (!this.isJoinable(context, cols)) {
            return;
        }
        IRCombination guided = new IRCombination(cols.stream().sorted().map(c -> new IRColumn((String)c, CommonUtil.findAggregation(c, context))).collect(Collectors.toList()), Collections.emptyList(), 20000.0);
        context.getGuidedCombinations().add(guided);
    }

    private boolean isJoinable(ContentsContext context, List<String> columnIds) {
        if (!columnIds.isEmpty() && context.getScope().getJoinableColumnMap().containsKey(columnIds.get(0))) {
            Set<String> reachableColumns = context.getScope().getJoinableColumnMap().get(columnIds.get(0));
            return reachableColumns.containsAll(columnIds);
        }
        return true;
    }
}

