/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.content;

import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.FilterTypeConversionException;
import com.ibm.smarts.common.modifiers.NumericRangeFilter;
import com.ibm.smarts.common.modifiers.PreOrPostAggregation;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.content.recommender.api.AnalysisScope;
import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.content.recommender.api.content.IRColumn;
import com.ibm.smarts.content.recommender.api.content.IRCombination;
import com.ibm.smarts.content.recommender.api.content.IRContent;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.CandidateCombination;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.content.recommender.internal.pipeline.content.IContentStep;
import com.ibm.smarts.content.recommender.internal.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryContentAggregation
implements IContentStep {
    private final boolean mustIncludeSecondaryCombo;
    private final int defaultMaxCombinationSize;
    private final boolean respectUnbrokenTopBottomFilters;
    private static final Logger LOGGER = LoggerFactory.getLogger(PrimaryContentAggregation.class);

    public PrimaryContentAggregation(boolean mustIncludeSecondaryCombo, int defaultMaxCombinationSize, boolean respectUnbrokenTopBottomFilters) {
        this.mustIncludeSecondaryCombo = mustIncludeSecondaryCombo;
        this.defaultMaxCombinationSize = defaultMaxCombinationSize;
        this.respectUnbrokenTopBottomFilters = respectUnbrokenTopBottomFilters;
    }

    public PrimaryContentAggregation(boolean mustIncludeSecondaryCombo, int defaultMaxCombinationSize) {
        this(mustIncludeSecondaryCombo, defaultMaxCombinationSize, true);
    }

    @Override
    public void accept(ContentsContext context) {
        String topicId = "";
        Optional<TopicScope> primaryTopic = context.getScope().getPrimaryTopic();
        if (!primaryTopic.isPresent()) {
            throw new ContentException(SmartsStatus.PRIMARY_TOPIC_MISSING);
        }
        topicId = primaryTopic.get().getId();
        int maxCombinations = context.getScope().getMaxColumnCombinations() == 0 ? this.defaultMaxCombinationSize : context.getScope().getMaxColumnCombinations();
        List<CandidateCombination> aggregatedCombinations = this.findUncontainedCombinations(context.getScope(), context.getDecisionTreeCombinations(), context.getRelatedCombinations(), context.getNonPermissibleCombos(), maxCombinations);
        ArrayList<IRCombination> combinations = new ArrayList<IRCombination>();
        combinations.addAll(aggregatedCombinations.stream().map(r -> new IRCombination(r.getColumns().stream().sorted().map(c -> new IRColumn((String)c, CommonUtil.findAggregation(c, context))).collect(Collectors.toList()), Collections.emptyList(), r.getScore())).collect(Collectors.toList()));
        ArrayList<TopBottomFilter> filters = new ArrayList<TopBottomFilter>();
        filters.add(primaryTopic.get().getFilter());
        context.getScope().getSecondaryTopics().forEach(topic -> filters.add(topic.getFilter()));
        context.getScope().getFilters().forEach(f -> {
            if (!f.getType().equals((Object)FilterType.NUMERICRANGE)) {
                filters.add((TopBottomFilter)f);
            } else {
                try {
                    NumericRangeFilter numericRangeFilter = f.toNumericRangeFilter();
                    if (!CommonUtil.isCombinationWithNulls(combinations, context.getIndexedSM()) && numericRangeFilter.getFilterAggregation() != null && numericRangeFilter.getFilterAggregation().getPreOrPostAggregation().equals((Object)PreOrPostAggregation.PRE)) {
                        filters.add((TopBottomFilter)f);
                    }
                }
                catch (FilterTypeConversionException e) {
                    LOGGER.error("Failed to convert filter");
                }
            }
        });
        List<BaseFilter> finalFilters = filters.stream().filter(Objects::nonNull).collect(Collectors.toList());
        IRContent irToAdd = new IRContent(topicId, topicId, combinations, finalFilters);
        Predicate<IRContent> isIrValid = ir -> !ir.getCombinations().isEmpty();
        if (isIrValid.test(irToAdd)) {
            context.addIRContent(irToAdd);
        }
    }

    public List<CandidateCombination> findUncontainedCombinations(AnalysisScope analysisScope, List<CandidateCombination> multivariateCombinations, List<CandidateCombination> bivariateCombinations, Set<Set<String>> nonPermissible, int numCombinationsNeeded) {
        ArrayList<CandidateCombination> combinedResult = new ArrayList<CandidateCombination>();
        combinedResult.addAll(multivariateCombinations);
        if (analysisScope == null) {
            return combinedResult;
        }
        int bivariateCombinationIdx = 0;
        Set<String> topicIds = analysisScope.getSecondaryTopics().stream().map(TopicScope::getId).collect(Collectors.toSet());
        if (analysisScope.getPrimaryTopic().isPresent()) {
            topicIds.add(analysisScope.getPrimaryTopic().get().getId());
        }
        while (combinedResult.size() < numCombinationsNeeded && bivariateCombinationIdx < bivariateCombinations.size()) {
            CandidateCombination bivarCombination;
            if (!this.isCombinationUncontained(combinedResult, bivarCombination = bivariateCombinations.get(bivariateCombinationIdx++)) || !this.isIntroducesNewTopic(bivarCombination, topicIds) || nonPermissible.contains(bivarCombination.getColumns()) || this.brokenTopBottomFilter(analysisScope.getSecondaryTopics(), bivarCombination)) continue;
            combinedResult.add(bivarCombination);
        }
        if (this.mustIncludeSecondaryCombo && !analysisScope.getSecondaryTopics().isEmpty()) {
            CandidateCombination backupSecondary;
            Set<String> secondarySet = analysisScope.getSecondaryTopics().stream().map(TopicScope::getId).collect(Collectors.toSet());
            if (!combinedResult.isEmpty() && this.containsSecondaryField(combinedResult, secondarySet, topicIds) == null && (backupSecondary = this.containsSecondaryField(bivariateCombinations, secondarySet, topicIds)) != null && !nonPermissible.contains(backupSecondary.getColumns())) {
                combinedResult.remove(combinedResult.size() - 1);
                combinedResult.add(backupSecondary);
            }
        }
        return combinedResult;
    }

    private boolean isCombinationUncontained(List<CandidateCombination> combinedResult, CandidateCombination bivariateCombination) {
        return combinedResult.stream().noneMatch(c -> c.getColumns().containsAll(bivariateCombination.getColumns()) || bivariateCombination.getColumns().containsAll(c.getColumns()));
    }

    private boolean isIntroducesNewTopic(CandidateCombination bivariateCombination, Set<String> topicIds) {
        return bivariateCombination.getColumns().stream().anyMatch(c -> !topicIds.contains(c));
    }

    private CandidateCombination containsSecondaryField(List<CandidateCombination> combinedResult, Set<String> secondarySet, Set<String> allTopics) {
        for (CandidateCombination combo : combinedResult) {
            if (Collections.disjoint(combo.getColumns(), secondarySet) || !combo.getColumns().stream().anyMatch(c -> !allTopics.contains(c))) continue;
            return combo;
        }
        return null;
    }

    private boolean brokenTopBottomFilter(List<TopicScope> secondaryTopics, CandidateCombination combination) {
        if (secondaryTopics.isEmpty() || !this.respectUnbrokenTopBottomFilters) {
            return false;
        }
        List topBottoms = secondaryTopics.stream().filter(t -> t.getFilter() != null && t.getFilter().getType().equals((Object)FilterType.TOP_BOTTOM)).collect(Collectors.toList());
        for (TopicScope topBottom : topBottoms) {
            TopBottomFilter topBottomFilter = topBottom.getFilter();
            if (combination.getColumns().contains(topBottomFilter.getColumnId())) continue;
            return true;
        }
        return false;
    }
}

