/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.pipeline.content;

import com.ibm.smarts.content.recommender.api.ContentException;
import com.ibm.smarts.content.recommender.internal.SmartsStatus;
import com.ibm.smarts.content.recommender.internal.context.CandidateCombination;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.content.recommender.internal.pipeline.content.IContentStep;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.BaseObject;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.FieldRecommendationRecord;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.schema.util.ColumnIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RelatedContentAnalysis
implements IContentStep {
    private static final double SCORE_INTERESTING_FIELDS = 0.35;
    private static final double SCORE_PREFERRED_CONCEPTS = 0.75;
    private static final double SCORE_RELATED_FIELDS = 0.45;
    private static final double SCORE_ALL_PRIMARY_SECONDARY_TOPICS = 0.4;
    private static final double SECONDARY_SIMILARITY_SCALING_FACTOR = 0.5;
    private static final double HIGH_CORRELATION = 0.5;
    private static final double MODERATE_CORRELATION = 0.01;
    private static final double SLIGHT_CORRELATION = 0.0;
    private static final double CEILING_CORRELATION = 0.9;
    private static final int MAX_COMBINATIONS_COUNT_PER_TUPLE_SIZE = 500;
    private static final int COMBINATIONS_COUNT_FACTOR_PER_TUPLE_SIZE = 10;
    private static final float MINIMUM_DENSITY = 0.1f;
    private static final int MAX_COLUMNS_PER_TYPE = 100;
    private static final double HIGH_SCORE = 1000000.0;

    private static List<List<ColumnType>> getCombinations(Set<ColumnType> focusColumnTypes, List<ColumnType> elements, int maxTupleSize, BiPredicate<Set<ColumnType>, int[]> tupleValidator) {
        ArrayList<List<ColumnType>> result = new ArrayList<List<ColumnType>>();
        if (maxTupleSize == 1) {
            result.addAll(elements.stream().map(e -> {
                ArrayList<ColumnType> list = new ArrayList<ColumnType>();
                list.add((ColumnType)((Object)e));
                return list;
            }).collect(Collectors.toList()));
            return result;
        }
        List<List<ColumnType>> subsets = RelatedContentAnalysis.getCombinations(focusColumnTypes, elements, maxTupleSize - 1, tupleValidator);
        Function<int[], Integer> encode = buckets -> {
            int sum = 0;
            for (int bucket : buckets) {
                sum = sum * 10 + bucket;
            }
            return sum;
        };
        HashSet<Integer> observed = new HashSet<Integer>();
        for (List<ColumnType> subset : subsets) {
            if (subset.size() != maxTupleSize - 1) break;
            for (ColumnType element : elements) {
                int coded;
                ArrayList<ColumnType> combination = new ArrayList<ColumnType>(subset);
                combination.add(element);
                int[] buckets2 = new int[ColumnType.values().length];
                combination.forEach(t -> {
                    int n = t.getId() - 1;
                    buckets[n] = buckets2[n] + 1;
                });
                if (!tupleValidator.test(focusColumnTypes, buckets2) || !observed.add(coded = encode.apply(buckets2).intValue())) continue;
                result.add(combination);
            }
        }
        result.addAll(subsets);
        return result;
    }

    private static <T> List<List<T>> cartesianProduct(List<List<T>> tuples) {
        ArrayList<List<T>> results = new ArrayList<List<T>>();
        if (tuples.isEmpty()) {
            results.add(Collections.emptyList());
            return results;
        }
        List<T> first = tuples.get(0);
        List innerProducts = RelatedContentAnalysis.cartesianProduct(tuples.subList(1, tuples.size()));
        return first.stream().flatMap(e -> innerProducts.stream().map(inner -> {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(e);
            result.addAll((Collection<Object>)inner);
            return result;
        })).collect(Collectors.toList());
    }

    private boolean isCorrelated(BivariateStatistics biv, double floorThreshold, double ceilingThreshold) {
        if (biv == null) {
            return false;
        }
        Optional<Statistic> highestCorrelation = biv.getStatistics().stream().filter(s -> !Double.isNaN(s.getValue().floatValue())).max(Comparator.comparing(s -> Float.valueOf(s.getValue().floatValue())));
        return highestCorrelation.isPresent() && (double)highestCorrelation.get().getValue().floatValue() > floorThreshold && (double)highestCorrelation.get().getValue().floatValue() < ceilingThreshold;
    }

    private boolean isBivariateAvailable(SelectionContext context, ColumnIdentifier specialId1, ColumnIdentifier specialId2) {
        return context.allBivariates.containsKey(specialId1) && context.allBivariates.containsKey(specialId2);
    }

    private boolean isInSameDataset(ColumnIdentifier specialId1, ColumnIdentifier specialId2) {
        return specialId1.datasetId.equals(specialId2.datasetId);
    }

    private boolean isCorrelated(SelectionContext context, ColumnIdentifier specialId1, ColumnIdentifier specialId2, double floorThresh, double ceilingThresh) {
        if (context.allBivariates.containsKey(specialId1) && context.allBivariates.get(specialId1).containsKey(specialId2)) {
            return this.isCorrelated(context.allBivariates.get(specialId1).get(specialId2), floorThresh, ceilingThresh);
        }
        return false;
    }

    private double correlation(BivariateStatistics biv, double ceilingThreshold) {
        Optional<Statistic> highestCorrelation = biv.getStatistics().stream().filter(s -> !Double.isNaN(s.getValue().floatValue())).max(Comparator.comparing(s -> Float.valueOf(s.getValue().floatValue())));
        if (highestCorrelation.isPresent() && (double)highestCorrelation.get().getValue().floatValue() < ceilingThreshold) {
            return highestCorrelation.get().getValue().floatValue();
        }
        return 0.0;
    }

    private double findCorrelation(SelectionContext selectionContext, ColumnIdentifier col1, ColumnIdentifier col2, double ceilingThreshold) {
        if (selectionContext.allBivariates.containsKey(col1) && selectionContext.allBivariates.get(col1).containsKey(col2)) {
            return this.correlation(selectionContext.allBivariates.get(col1).get(col2), ceilingThreshold);
        }
        return 0.0;
    }

    private RelatedCombination createRelatedCombinations(SelectionContext context, List<ColumnInfo> relatedColumns) {
        RelatedCombination relCombo = new RelatedCombination();
        double score = 0.0;
        relCombo.getCombination().add(context.focusColumnIdentifier.getColumnInfo());
        relCombo.getCombination().addAll(relatedColumns);
        score = this.addScoreNonFocalPairs(context, relatedColumns);
        score += 2.0 * this.addScoreFocalPairs(context, relatedColumns);
        score = (double)Math.round(score * 1000.0) / 1000.0;
        relCombo.setCorrelationScore(score);
        return relCombo;
    }

    private double addScoreNonFocalPairs(SelectionContext context, List<ColumnInfo> relatedColumns) {
        double score = 0.0;
        for (int ii = 0; ii < relatedColumns.size(); ++ii) {
            for (int jj = ii + 1; jj < relatedColumns.size(); ++jj) {
                ColumnInfo colInfo = relatedColumns.get(ii);
                ColumnInfo otherColInfo = relatedColumns.get(jj);
                score += this.adjustForObviousness(this.getBivariates(context.indexedSM, context.focusColumnIdentifier.columnIdForExpression, colInfo, otherColInfo));
            }
        }
        return score;
    }

    private double adjustForObviousness(double bivariateScore) {
        if (bivariateScore > 0.5) {
            return 0.5 - bivariateScore;
        }
        return bivariateScore;
    }

    private double addScoreFocalPairs(SelectionContext context, List<ColumnInfo> relatedColumns) {
        double score = 0.0;
        for (ColumnInfo otherColInfo : relatedColumns) {
            score += this.adjustForObviousness(this.getBivariates(context.indexedSM, context.focusColumnIdentifier.columnIdForExpression, context.focusColumnIdentifier.getColumnInfo(), otherColInfo));
        }
        return score;
    }

    private double getBivariates(QuickAccessSmartsModule indexedSM, String focusFieldIdForExpr, ColumnInfo colInfo, ColumnInfo otherColInfo) {
        Optional<Double> st;
        BivariateStatistics stats;
        DatasetInfo ds;
        Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>> allBivariates;
        Map<ColumnIdentifier, BivariateStatistics> bivs;
        if (!otherColInfo.getIdForExpression().equals(colInfo.getIdForExpression()) && (bivs = (allBivariates = indexedSM.getAllBivariatesByDatasetId((ds = indexedSM.getDatasetInfo(focusFieldIdForExpr)).getId())).get(indexedSM.getColumnIdentifier(otherColInfo.getIdForExpression()))) != null && (stats = bivs.get(indexedSM.getColumnIdentifier(colInfo.getIdForExpression()))) != null && (st = stats.getStatistics().stream().map(s -> s.getValue().doubleValue()).filter(d -> !Double.isNaN(d)).max(Comparator.comparingDouble(d -> d))).isPresent()) {
            return st.get();
        }
        return 0.0;
    }

    private List<RelatedCombination> findCombinations(SelectionContext selectionContext) {
        boolean noFoundMeasure = false;
        ArrayList<RelatedCombination> result = new ArrayList<RelatedCombination>();
        HashSet observedTuples = new HashSet();
        int combinationsNumber = Math.min(selectionContext.maxColumnCombinations * 10, 500);
        BiConsumer<Map, String> getColumns = (columnsByType, datasetId) -> {
            Predicate<ColumnInfo> hasGoodAggrAndDensity = ci -> ci.getDefaultAggregation() != null && !ci.getDefaultAggregation().equals((Object)AggregationType.NONE) && this.hasMinimumDensity((ColumnInfo)ci);
            Predicate<ColumnInfo> isJoinable = ci -> !selectionContext.joinableColumns.containsKey(selectionContext.focusColumnIdentifier.columnIdForExpression) || selectionContext.joinableColumns.get(selectionContext.focusColumnIdentifier.columnIdForExpression).contains(ci.getIdForExpression());
            columnsByType.computeIfAbsent(ColumnType.CATEGORY, columnType -> new ArrayList()).addAll(selectionContext.indexedSM.getCategoricals((String)datasetId).stream().filter(ci -> this.hasMinimumDensity((ColumnInfo)ci) && isJoinable.test((ColumnInfo)ci)).collect(Collectors.toList()));
            columnsByType.computeIfAbsent(ColumnType.MEASURE, columnType -> new ArrayList()).addAll(selectionContext.indexedSM.getMeasures((String)datasetId).stream().filter(ci -> hasGoodAggrAndDensity.test((ColumnInfo)ci) && isJoinable.test((ColumnInfo)ci)).collect(Collectors.toList()));
            columnsByType.computeIfAbsent(ColumnType.LOCATION, columnType -> new ArrayList()).addAll(selectionContext.indexedSM.getLocationColumns((String)datasetId).stream().filter(ci -> this.hasMinimumDensity((ColumnInfo)ci) && isJoinable.test((ColumnInfo)ci)).collect(Collectors.toList()));
            columnsByType.computeIfAbsent(ColumnType.MONETARY, columnType -> new ArrayList()).addAll(selectionContext.indexedSM.getMonetaryColumns((String)datasetId).stream().filter(ci -> hasGoodAggrAndDensity.test((ColumnInfo)ci) && isJoinable.test((ColumnInfo)ci)).collect(Collectors.toList()));
            columnsByType.computeIfAbsent(ColumnType.TEMPORAL, columnType -> new ArrayList()).addAll(selectionContext.indexedSM.getTemporalColumns((String)datasetId).stream().filter(ci -> this.hasMinimumDensity((ColumnInfo)ci) && isJoinable.test((ColumnInfo)ci)).collect(Collectors.toList()));
        };
        if (selectionContext.datasetInfo != null) {
            ColumnIdentifier focusColumnIdentifier = selectionContext.focusColumnIdentifier;
            EnumMap<ColumnType, List<ColumnInfo>> columnsByType2 = new EnumMap<ColumnType, List<ColumnInfo>>(ColumnType.class);
            getColumns.accept(columnsByType2, focusColumnIdentifier.datasetId);
            if (selectionContext.joinableColumns.containsKey(selectionContext.focusColumnIdentifier.columnIdForExpression)) {
                Set<String> joinableDatasetIds = this.extractDatasetIds(selectionContext.joinableColumns.get(selectionContext.focusColumnIdentifier.columnIdForExpression), selectionContext);
                for (String datasetId2 : joinableDatasetIds) {
                    if (datasetId2.equals(focusColumnIdentifier.datasetId)) continue;
                    getColumns.accept(columnsByType2, datasetId2);
                }
            }
            if (((List)columnsByType2.get((Object)ColumnType.MEASURE)).isEmpty() && ((List)columnsByType2.get((Object)ColumnType.MONETARY)).isEmpty()) {
                noFoundMeasure = true;
            }
            if (selectionContext.maxCombinationSize <= 1) {
                result.add(this.createRelatedCombinations(selectionContext, Collections.emptyList()));
            } else {
                result.addAll(this.addCombinations(selectionContext, columnsByType2));
            }
        }
        this.setScoreForPreferredSorting(result, selectionContext);
        Map<Integer, List<RelatedCombination>> resultsByTupleSize = result.stream().collect(Collectors.groupingBy(r -> r.getCombination().size()));
        BiPredicate<Set, Set> similar = (related, observed) -> {
            Stream<ColumnIdentifier> disObserved = observed.stream().filter(r -> !related.contains(r));
            return disObserved.anyMatch(col1 -> related.stream().filter(r -> !observed.contains(r)).filter(col2 -> !col1.columnIdForExpression.equals(col2.columnIdForExpression)).anyMatch(col2 -> this.isCorrelated(selectionContext, (ColumnIdentifier)col1, (ColumnIdentifier)col2, 0.5, Double.MAX_VALUE)));
        };
        Function<ColumnInfo, ColumnIdentifier> convertToColumnIdentifier = col -> {
            ColumnIdentifier colId = new ColumnIdentifier(selectionContext.focusColumnIdentifier.datasetId, col.getId(), col.getIdForExpression());
            colId.setColumnInfo(col);
            return colId;
        };
        List<RelatedCombination> results = resultsByTupleSize.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().sorted(Comparator.comparingDouble(RelatedCombination::getScore).thenComparing(RelatedCombination::getSortKey).reversed()).limit(combinationsNumber).filter(rel -> {
            Set columns = rel.getCombination().stream().filter(c -> !c.getIdForExpression().equals(selectionContext.focusColumnIdentifier.getColumnInfo().getIdForExpression())).map(convertToColumnIdentifier).collect(Collectors.toSet());
            boolean unique = observedTuples.stream().filter(observed -> observed.size() == columns.size()).filter(observed -> observed.size() == 1 || !Collections.disjoint(observed, columns)).noneMatch(observed -> similar.test(columns, (Set)observed));
            if (unique) {
                observedTuples.add(columns);
            }
            return unique;
        })).collect(Collectors.toList());
        if (noFoundMeasure && results.isEmpty()) {
            throw new ContentException(SmartsStatus.NO_RELATED_COMBINATIONS);
        }
        if (results.isEmpty()) {
            throw new ContentException(SmartsStatus.GENERAL_NO_COMBINATIONS);
        }
        return results;
    }

    private Set<String> extractDatasetIds(Set<String> columnIds, SelectionContext selectionContext) {
        return columnIds.stream().map(id -> selectionContext.indexedSM.getDatasetInfo((String)id) != null ? selectionContext.indexedSM.getDatasetInfo((String)id).getId() : null).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private boolean hasMinimumDensity(ColumnInfo ci) {
        Optional<Statistic> densityStatistic = ci.getStatistics().stream().filter(s -> s.getType().equals((Object)StatisticType.DENSITY)).findFirst();
        if (densityStatistic.isPresent()) {
            return densityStatistic.get().getValue().floatValue() > 0.1f;
        }
        return true;
    }

    private Set<ColumnType> getFocusColumnType(Map<ColumnType, List<ColumnInfo>> columnsByType, String focusColumnIdentifier) {
        return columnsByType.entrySet().stream().filter(e -> ((List)e.getValue()).stream().map(ci -> ci.getIdForExpression()).collect(Collectors.toSet()).contains(focusColumnIdentifier)).map(e -> (ColumnType)((Object)((Object)e.getKey()))).collect(Collectors.toSet());
    }

    private Set<RelatedCombination> addCombinations(SelectionContext selectionContext, Map<ColumnType, List<ColumnInfo>> columnsByType) {
        HashSet<RelatedCombination> result = new HashSet<RelatedCombination>();
        ColumnIdentifier focusColumnIdentifier = selectionContext.focusColumnIdentifier;
        List<ColumnType> types = Arrays.asList(ColumnType.values());
        BiPredicate<Set<ColumnType>, int[]> tupleValidator = (focusColumnTypes, counts) -> {
            if (counts[ColumnType.LOCATION.getId() - 1] > 1) {
                return false;
            }
            if (focusColumnTypes.contains((Object)ColumnType.LOCATION) && counts[ColumnType.LOCATION.getId() - 1] > 0) {
                return false;
            }
            if (counts[ColumnType.TEMPORAL.getId() - 1] > 1) {
                return false;
            }
            if (focusColumnTypes.contains((Object)ColumnType.TEMPORAL) && counts[ColumnType.TEMPORAL.getId() - 1] > 0) {
                return false;
            }
            if (counts[ColumnType.MONETARY.getId() - 1] > 1 && counts[ColumnType.LOCATION.getId() - 1] == 0 && !focusColumnTypes.contains((Object)ColumnType.LOCATION)) {
                return false;
            }
            if (focusColumnTypes.contains((Object)ColumnType.MONETARY) && counts[ColumnType.MONETARY.getId() - 1] > 0 && counts[ColumnType.LOCATION.getId() - 1] == 0) {
                return false;
            }
            if (focusColumnTypes.contains((Object)ColumnType.LOCATION) && (counts[ColumnType.CATEGORY.getId() - 1] > 0 || counts[ColumnType.TEMPORAL.getId() - 1] > 0)) {
                return false;
            }
            return counts[ColumnType.LOCATION.getId() - 1] <= 0 || counts[ColumnType.CATEGORY.getId() - 1] <= 0 && counts[ColumnType.TEMPORAL.getId() - 1] <= 0;
        };
        List<List<ColumnType>> tuples = RelatedContentAnalysis.getCombinations(this.getFocusColumnType(columnsByType, focusColumnIdentifier.columnIdForExpression), types, selectionContext.maxCombinationSize - 1, tupleValidator);
        Consumer<List> processTuple = tuple -> {
            List<List<ColumnInfo>> columns = tuple.stream().map(type -> {
                List list = (List)columnsByType.get(type);
                if (!list.isEmpty() && list.size() > 100) {
                    return list.subList(0, 100);
                }
                return list;
            }).collect(Collectors.toList());
            result.addAll(this.addTuple(selectionContext, columns));
        };
        tuples.forEach(processTuple::accept);
        return result;
    }

    private boolean violatesHierarchy(SelectionContext context, List<ColumnInfo> tuple) {
        HashSet<Integer> hierarchiesEncountered = new HashSet<Integer>();
        hierarchiesEncountered.addAll(context.indexedSM.getHierarchy(context.datasetInfo.getId(), context.focusFieldIdForExpr));
        if (context.inclusionFilterField.isPresent()) {
            hierarchiesEncountered.addAll(context.indexedSM.getHierarchy(context.indexedSM.getDatasetInfo(context.inclusionFilterField.get()).getId(), context.inclusionFilterField.get()));
        }
        for (ColumnInfo tupleColumn : tuple) {
            Set<Integer> hierarchyIndices = context.indexedSM.getHierarchy(context.indexedSM.getDatasetInfo(tupleColumn.getIdForExpression()).getId(), tupleColumn.getIdForExpression());
            if (hierarchiesEncountered.stream().anyMatch(hierarchyIndices::contains)) {
                return true;
            }
            hierarchiesEncountered.addAll(hierarchyIndices);
        }
        return false;
    }

    private boolean violatesBrokenPlannedActual(SelectionContext context, List<ColumnInfo> tuple) {
        Map<String, String> plannedToActualMap = context.indexedSM.getPlannedToActual(context.datasetInfo.getId());
        HashSet<String> actualsThatMustBeContained = new HashSet<String>();
        HashSet<String> fieldsThatAreContained = new HashSet<String>();
        if (plannedToActualMap.containsKey(context.focusFieldIdForExpr)) {
            actualsThatMustBeContained.add(plannedToActualMap.get(context.focusFieldIdForExpr));
            fieldsThatAreContained.add(context.focusFieldIdForExpr);
        }
        boolean measurePresent = false;
        int distinctPlannedFields = 0;
        for (ColumnInfo tupleColumn : tuple) {
            plannedToActualMap = context.indexedSM.getPlannedToActual(context.indexedSM.getDatasetInfo(tupleColumn.getIdForExpression()).getId());
            if (plannedToActualMap.containsKey(tupleColumn.getIdForExpression())) {
                actualsThatMustBeContained.add(plannedToActualMap.get(tupleColumn.getIdForExpression()));
                if (++distinctPlannedFields > 0) {
                    return true;
                }
            } else if (context.indexedSM.getAllMeasures(context.indexedSM.getDatasetInfo(tupleColumn.getIdForExpression()).getId()).contains(tupleColumn)) {
                measurePresent = true;
            }
            fieldsThatAreContained.add(tupleColumn.getIdForExpression());
        }
        if (measurePresent && !actualsThatMustBeContained.isEmpty()) {
            return !fieldsThatAreContained.containsAll(actualsThatMustBeContained);
        }
        return false;
    }

    private boolean violatesDirectJoinRule(SelectionContext context, List<ColumnInfo> tuple) {
        HashSet<String> joinedTables = new HashSet<String>();
        joinedTables.add(context.datasetInfo.getId());
        for (ColumnInfo tupleCi : tuple) {
            joinedTables.add(context.indexedSM.getDatasetInfo(tupleCi.getIdForExpression()).getId());
            if (joinedTables.size() <= 2) continue;
            return true;
        }
        return false;
    }

    private boolean violatesAllCategorical(SelectionContext context, List<ColumnInfo> tuple) {
        for (ColumnInfo tupleMember : tuple) {
            if (this.isAllCategorical(context, tupleMember.getIdForExpression())) continue;
            return false;
        }
        return this.isAllCategorical(context, context.focusFieldIdForExpr);
    }

    private boolean isAllCategorical(SelectionContext context, String idForExpression) {
        List<ColumnInfo> allCategoricals = context.indexedSM.getAllCategoricals(context.indexedSM.getDatasetInfo(idForExpression).getId());
        Set allCategoricalsSet = allCategoricals.stream().map(c -> c.getIdForExpression()).collect(Collectors.toSet());
        return allCategoricalsSet.contains(idForExpression);
    }

    private Set<RelatedCombination> addTuple(SelectionContext context, List<List<ColumnInfo>> tuples) {
        if (tuples.size() == 0) {
            return Collections.emptySet();
        }
        tuples = tuples.stream().map(tuple -> tuple.stream().filter(e -> !e.getIdForExpression().equals(context.focusFieldIdForExpr)).collect(Collectors.toList())).collect(Collectors.toList());
        tuples = RelatedContentAnalysis.cartesianProduct(tuples).stream().filter(tuple -> tuple.stream().distinct().count() == (long)tuple.size()).collect(Collectors.toList());
        Function<ColumnInfo, ColumnIdentifier> convertToColumnIdentifier = col -> {
            ColumnIdentifier colId = new ColumnIdentifier(context.focusColumnIdentifier.datasetId, col.getId(), col.getIdForExpression());
            colId.setColumnInfo(col);
            return colId;
        };
        Stream<Object> tuplesStream = tuples.stream();
        if (context.focalBivariates != null && !context.focalBivariates.isEmpty()) {
            tuplesStream = tuplesStream.filter(tuple -> tuple.stream().allMatch(col -> {
                ColumnIdentifier id = context.indexedSM.getColumnIdentifier(col.getIdForExpression());
                return !this.isInSameDataset(context.focusColumnIdentifier, id) || this.isCorrelated(context.focalBivariates.get(id), tuple.size() == 1 ? 0.01 : 0.0, 0.9);
            }));
        }
        tuplesStream = tuplesStream.filter(tuple -> tuple.stream().map(convertToColumnIdentifier).allMatch(col1 -> tuple.stream().map(convertToColumnIdentifier).filter(col2 -> !col1.columnIdForExpression.equals(col2.columnIdForExpression)).allMatch(col2 -> !this.isInSameDataset((ColumnIdentifier)col1, (ColumnIdentifier)col2) || !this.isBivariateAvailable(context, (ColumnIdentifier)col1, (ColumnIdentifier)col2) || this.isCorrelated(context, (ColumnIdentifier)col1, (ColumnIdentifier)col2, 0.01, 0.9))));
        tuplesStream = tuplesStream.filter(tuple -> !this.violatesHierarchy(context, (List<ColumnInfo>)tuple) && !this.violatesAllCategorical(context, (List<ColumnInfo>)tuple) && !this.violatesDirectJoinRule(context, (List<ColumnInfo>)tuple) && !this.violatesBrokenPlannedActual(context, (List<ColumnInfo>)tuple));
        tuples = tuplesStream.collect(Collectors.toList());
        return tuples.stream().map(tuple -> this.createRelatedCombinations(context, (List<ColumnInfo>)tuple)).collect(Collectors.toSet());
    }

    private void setScoreForPreferredSorting(List<RelatedCombination> relComs, SelectionContext selectionContext) {
        for (RelatedCombination combination : relComs) {
            combination.setScore(this.calcInterestingnessScore(combination, selectionContext.interestingSet, 0.35) + this.preferredConceptsScore(combination, selectionContext) + this.secondaryTopicsBonus(combination, selectionContext) + this.calcInterestingnessScore(combination, selectionContext.influencersSet, 0.45) + combination.getCorrelationScore());
        }
        Collections.sort(relComs, (a, b) -> {
            Double valA = a.getScore();
            Double valB = b.getScore();
            return -1 * valA.compareTo(valB);
        });
    }

    private double secondaryTopicsBonus(RelatedCombination relatedCombination, SelectionContext selectionContext) {
        if (selectionContext.secondaryTopics.isEmpty()) {
            return 0.0;
        }
        Set comboSet = relatedCombination.getCombination().stream().map(BaseObject::getIdForExpression).collect(Collectors.toSet());
        if (comboSet.containsAll(selectionContext.secondaryTopics)) {
            return 0.4;
        }
        if (selectionContext.secondaryTopics.stream().anyMatch(s -> comboSet.contains(s))) {
            return 0.2;
        }
        double highestCorrelation = 0.0;
        for (String otherField : comboSet) {
            if (otherField.equals(selectionContext.focusFieldIdForExpr)) continue;
            for (String secondaryField : selectionContext.secondaryTopics) {
                double corr = this.findCorrelation(selectionContext, selectionContext.indexedSM.getColumnIdentifier(otherField), selectionContext.indexedSM.getColumnIdentifier(secondaryField), 0.9);
                if (!(corr > highestCorrelation)) continue;
                highestCorrelation = corr;
            }
        }
        return 0.2 * highestCorrelation;
    }

    private double preferredConceptsScore(RelatedCombination relatedCombination, SelectionContext selectionContext) {
        ColumnIdentifier focusColumnIdentifier = selectionContext.focusColumnIdentifier;
        String dsId = focusColumnIdentifier.datasetId;
        double preferredConceptsScore = 0.0;
        QuickAccessSmartsModule indexed = selectionContext.indexedSM;
        boolean locationBonus = false;
        boolean monetaryBonus = false;
        boolean temporalBonus = false;
        for (ColumnInfo ci : relatedCombination.getCombination()) {
            if (indexed.getLocationColumns(dsId).contains(ci) && !locationBonus) {
                preferredConceptsScore += 0.75;
                locationBonus = true;
                continue;
            }
            if (indexed.getMonetaryColumns(dsId).contains(ci) && !monetaryBonus) {
                preferredConceptsScore += 0.75;
                monetaryBonus = true;
                continue;
            }
            if (!indexed.getTemporalColumns(dsId).contains(ci) || temporalBonus) continue;
            preferredConceptsScore += 0.75;
            temporalBonus = true;
        }
        return preferredConceptsScore;
    }

    private double calcInterestingnessScore(RelatedCombination combination, Map<String, Float> interestingSet, double weight) {
        double score = 0.0;
        for (ColumnInfo ci : combination.getCombination()) {
            score += (double)interestingSet.getOrDefault(ci.getIdForExpression(), Float.valueOf(0.0f)).floatValue();
        }
        return score * weight;
    }

    @Override
    public void accept(ContentsContext context) {
        if (context == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT);
        }
        if (context.getScope() == null) {
            throw new ContentException(SmartsStatus.MISSING_CONTEXT_SCOPE);
        }
        if (!context.getScope().getPrimaryTopic().isPresent()) {
            throw new ContentException(SmartsStatus.PRIMARY_TOPIC_MISSING);
        }
        String primaryColumn = context.getScope().getPrimaryTopic().get().getId();
        QuickAccessSmartsModule indexedSM = context.getIndexedSM() == null ? new QuickAccessSmartsModule(context.getScope().getSmartsModule()) : context.getIndexedSM();
        Map<String, Float> influencersSet = context.getInterestingFields() != null ? context.getInfluencers().stream().collect(Collectors.toMap(FieldRecommendationRecord::getFieldIDForExpression, FieldRecommendationRecord::getConfidence, (l1, l2) -> l1)) : Collections.emptyMap();
        Map<String, Float> interestingSet = context.getInterestingFields() != null ? context.getInterestingFields().stream().collect(Collectors.toMap(FieldRecommendationRecord::getFieldIDForExpression, FieldRecommendationRecord::getConfidence, (l1, l2) -> l1)) : Collections.emptyMap();
        SelectionContext selectionContext = new SelectionContext(indexedSM, interestingSet, influencersSet, primaryColumn, context.getScope().getSecondaryTopics().stream().map(c -> c.getId()).collect(Collectors.toSet()), context.getScope().getMaxCombinationSize());
        if (context.getScope().getJoinableColumnMap() != null) {
            selectionContext.joinableColumns = context.getScope().getJoinableColumnMap();
        }
        selectionContext.maxColumnCombinations = context.getScope().getMaxColumnCombinations();
        if (!context.getTopBottomInclusionFilters().isEmpty()) {
            selectionContext.inclusionFilterField = Optional.of(context.getTopBottomInclusionFilters().get(0).getColumnId());
        }
        List<RelatedCombination> relatedCombinations = this.findCombinations(selectionContext);
        this.supplementPlannedActual(context, relatedCombinations);
        this.setScoreForPreferredSorting(relatedCombinations, selectionContext);
        ArrayList<CandidateCombination> content = new ArrayList<CandidateCombination>();
        for (RelatedCombination combo : relatedCombinations) {
            ArrayList<String> columnIdsForExpression = new ArrayList<String>();
            for (ColumnInfo ci : combo.getCombination()) {
                columnIdsForExpression.add(ci.getIdForExpression());
            }
            content.add(new CandidateCombination(columnIdsForExpression, primaryColumn, combo.getScore()));
        }
        context.setRelatedCombinations(content);
    }

    private void supplementPlannedActual(ContentsContext context, List<RelatedCombination> relatedCombinations) {
        if (!context.getScope().getPrimaryTopic().isPresent() || context.getIndexedSM() == null) {
            return;
        }
        String primaryColumnId = context.getScope().getPrimaryTopic().get().getId();
        String dsId = context.getIndexedSM().getDatasetInfo(primaryColumnId).getId();
        String matedColumnId = context.getIndexedSM().getPlannedToActual(dsId).get(primaryColumnId);
        if (matedColumnId == null) {
            matedColumnId = context.getIndexedSM().getActualToPlanned(dsId).get(primaryColumnId);
        }
        if (matedColumnId != null) {
            ColumnInfo columnInfo2;
            ColumnInfo columnInfo1 = context.getIndexedSM().getColumnInfo(primaryColumnId);
            RelatedCombination newKPICombination = this.findPair(relatedCombinations, columnInfo1, columnInfo2 = context.getIndexedSM().getColumnInfo(matedColumnId));
            if (newKPICombination == null) {
                newKPICombination = new RelatedCombination();
                newKPICombination.getCombination().add(columnInfo1);
                newKPICombination.getCombination().add(columnInfo2);
                relatedCombinations.add(newKPICombination);
            }
            newKPICombination.setCorrelationScore(1000000.0);
        }
    }

    private RelatedCombination findPair(List<RelatedCombination> relatedCombinations, ColumnInfo columnInfo1, ColumnInfo columnInfo2) {
        for (RelatedCombination relCombo : relatedCombinations) {
            if (relCombo.combination.size() != 2 || !relCombo.combination.contains(columnInfo1) || !relCombo.combination.contains(columnInfo2)) continue;
            return relCombo;
        }
        return null;
    }

    private static enum ColumnType {
        CATEGORY(1),
        LOCATION(2),
        MEASURE(3),
        TEMPORAL(4),
        MONETARY(5);

        private int id;

        private ColumnType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    private static class SelectionContext {
        final QuickAccessSmartsModule indexedSM;
        final Map<String, Float> influencersSet;
        final Map<String, Float> interestingSet;
        final String focusFieldIdForExpr;
        final ColumnIdentifier focusColumnIdentifier;
        final DatasetInfo datasetInfo;
        final Map<ColumnIdentifier, Map<ColumnIdentifier, BivariateStatistics>> allBivariates;
        final Map<ColumnIdentifier, BivariateStatistics> focalBivariates;
        final Set<String> secondaryTopics;
        final int maxCombinationSize;
        int maxColumnCombinations = 500;
        Map<String, Set<String>> joinableColumns = Collections.emptyMap();
        Optional<String> inclusionFilterField = Optional.empty();

        SelectionContext(QuickAccessSmartsModule indexedSM, Map<String, Float> interestingSet, Map<String, Float> influencersSet, String focusFieldIdForExpr, Set<String> secondaries, int maxCombinationSize) {
            this.indexedSM = indexedSM;
            this.influencersSet = influencersSet;
            this.interestingSet = interestingSet;
            this.focusFieldIdForExpr = focusFieldIdForExpr;
            this.maxCombinationSize = maxCombinationSize;
            this.datasetInfo = indexedSM.getDatasetInfo(focusFieldIdForExpr);
            this.focusColumnIdentifier = indexedSM.getColumnIdentifier(focusFieldIdForExpr);
            this.allBivariates = indexedSM.getAllBivariatesByDatasetId(this.datasetInfo.getId());
            this.focalBivariates = indexedSM.getBivariates(this.focusColumnIdentifier);
            this.secondaryTopics = secondaries;
        }
    }

    private static class RelatedCombination {
        private Set<ColumnInfo> combination = new HashSet<ColumnInfo>();
        double correlationScore = 0.0;
        double score = 0.0;

        private RelatedCombination() {
        }

        public Set<ColumnInfo> getCombination() {
            return this.combination;
        }

        public String getSortKey() {
            List keys = this.combination.stream().map(BaseObject::getIdForExpression).collect(Collectors.toList());
            keys.sort((p1, p2) -> p1.compareTo((String)p2));
            return keys.toString();
        }

        public double getCorrelationScore() {
            return this.correlationScore;
        }

        public void setCorrelationScore(double s) {
            this.correlationScore = (double)Math.round(s * 1000.0) / 1000.0;
        }

        public double getScore() {
            return this.score;
        }

        public void setScore(double s) {
            this.score = (double)Math.round(s * 1000.0) / 1000.0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RelatedCombination)) {
                return false;
            }
            RelatedCombination that = (RelatedCombination)o;
            return Double.compare(that.getCorrelationScore(), this.getCorrelationScore()) == 0 && Double.compare(that.getScore(), this.getScore()) == 0 && Objects.equals(this.getCombination(), that.getCombination());
        }

        public int hashCode() {
            return Objects.hash(this.getCombination(), this.getCorrelationScore(), this.getScore());
        }
    }
}

