/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.content.recommender.internal.util;

import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.FilterTypeConversionException;
import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.content.recommender.api.TopicScope;
import com.ibm.smarts.content.recommender.api.content.IRColumn;
import com.ibm.smarts.content.recommender.api.content.IRCombination;
import com.ibm.smarts.content.recommender.internal.context.ContentsContext;
import com.ibm.smarts.content.recommender.internal.util.QuickAccessSmartsModule;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import java.util.List;
import java.util.Optional;

public class CommonUtil {
    private static final double MINIMUM_DISTINCT_COUNT = 1.0;

    public static boolean isCombinationWithNulls(List<IRCombination> combinations, QuickAccessSmartsModule indexedSM) {
        return combinations.stream().flatMap(combination -> combination.getColumnCombinations().stream()).anyMatch(col -> CommonUtil.checkNulls(col, indexedSM));
    }

    public static boolean isIrColumnWithNulls(IRColumn irColumn, QuickAccessSmartsModule indexedSM) {
        return CommonUtil.checkNulls(irColumn, indexedSM);
    }

    private static boolean checkNulls(IRColumn irColumn, QuickAccessSmartsModule indexedSM) {
        boolean foundNulls = false;
        ColumnInfo col = indexedSM.getColumnInfo(irColumn.getId());
        if (col == null || col.getStatistics() == null) {
            return true;
        }
        for (Statistic stat : col.getStatistics()) {
            if (stat.getType() == null || !stat.getType().equals((Object)StatisticType.DISTINCT_COUNT)) continue;
            foundNulls = stat.getValue().doubleValue() < 1.0;
        }
        return foundNulls;
    }

    public static AggregationType findAggregation(String columnId, ContentsContext context) {
        Optional<TopicScope> primaryTopic = context.getScope().getPrimaryTopic();
        Optional<TopicScope> secondaryTopic = context.getScope().getSecondaryTopics().stream().filter(topic -> topic.getId().equals(columnId)).findFirst();
        if (primaryTopic.isPresent() && primaryTopic.get().getId().equals(columnId)) {
            return primaryTopic.get().getAggregationType();
        }
        if (secondaryTopic.isPresent()) {
            return secondaryTopic.get().getAggregationType();
        }
        return context.getIndexedSM().getColumnInfo(columnId).getDefaultAggregation();
    }

    public static InclusionExclusionFilter getFocalFieldFilter(List<BaseFilter> filters) {
        for (BaseFilter bf : filters) {
            if (!bf.getType().equals((Object)FilterType.INCLUSION_EXCLUSION)) continue;
            try {
                InclusionExclusionFilter inclusion = bf.toInclusionExclusionFilter();
                if (inclusion.getInclusionValues().size() != 1 && inclusion.getFilterCondition().getValues().size() != 1) continue;
                return inclusion;
            }
            catch (FilterTypeConversionException filterTypeConversionException) {
            }
        }
        return null;
    }
}

