/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.pipeline.dag;

import com.ibm.smarts.pipeline.dag.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flow<T> {
    private Node<T> root;
    private static final Logger LOGGER = LoggerFactory.getLogger(Flow.class);
    private List<Node<T>> nodes = new ArrayList<Node<T>>();

    public Node<T> getRoot() {
        return this.root;
    }

    public void setRoot(Node<T> root) {
        this.root = root;
    }

    public Flow(Node<T> ... nodes) {
        this(new ArrayList<Node<T>>(Arrays.asList(nodes)));
    }

    public Flow(List<Node<T>> nodes) {
        this.nodes = nodes;
        this.createVirtualRoot();
    }

    public Flow(boolean validate, Node<T> ... nodes) {
        this(validate, new ArrayList<Node<T>>(Arrays.asList(nodes)));
    }

    public Flow(boolean validate, List<Node<T>> nodes) {
        this(nodes);
        if (validate) {
            this.validate();
        }
    }

    void validate() {
        if (this.root == null) {
            RuntimeException e = new RuntimeException("There are no roots and there must be one.");
            LOGGER.error("There are no roots and there must be one.", (Throwable)e);
            throw e;
        }
        this.walk(this.root, new ArrayList<Node<T>>());
    }

    private void walk(Node<T> startNode, List<Node<T>> list) {
        ArrayList<Node<T>> listCopy = new ArrayList<Node<T>>(list);
        List intersection = list.stream().distinct().filter(startNode.getSuccessors()::contains).collect(Collectors.toList());
        if (intersection.isEmpty()) {
            listCopy.add(startNode);
            for (Node<T> successor : startNode.getSuccessors()) {
                this.walk(successor, listCopy);
            }
        } else {
            RuntimeException e = new RuntimeException("Node(s): " + Arrays.toString(intersection.toArray()) + " is/are part of a cycle");
            LOGGER.error("Node(s): " + Arrays.toString(intersection.toArray()) + " is/are part of a cycle", (Throwable)e);
            throw e;
        }
    }

    public void createVirtualRoot() {
        List rootNodes = this.nodes.stream().filter(node -> node.getInDegree().get() == 0).collect(Collectors.toList());
        if (rootNodes.size() == 1) {
            this.root = (Node)rootNodes.get(0);
        } else if (rootNodes.size() > 1) {
            Node<Object> virtualRoot = new Node<Object>(null, rootNodes);
            this.nodes.add(virtualRoot);
            this.root = virtualRoot;
        }
    }

    public List<Node<T>> getNodes() {
        return this.nodes;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Node<T> node : this.nodes) {
            if (node == this.root) {
                s.append("*");
            }
            s.append(node).append("[ ");
            for (Node<T> successor : node.getSuccessors()) {
                s.append(successor + " ");
            }
            s.append("]").append("\n");
        }
        return s.toString();
    }
}

