/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.pipeline.internal;

import com.ibm.smarts.pipeline.apis.FlowExecutor;
import com.ibm.smarts.pipeline.apis.IContext;
import com.ibm.smarts.pipeline.apis.IProgressUpdater;
import com.ibm.smarts.pipeline.constants.ExecutionStatus;
import com.ibm.smarts.pipeline.dag.Flow;
import com.ibm.smarts.pipeline.dag.Node;
import com.ibm.smarts.pipeline.internal.Task;
import com.ibm.smarts.pipeline.progress.TaskStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionPlan<T extends IContext> {
    private String id;
    private Flow<Task<T>> flow;
    private Task initialTask;
    private Task finalTask;
    private FlowExecutor<T> flowExecutor;
    private List<Future> runningTasks = new ArrayList<Future>();
    Map<String, ExecutionStatus> statusMap;
    private CompletableFuture planComplete;
    private static final Logger LOGGER = LoggerFactory.getLogger(Task.class);
    private static final byte ERROR_MASK = 1;
    private static final byte COMPLETE_MASK = 2;
    private static final byte CANCELLED_MASK = 4;
    private static final byte IN_PROGRESS_MASK = 8;
    private static final byte NOT_STARTED_MASK = 16;

    public ExecutionPlan(String planId, FlowExecutor<T> flowExecutor, Flow<Task<T>> flow) {
        this.id = planId;
        this.flowExecutor = flowExecutor;
        this.flow = flow;
        this.statusMap = new ConcurrentHashMap<String, ExecutionStatus>(flow.getNodes().size());
        for (Node<Task<Task<T>>> node : flow.getNodes()) {
            if (node.getData() == null) continue;
            this.statusMap.put(node.getData().getID(), ExecutionStatus.NOT_STARTED);
        }
        this.planComplete = new CompletableFuture();
    }

    public ExecutionPlan(String planId, FlowExecutor<T> flowExecutor, Flow<Task<T>> subFlow, Task initialTask, Task finalTask) {
        this(planId, flowExecutor, subFlow);
        this.initialTask = initialTask;
        this.finalTask = finalTask;
        if (initialTask != null) {
            this.statusMap.put(initialTask.getID(), ExecutionStatus.NOT_STARTED);
        }
    }

    public void execute(ExecutorService executorService, T context) {
        this.onInit(context);
        if (!this.canceled()) {
            this.walk(executorService, context, this.flow.getRoot());
        }
    }

    private void walk(ExecutorService executorService, T context, Node<Task<T>> node) {
        this.runningTasks.clear();
        ExecutionStatus currentStatus = node.getData() == null ? ExecutionStatus.COMPLETE : (this.statusMap.get(node.getData().getID()).equals((Object)ExecutionStatus.CANCELLED) ? ExecutionStatus.CANCELLED : node.getData().wrappedExecute(context, this));
        if (currentStatus == ExecutionStatus.COMPLETE && node.getSuccessors() != null) {
            for (int i = 0; i < node.getSuccessors().size() && !this.canceled(); ++i) {
                Node<Task<T>> successor = node.getSuccessors().get(i);
                if (successor.getInDegree().decrementAndGet() != 0) continue;
                Future<?> f = executorService.submit(() -> this.walk(executorService, context, successor));
                this.runningTasks.add(f);
            }
        }
    }

    public void handleError() {
        IProgressUpdater updater = this.flowExecutor.getProgressUpdater();
        for (Map.Entry<String, ExecutionStatus> entry : this.statusMap.entrySet()) {
            if (entry.getValue() != ExecutionStatus.NOT_STARTED) continue;
            entry.setValue(ExecutionStatus.CANCELLED_BY_ERROR);
            updater.setTaskProgress(this.flowExecutor.getId(), this.id, entry.getKey(), new TaskStatus(ExecutionStatus.CANCELLED_BY_ERROR));
        }
    }

    public void cancel() {
        for (Map.Entry<String, ExecutionStatus> entry : this.statusMap.entrySet()) {
            if (entry.getValue() != ExecutionStatus.NOT_STARTED) continue;
            entry.setValue(ExecutionStatus.CANCELLED);
        }
        for (Future f : this.runningTasks) {
            f.cancel(true);
        }
    }

    private boolean canceled() {
        return Thread.currentThread().isInterrupted();
    }

    private void onInit(T context) {
        if (this.initialTask != null) {
            this.initialTask.wrappedExecute(context, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFinish(T context, ExecutionStatus incomingStatus) {
        IProgressUpdater updater = this.flowExecutor.getProgressUpdater();
        context.setStatus(incomingStatus);
        ExecutionStatus resultingExecutionStatus = ExecutionStatus.NOT_STARTED;
        TaskStatus finalTaskStatus = null;
        ExecutionStatus finalTaskExecutionStatus = ExecutionStatus.NOT_STARTED;
        if (this.finalTask != null) {
            try {
                finalTaskStatus = this.finalTask.execute(context);
                finalTaskExecutionStatus = finalTaskStatus.getStatus();
                if (incomingStatus == ExecutionStatus.COMPLETE_PENDING) {
                    resultingExecutionStatus = finalTaskExecutionStatus;
                }
                resultingExecutionStatus = incomingStatus;
            }
            catch (Exception e) {
                LOGGER.error(this.finalTask.getID() + " failed to complete properly", (Throwable)e);
                resultingExecutionStatus = ExecutionStatus.ERROR;
                finalTaskExecutionStatus = ExecutionStatus.ERROR;
            }
            finally {
                this.statusMap.put(this.finalTask.getID(), finalTaskExecutionStatus);
                updater.setTaskProgress(this.flowExecutor.getId(), this.id, this.finalTask.getID(), finalTaskStatus);
                updater.setAtomicProgress(this.flowExecutor.getId(), this.id, resultingExecutionStatus);
                this.sendUpdate(resultingExecutionStatus);
                context.setStatus(resultingExecutionStatus);
            }
        } else if (incomingStatus == ExecutionStatus.COMPLETE_PENDING) {
            updater.setAtomicProgress(this.flowExecutor.getId(), this.id, ExecutionStatus.COMPLETE);
            this.sendUpdate(ExecutionStatus.COMPLETE);
            context.setStatus(ExecutionStatus.COMPLETE);
        }
        this.planComplete.complete(null);
    }

    private static boolean isFinished(ExecutionStatus status) {
        return status == ExecutionStatus.COMPLETE_PENDING || status == ExecutionStatus.CANCELLED || status == ExecutionStatus.ERROR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdate(String taskId, TaskStatus taskStatus, T data) {
        IProgressUpdater updater = this.flowExecutor.getProgressUpdater();
        if (ExecutionPlan.isFinished(this.statusMap.get(taskId))) {
            LOGGER.warn("Attempted to update status from " + (Object)((Object)this.statusMap.get(taskId)) + " to " + (Object)((Object)taskStatus.getStatus()));
        } else {
            this.statusMap.put(taskId, taskStatus.getStatus());
        }
        if (taskStatus.getStatus() == ExecutionStatus.ERROR) {
            this.handleError();
        }
        ExecutionStatus currentStatus = null;
        try {
            updater.setTaskProgress(this.flowExecutor.getId(), this.id, taskId, taskStatus);
            currentStatus = this.calculateStatus();
            updater.setAtomicProgress(this.flowExecutor.getId(), this.id, currentStatus);
            this.sendUpdate(currentStatus);
        }
        catch (Throwable th) {
            try {
                LOGGER.error(th.getMessage());
                currentStatus = ExecutionStatus.ERROR;
                this.sendUpdate(currentStatus);
            }
            catch (Throwable throwable) {
                this.sendUpdate(currentStatus);
                throw throwable;
            }
        }
        if (ExecutionPlan.isFinished(currentStatus)) {
            this.onFinish(data, currentStatus);
        }
    }

    public void onUpdate(String taskId, ExecutionStatus status, T data) {
        this.onUpdate(taskId, new TaskStatus(status), data);
    }

    public ExecutionStatus calculateStatus() {
        byte interimResult = 0;
        for (ExecutionStatus currentStatus : this.statusMap.values()) {
            interimResult = ExecutionPlan.addStatusToResult(currentStatus, interimResult);
        }
        if (ExecutionPlan.haveOne((byte)8, interimResult)) {
            return ExecutionStatus.IN_PROGRESS;
        }
        if (ExecutionPlan.onlyHave((byte)2, interimResult)) {
            return ExecutionStatus.COMPLETE_PENDING;
        }
        if (ExecutionPlan.onlyHave((byte)16, interimResult)) {
            return ExecutionStatus.NOT_STARTED;
        }
        if (ExecutionPlan.haveOne((byte)16, interimResult)) {
            return ExecutionStatus.IN_PROGRESS;
        }
        if (ExecutionPlan.haveOne((byte)4, interimResult)) {
            return ExecutionStatus.CANCELLED;
        }
        return ExecutionStatus.ERROR;
    }

    private static byte addStatusToResult(ExecutionStatus currentStatus, byte interimResult) {
        if (currentStatus.equals((Object)ExecutionStatus.COMPLETE)) {
            interimResult = (byte)(interimResult | 2);
        } else if (currentStatus.equals((Object)ExecutionStatus.ERROR)) {
            interimResult = (byte)(interimResult | 1);
        } else if (currentStatus.equals((Object)ExecutionStatus.CANCELLED)) {
            interimResult = (byte)(interimResult | 4);
        } else if (currentStatus.equals((Object)ExecutionStatus.IN_PROGRESS)) {
            interimResult = (byte)(interimResult | 8);
        } else if (currentStatus.equals((Object)ExecutionStatus.NOT_STARTED)) {
            interimResult = (byte)(interimResult | 0x10);
        }
        return interimResult;
    }

    private static boolean onlyHave(byte mask, byte result) {
        return result == mask;
    }

    private static boolean haveOne(byte mask, byte result) {
        return (result & mask) == mask;
    }

    private void sendUpdate(ExecutionStatus status) {
        this.flowExecutor.onUpdate(this, status);
    }

    public String getId() {
        return this.id;
    }

    public Flow<Task<T>> getFlow() {
        return this.flow;
    }

    public CompletableFuture getPlanComplete() {
        return this.planComplete;
    }

    public String toString() {
        return this.flow.toString();
    }
}

