/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.modifiers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.CategoricalFilterCondition;
import com.ibm.smarts.common.modifiers.CompositeFilter;
import com.ibm.smarts.common.modifiers.FilterAggregation;
import com.ibm.smarts.common.modifiers.FilterCondition;
import com.ibm.smarts.common.modifiers.FilterLogicalOperator;
import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.GenericFilter;
import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.common.modifiers.MissingFilterParametersException;
import com.ibm.smarts.common.modifiers.NumericFilter;
import com.ibm.smarts.common.modifiers.NumericOperator;
import com.ibm.smarts.common.modifiers.NumericRangeFilter;
import com.ibm.smarts.common.modifiers.NumericRangeValue;
import com.ibm.smarts.common.modifiers.PreOrPostAggregation;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilterType;
import com.ibm.smarts.common.modifiers.TopBottomFilteringMethod;
import com.ibm.smarts.schema.AggregationType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FilterTypeDeserializer
extends StdDeserializer<BaseFilter> {
    private static final String CONDITION = "condition";
    private static final String ID = "id";
    private static final String VALUES = "values";
    private static final String TYPE = "type";
    public static final String BY = "by";
    public static final String BY_AGGREGATE_MODIFIER = "by_aggregate";
    public static final String BY_AGGREGATE = "byAggregate";
    public static final String MODIFIER_AVG = "avg";
    public static final String MODIFIER_COUNT = "count";
    public static final String MODIFIER_COUNTDISTINCT = "countdistinct";
    public static final String MODIFIER_MIN = "min";
    public static final String MODIFIER_MAX = "max";
    public static final String MODIFIER_SUM = "sum";
    private static final String ORCONTAINS = "orcontains";
    private static final String NOTCONTAINS = "notcontains";
    private static final String GREATER_THAN = "greaterthan";
    private static final String LESS_THAN = "lessthan";
    public static final String TOPCOUNT = "topcount";
    public static final String BOTTOMCOUNT = "bottomcount";
    public static final String TOPPERCENT = "toppercent";
    public static final String BOTTOMPERCENT = "bottompercent";
    private static final String COLUMN_ID = "columnId";
    private static final long serialVersionUID = 3865729629867926646L;

    public FilterTypeDeserializer() {
        super(BaseFilter.class);
    }

    protected FilterTypeDeserializer(Class<BaseFilter> bf) {
        super(bf);
    }

    public BaseFilter deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String type = node.get(TYPE).asText();
        FilterType ft = FilterType.GENERIC;
        try {
            ft = FilterType.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        BaseFilter bf = null;
        try {
            switch (ft) {
                case GENERIC: {
                    bf = this.genericFromJSON(node);
                    break;
                }
                case INCLUSION_EXCLUSION: {
                    bf = this.inclusionExclusionFromJSON(node);
                    break;
                }
                case TOP_BOTTOM: {
                    bf = this.topBottomFilterfromJSON(node);
                    break;
                }
                case NUMERIC: {
                    bf = this.numericFilterfromJSON(node);
                    break;
                }
                case NUMERICRANGE: {
                    bf = this.numericRangeFilterfromJSON(node);
                    break;
                }
                case COMPOSITE: {
                    bf = this.compositeFromJSON(node);
                }
            }
            if (bf != null) {
                bf.fromJSON(node);
            }
        }
        catch (MissingFilterParametersException exc) {
            throw new IOException(exc);
        }
        return bf;
    }

    public static BaseFilter createFilter(JSONObject filter) {
        String condition = (String)filter.get((Object)CONDITION);
        if (condition.equals(GREATER_THAN) || condition.equals(LESS_THAN)) {
            return FilterTypeDeserializer.createNumericFilter(filter);
        }
        if (condition.equals(ORCONTAINS) || condition.equals(NOTCONTAINS)) {
            return FilterTypeDeserializer.createInclusionExclusionFilter(filter);
        }
        return null;
    }

    private GenericFilter genericFromJSON(JsonNode node) throws MissingFilterParametersException {
        return new GenericFilter(this.getJSONValue(node, COLUMN_ID, true), null, null, this.getJSONValue(node, "expression", true), this.getBoolean(node, "invertFlag", false));
    }

    private InclusionExclusionFilter inclusionExclusionFromJSON(JsonNode node) throws MissingFilterParametersException, IOException {
        return new InclusionExclusionFilter(this.getJSONValue(node, COLUMN_ID, true), null, null, this.getOptionalDataValueList(node, "inclusionValues"), this.getOptionalDataValueList(node, "exclusionValues"), this.getFilterCondition(node, "filterCondition"), this.getBoolean(node, "invertFlag", false));
    }

    public static InclusionExclusionFilter createInclusionExclusionFilter(JSONObject inclusionExclusionFilter) {
        String operator = (String)inclusionExclusionFilter.get((Object)CONDITION);
        JSONArray values = (JSONArray)inclusionExclusionFilter.get((Object)VALUES);
        String col = (String)inclusionExclusionFilter.get((Object)ID);
        if (values == null || values.isEmpty() || operator == null || col == null) {
            return null;
        }
        if (!operator.equals(ORCONTAINS) && !operator.equals(NOTCONTAINS)) {
            return null;
        }
        ArrayList<String> filterConditionValues = new ArrayList<String>();
        values.forEach(val -> filterConditionValues.add((String)val));
        FilterCondition filterCondition = new FilterCondition(CategoricalFilterCondition.CONTAINS, filterConditionValues, true, true);
        boolean invertFlag = operator.equals(NOTCONTAINS);
        try {
            return new InclusionExclusionFilter(col, null, null, Collections.emptyList(), Collections.emptyList(), filterCondition, invertFlag);
        }
        catch (MissingFilterParametersException e) {
            return null;
        }
    }

    private boolean isNull(JsonNode node) {
        if (node != null) {
            return node.isNull();
        }
        return true;
    }

    private TopBottomFilter topBottomFilterfromJSON(JsonNode node) throws MissingFilterParametersException {
        JsonNode topBottomNode = node.get("topBottomType");
        if (this.isNull(topBottomNode)) {
            throw new MissingFilterParametersException("topBottomType is mandatory for Top/Bottom filter");
        }
        TopBottomFilterType topBottomFilterType = TopBottomFilterType.valueOf(topBottomNode.asText());
        JsonNode methodNode = node.get("method");
        if (this.isNull(methodNode)) {
            throw new MissingFilterParametersException("method is mandatory for Top/Bottom filter");
        }
        TopBottomFilteringMethod method = TopBottomFilteringMethod.valueOf(methodNode.asText());
        String byColumnNode = this.getJSONValue(node, "byColumn", false);
        int domainSize = this.getIntValue(node, "domainSize");
        JsonNode aggNode = node.get(BY_AGGREGATE);
        AggregationType aggregationType = null;
        if (!this.isNull(aggNode)) {
            aggregationType = AggregationType.valueOf((String)aggNode.textValue());
        }
        return new TopBottomFilter(this.getJSONValue(node, COLUMN_ID, true), null, null, topBottomFilterType, method, byColumnNode, domainSize, aggregationType);
    }

    public static TopBottomFilter createTopBottomFilter(JSONObject topBottomFilterModifier) {
        TopBottomFilterType topBottomFilterType = null;
        TopBottomFilteringMethod topBottomFilteringMethod = null;
        String type = (String)topBottomFilterModifier.get((Object)TYPE);
        if (type == null) {
            return null;
        }
        if (type.equals(TOPCOUNT)) {
            topBottomFilterType = TopBottomFilterType.TOP;
            topBottomFilteringMethod = TopBottomFilteringMethod.COUNT;
        } else if (type.equals(BOTTOMCOUNT)) {
            topBottomFilterType = TopBottomFilterType.BOTTOM;
            topBottomFilteringMethod = TopBottomFilteringMethod.COUNT;
        } else if (type.equals(TOPPERCENT)) {
            topBottomFilterType = TopBottomFilterType.TOP;
            topBottomFilteringMethod = TopBottomFilteringMethod.PERCENTAGE;
        } else if (type.equals(BOTTOMPERCENT)) {
            topBottomFilterType = TopBottomFilterType.BOTTOM;
            topBottomFilteringMethod = TopBottomFilteringMethod.PERCENTAGE;
        }
        if (topBottomFilteringMethod == null || topBottomFilterType == null) {
            return null;
        }
        String byColumn = (String)topBottomFilterModifier.get((Object)BY);
        String aggString = (String)topBottomFilterModifier.get((Object)BY_AGGREGATE_MODIFIER);
        AggregationType aggregationType = null;
        if (aggString != null && !aggString.isEmpty()) {
            aggregationType = FilterTypeDeserializer.convertModifierToAggregationType(aggString);
        }
        TopBottomFilter filter = byColumn == null ? new TopBottomFilter((String)topBottomFilterModifier.get((Object)ID), null, null, topBottomFilterType, topBottomFilteringMethod, null, Integer.parseInt((String)topBottomFilterModifier.get((Object)"value")), aggregationType) : new TopBottomFilter((String)topBottomFilterModifier.get((Object)ID), null, null, topBottomFilterType, topBottomFilteringMethod, byColumn, Integer.parseInt((String)topBottomFilterModifier.get((Object)"value")), aggregationType);
        return filter;
    }

    private static AggregationType convertModifierToAggregationType(String aggModifier) {
        switch (aggModifier) {
            case "avg": {
                return AggregationType.AVERAGE;
            }
            case "count": {
                return AggregationType.COUNT;
            }
            case "countdistinct": {
                return AggregationType.COUNT_DISTINCT;
            }
            case "min": {
                return AggregationType.MINIMUM;
            }
            case "max": {
                return AggregationType.MAXIMUM;
            }
            case "sum": {
                return AggregationType.SUM;
            }
        }
        return null;
    }

    private NumericFilter numericFilterfromJSON(JsonNode node) throws MissingFilterParametersException {
        JsonNode operatorNode = node.get("operator");
        if (this.isNull(operatorNode)) {
            throw new MissingFilterParametersException("Missing mandatory operator parameter for NumericFilter ");
        }
        NumericOperator op = NumericOperator.valueOf(operatorNode.asText());
        NumericFilter numericFilter = new NumericFilter(this.getJSONValue(node, COLUMN_ID, true), null, null, this.getJSONValue(node, "value", true), op);
        FilterAggregation filterAggregation = this.extractAggregation(node, "preOrPostAggregation", "aggregationType");
        if (filterAggregation != null) {
            numericFilter.setFilterAggregation(filterAggregation);
        }
        return numericFilter;
    }

    private String getJSONValue(JsonNode node, String fieldId, boolean isMandatory) throws MissingFilterParametersException {
        JsonNode idNode = node.get(fieldId);
        if (this.isNull(idNode) && isMandatory) {
            throw new MissingFilterParametersException("Missing mandatory string parameter: " + fieldId);
        }
        if (!this.isNull(idNode)) {
            return idNode.asText();
        }
        return null;
    }

    private boolean getBoolean(JsonNode node, String fieldId, boolean isMandatory) throws MissingFilterParametersException {
        JsonNode idNode = node.get(fieldId);
        if (this.isNull(idNode) && isMandatory) {
            throw new MissingFilterParametersException("Missing mandatory boolean parameter: " + fieldId);
        }
        if (!this.isNull(idNode)) {
            return idNode.asBoolean();
        }
        return false;
    }

    private int getIntValue(JsonNode node, String fieldId) {
        JsonNode idNode = node.get(fieldId);
        if (!this.isNull(idNode)) {
            return idNode.asInt();
        }
        return 0;
    }

    private List<InclusionExclusionFilter.DataValue> getOptionalDataValueList(JsonNode node, String fieldId) throws IOException {
        JsonNode dataValuesNode = node.get(fieldId);
        if (this.isNull(dataValuesNode)) {
            return Collections.emptyList();
        }
        ObjectMapper mapper = new ObjectMapper();
        ObjectReader reader = mapper.readerFor((TypeReference)new TypeReference<List<InclusionExclusionFilter.DataValue>>(){});
        return (List)reader.readValue(dataValuesNode);
    }

    private FilterCondition getFilterCondition(JsonNode node, String fieldId) throws IOException, MissingFilterParametersException {
        JsonNode conditionNode = node.get(fieldId);
        if (!this.isNull(conditionNode)) {
            JsonNode stringCondition = conditionNode.get(CONDITION);
            if (this.isNull(stringCondition)) {
                throw new MissingFilterParametersException("Missing filterCondition for : " + fieldId);
            }
            CategoricalFilterCondition actualStringFunction = CategoricalFilterCondition.valueOf(stringCondition.asText());
            List values = null;
            JsonNode stringList = conditionNode.get(VALUES);
            if (this.isNull(stringList)) {
                throw new MissingFilterParametersException("Missing filterCondition values for : " + fieldId);
            }
            ObjectMapper mapper = new ObjectMapper();
            ObjectReader reader = mapper.readerFor((TypeReference)new TypeReference<List<String>>(){});
            values = (List)reader.readValue(stringList);
            return new FilterCondition(actualStringFunction, values, this.getBoolean(conditionNode, "isInclude", true), this.getBoolean(conditionNode, "ignoreCase", false));
        }
        return null;
    }

    private NumericRangeFilter numericRangeFilterfromJSON(JsonNode node) throws MissingFilterParametersException {
        return new NumericRangeFilter(this.getJSONValue(node, COLUMN_ID, true), null, null, this.extractNumericRange(node, "lowValue", "inclusive"), this.extractNumericRange(node, "highValue", "inclusive"), this.getBoolean(node, "invertFlag", false), this.extractAggregation(node, "preOrPostAggregation", "aggregationType"));
    }

    public static NumericFilter createNumericFilter(JSONObject numericFilter) {
        NumericOperator numericOperator = null;
        String operator = (String)numericFilter.get((Object)CONDITION);
        JSONArray values = (JSONArray)numericFilter.get((Object)VALUES);
        if (values == null || values.isEmpty()) {
            return null;
        }
        String value = (String)values.get(0);
        String col = (String)numericFilter.get((Object)ID);
        if (operator == null || value == null) {
            return null;
        }
        if (operator.equals(GREATER_THAN)) {
            numericOperator = NumericOperator.GREATER_THAN;
        } else if (operator.equals(LESS_THAN)) {
            numericOperator = NumericOperator.LESS_THAN;
        }
        return new NumericFilter(col, null, null, value, numericOperator);
    }

    private NumericRangeValue extractNumericRange(JsonNode node, String valueField, String inclusiveField) throws MissingFilterParametersException {
        JsonNode valueInclusiveNode = node.get(valueField);
        if (this.isNull(valueInclusiveNode)) {
            throw new MissingFilterParametersException("Missing mandatory numeric range parameter: " + valueField);
        }
        JsonNode valueNode = valueInclusiveNode.get("value");
        JsonNode inclusiveNode = valueInclusiveNode.get(inclusiveField);
        if (this.isNull(valueNode) || this.isNull(inclusiveNode)) {
            throw new MissingFilterParametersException("Missing mandatory numeric range parameter: " + valueField);
        }
        String actualValue = valueNode.asText();
        boolean isIncl = inclusiveNode.asBoolean();
        return new NumericRangeValue(actualValue, isIncl);
    }

    private FilterAggregation extractAggregation(JsonNode node, String preOrPostField, String aggregationField) throws MissingFilterParametersException {
        JsonNode filterAggregationNode = node.get("filterAggregation");
        if (this.isNull(filterAggregationNode)) {
            return null;
        }
        JsonNode preOrPostNode = filterAggregationNode.get(preOrPostField);
        PreOrPostAggregation preOrPost = null;
        if (!this.isNull(preOrPostNode)) {
            preOrPost = PreOrPostAggregation.valueOf(preOrPostNode.asText());
        }
        JsonNode aggNode = filterAggregationNode.get(aggregationField);
        AggregationType agg = null;
        if (!this.isNull(aggNode)) {
            agg = AggregationType.valueOf((String)aggNode.textValue());
        }
        if (agg != null && preOrPost != null) {
            return new FilterAggregation(agg, preOrPost);
        }
        return null;
    }

    private CompositeFilter compositeFromJSON(JsonNode node) throws MissingFilterParametersException, IOException {
        JsonNode operatorNode = node.get("operator");
        if (this.isNull(operatorNode)) {
            throw new MissingFilterParametersException("Missing mandatory composite filter parameter: operator");
        }
        FilterLogicalOperator operator = FilterLogicalOperator.valueOf(operatorNode.asText());
        ObjectMapper mapper = new ObjectMapper();
        ObjectReader reader = mapper.readerFor((TypeReference)new TypeReference<BaseFilter>(){});
        JsonNode filter1Node = node.get("filter1");
        BaseFilter bf1 = null;
        if (this.isNull(filter1Node)) {
            throw new MissingFilterParametersException("Missing mandatory composite filter parameter: filter1");
        }
        bf1 = (BaseFilter)reader.readValue(filter1Node);
        BaseFilter bf2 = null;
        JsonNode filter2Node = node.get("filter2");
        if (this.isNull(filter2Node)) {
            throw new MissingFilterParametersException("Missing mandatory composite filter parameter: filter2");
        }
        bf2 = (BaseFilter)reader.readValue(filter2Node);
        return new CompositeFilter(this.getJSONValue(node, COLUMN_ID, true), null, null, bf1, bf2, operator);
    }
}

