/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.modifiers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.FilterCondition;
import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.MissingFilterParametersException;
import java.util.ArrayList;
import java.util.List;

public class InclusionExclusionFilter
extends BaseFilter {
    private List<DataValue> inclusionValues = new ArrayList<DataValue>();
    private List<DataValue> exclusionValues = new ArrayList<DataValue>();
    private FilterCondition filterCondition;
    private boolean invertFlag;

    public InclusionExclusionFilter(String columnId, List<DataValue> inclusionValues, List<DataValue> exclusionValues, FilterCondition condition) throws MissingFilterParametersException {
        this(columnId, null, null, inclusionValues, exclusionValues, condition, false);
    }

    @JsonCreator
    public InclusionExclusionFilter(@JsonProperty(value="columnId") String columnId, @JsonProperty(value="filterId") String filterId, @JsonProperty(value="label") String label, @JsonProperty(value="inclusionValues") List<DataValue> inclusionValues, @JsonProperty(value="exclusionValues") List<DataValue> exclusionValues, @JsonProperty(value="filterCondition") FilterCondition condition, @JsonProperty(value="invertFlag") boolean invertFlag) throws MissingFilterParametersException {
        super(columnId, filterId, label);
        if (inclusionValues != null) {
            this.inclusionValues.addAll(inclusionValues);
        }
        if (exclusionValues != null) {
            this.exclusionValues.addAll(exclusionValues);
        }
        if (condition != null) {
            this.setFilterCondition(condition);
        }
        if (inclusionValues == null && exclusionValues == null && condition == null) {
            throw new MissingFilterParametersException("Inclusion/Exclusion filter requires data values list or Filter filterCondition");
        }
        this.invertFlag = invertFlag;
    }

    public InclusionExclusionFilter(InclusionExclusionFilter source) throws MissingFilterParametersException {
        super(source.getColumnId(), source.getFilterId(), source.getLabel());
        if (source.getInclusionValues() != null) {
            this.inclusionValues.addAll(source.getInclusionValues());
        }
        if (source.getExclusionValues() != null) {
            this.exclusionValues.addAll(source.getExclusionValues());
        }
        this.setInvertFlag(source.getInvertFlag());
        this.setFilterCondition(source.getFilterCondition());
    }

    public static InclusionExclusionFilter negate(InclusionExclusionFilter source) {
        try {
            InclusionExclusionFilter filter = new InclusionExclusionFilter(source);
            filter.invertFlag = !filter.invertFlag;
            return filter;
        }
        catch (MissingFilterParametersException e) {
            return null;
        }
    }

    public List<DataValue> getInclusionValues() {
        return this.inclusionValues;
    }

    public void setInclusionValues(List<DataValue> inclusionValues) {
        this.inclusionValues.clear();
        this.inclusionValues.addAll(inclusionValues);
    }

    public List<DataValue> getExclusionValues() {
        return this.exclusionValues;
    }

    public void setExclusionValues(List<DataValue> exclusionValues) {
        this.exclusionValues.clear();
        this.exclusionValues.addAll(exclusionValues);
    }

    public FilterCondition getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(FilterCondition c) {
        this.filterCondition = c;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject obj = new JSONObject();
        super.toJSONObject(obj);
        if (this.getFilterCondition() != null) {
            obj.put((Object)"filterCondition", (Object)this.getFilterCondition().toJSONObject());
        }
        JSONArray inclusionJsonValues = new JSONArray();
        this.inclusionValues.forEach(v -> inclusionJsonValues.add((Object)v.toJSONObjcet()));
        obj.put((Object)"inclusionValues", (Object)inclusionJsonValues);
        JSONArray exclusionJsonValues = new JSONArray();
        this.exclusionValues.forEach(v -> exclusionJsonValues.add((Object)v.toJSONObjcet()));
        obj.put((Object)"exclusionValues", (Object)exclusionJsonValues);
        obj.put((Object)"invertFlag", (Object)this.getInvertFlag());
        return obj;
    }

    @Override
    public FilterType getType() {
        return FilterType.INCLUSION_EXCLUSION;
    }

    public boolean getInvertFlag() {
        return this.invertFlag;
    }

    public void setInvertFlag(boolean invertFlag) {
        this.invertFlag = invertFlag;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exclusionValues == null ? 0 : this.exclusionValues.hashCode());
        result = 31 * result + (this.filterCondition == null ? 0 : this.filterCondition.hashCode());
        result = 31 * result + (this.inclusionValues == null ? 0 : this.inclusionValues.hashCode());
        result = 31 * result + (this.invertFlag ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InclusionExclusionFilter other = (InclusionExclusionFilter)obj;
        if (this.exclusionValues == null ? other.exclusionValues != null : !this.exclusionValues.equals(other.exclusionValues)) {
            return false;
        }
        if (this.filterCondition == null ? other.filterCondition != null : !this.filterCondition.equals(other.filterCondition)) {
            return false;
        }
        if (this.inclusionValues == null ? other.inclusionValues != null : !this.inclusionValues.equals(other.inclusionValues)) {
            return false;
        }
        return this.invertFlag == other.invertFlag;
    }

    public static class DataValue {
        String uniqueValue;
        String displayValue;

        public DataValue() {
        }

        @JsonCreator
        public DataValue(@JsonProperty(value="uniqueValue") String uniqueValue, @JsonProperty(value="displayValue") String displayValue) {
            this.uniqueValue = uniqueValue;
            this.displayValue = displayValue;
        }

        public JSONObject toJSONObjcet() {
            JSONObject obj = new JSONObject();
            obj.put((Object)"uniqueValue", (Object)this.uniqueValue);
            obj.put((Object)"displayValue", (Object)this.displayValue);
            return obj;
        }

        public String getUniqueValue() {
            return this.uniqueValue;
        }

        public void setUniqueValue(String uniqueValue) {
            this.uniqueValue = uniqueValue;
        }

        public String getDisplayValue() {
            return this.displayValue;
        }

        public void setDisplayValue(String displayValue) {
            this.displayValue = displayValue;
        }
    }
}

