/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.mq.progress;

import com.ibm.smarts.common.mq.SmartsModuleMessageGroup;
import com.ibm.smarts.common.mq.SmartsModuleTask;
import com.ibm.smarts.common.mq.message.SmartsModuleDoneMessage;
import com.ibm.smarts.common.mq.message.SmartsModuleMessage;
import com.ibm.smarts.common.mq.message.SmartsModuleTaskDoneMessage;
import com.ibm.smarts.common.mq.progress.SmartsModuleProgress;
import com.ibm.smarts.common.mq.progress.SmartsModuleProgressUtil;
import com.ibm.smarts.common.mq.progress.SmartsModuleTaskProgress;
import com.ibm.smarts.core.api.Handlers;
import com.ibm.smarts.core.mq.MessageProducerProvider;
import com.ibm.smarts.core.mq.TypedMessageConsumer;
import com.ibm.smarts.core.mq.TypedMessageProducer;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsModuleProgressConsumer
implements TypedMessageConsumer<SmartsModuleMessage>,
Handlers {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsModuleProgressConsumer.class);
    private final IStoreProvider storeProvider;
    private final SmartsModuleTask task;

    public SmartsModuleProgressConsumer(IStoreProvider storeProvider, SmartsModuleTask task) {
        this.storeProvider = storeProvider;
        this.task = task;
    }

    public Class<SmartsModuleMessage> getItemClass() {
        return SmartsModuleMessage.class;
    }

    public void receiveMessage(RequestContext rc, MessageProducerProvider producerProvider, SmartsModuleMessage message) {
        this.handle(rc, context -> {
            String smartsModuleId = message.getSmartsModuleId();
            String progressKey = this.task.scope == SmartsModuleTask.Scope.MODULE ? message.getSmartsModuleId() : message.getDatasetId();
            SmartsModuleProgress progress = SmartsModuleProgressUtil.applyProgress(this.storeProvider, this.task, smartsModuleId, progressKey, message.getStatus());
            this.postIfDone((RequestContext)context, progress, smartsModuleId, producerProvider);
            return null;
        });
    }

    private void postIfDone(RequestContext rc, SmartsModuleProgress progress, String smartsModuleId, MessageProducerProvider producerProvider) {
        TypedMessageProducer producer;
        Object doneMessage;
        SmartsModuleTaskProgress taskProgress = progress.getTaskProgress(this.task.id);
        if (taskProgress.isDone()) {
            LOGGER.info("Smarts Module task done: " + this.task.id + ", " + smartsModuleId);
            doneMessage = new SmartsModuleTaskDoneMessage(this.task.id, smartsModuleId, taskProgress);
            producer = producerProvider.producer(SmartsModuleTaskDoneMessage.class);
            producer.takeMessage(SmartsModuleMessageGroup.DEFAULT_SMARTS_MODULE_TASK_DONE_QUEUE, doneMessage);
        }
        if (progress.isDone()) {
            LOGGER.info("Smarts Module done: " + smartsModuleId);
            doneMessage = new SmartsModuleDoneMessage(smartsModuleId, progress);
            producer = producerProvider.producer(SmartsModuleDoneMessage.class);
            producer.takeMessage(SmartsModuleMessageGroup.DEFAULT_SMARTS_MODULE_DONE_QUEUE, doneMessage);
            SmartsModuleProgressUtil.deleteProgress(this.storeProvider, smartsModuleId);
            this.storeProvider.getModuleStore(rc).deleteById(smartsModuleId);
        }
    }
}

