/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.mq.progress;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.common.mq.message.SmartsModuleStatus;
import java.util.HashMap;
import java.util.Map;

public class SmartsModuleTaskProgress {
    public final String taskId;
    public final String smartsModuleId;
    public int expectedStatusCount;
    public final Map<String, SmartsModuleStatus> statusMap;

    @JsonCreator
    public SmartsModuleTaskProgress(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="smartsModuleId") String smartsModuleId, @JsonProperty(value="expectedStatusCount") int expectedStatusCount, @JsonProperty(value="statusMap") Map<String, SmartsModuleStatus> statusMap) {
        this.taskId = taskId;
        this.smartsModuleId = smartsModuleId;
        this.expectedStatusCount = expectedStatusCount;
        this.statusMap = statusMap;
    }

    public SmartsModuleTaskProgress(String taskId, String smartsModuleId, int expectedStatusCount) {
        this(taskId, smartsModuleId, expectedStatusCount, new HashMap<String, SmartsModuleStatus>(expectedStatusCount));
    }

    public void addStatus(String key, SmartsModuleStatus status) {
        this.statusMap.put(key, status);
    }

    @JsonIgnore
    public boolean isDone() {
        return this.statusMap.size() == this.expectedStatusCount;
    }

    @JsonIgnore
    public boolean isSuccess() {
        if (this.isDone()) {
            return this.statusMap.values().stream().allMatch(s -> s.isSuccess());
        }
        return false;
    }

    @JsonIgnore
    public SmartsModuleStatus getStatus(String key) {
        return this.statusMap.get(key);
    }
}

