/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.pipeline;

import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.schema.DataClue;
import com.ibm.smarts.semanticsearch.impl.NLUEntityContext;
import com.ibm.smarts.semanticsearch.impl.SearchContext;
import com.ibm.smarts.semanticsearch.pipeline.IAnnotator;
import com.ibm.smarts.semanticsearch.util.SemanticSearchHelper;
import com.ibm.smarts.store.api.provider.IDataClueStore;
import com.ibm.smarts.store.api.query.IRecordResult;
import com.ibm.smarts.store.api.query.IStoreQuery;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataValueAnnotator
implements IAnnotator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataValueAnnotator.class);
    private SearchContext searchContext;

    public DataValueAnnotator(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    @Override
    public void accept(NLUEntityContext entityContext) {
        IDataClueStore dataClueStore = this.searchContext.getStoreProvider().getDataClueStore(this.searchContext.getReqCtx());
        IStoreQuery query = SemanticSearchHelper.buildValueQuery(dataClueStore, entityContext.getNluEntity().getText());
        List hits = dataClueStore.executeSearch(query);
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sbd = new StringBuilder().append(String.format("search in dataClue with query: [%s]", entityContext.getNluEntity().getText()));
            for (IRecordResult h2 : hits) {
                sbd.append(String.format("\n[Score: %s | ID: %s]\n", Float.valueOf(h2.getScore()), h2.getRecord().getId()));
                sbd.append(CommonJAXBHelper.marshalToJSON((Object)h2.getRecord().getRecord(), (boolean)true));
            }
            LOGGER.debug("\n" + sbd.toString());
        }
        if (hits.isEmpty()) {
            return;
        }
        hits = hits.stream().filter(h -> !((DataClue)h.getRecord().getRecord()).getConceptID().equals("http://www.ibm.com/ontologies/waca/application#Boolean")).collect(Collectors.toList());
        String entityText = entityContext.getNluEntity().getText();
        List editDistances = hits.stream().map(h -> Float.valueOf(SemanticSearchHelper.findEditDistance(entityText, ((DataClue)h.getRecord().getRecord()).getValue()))).collect(Collectors.toList());
        for (int i = 0; i < hits.size(); ++i) {
            String concept = ((DataClue)((IRecordResult)hits.get(i)).getRecord().getRecord()).getConceptID().replace("http://www.ibm.com/ontologies/waca/domain/common#", "");
            float normalizedScore = 1.0f - ((Float)editDistances.get(i)).floatValue();
            entityContext.getHighestConceptScoreMap().compute(concept, (key, val) -> Float.valueOf(val == null ? normalizedScore : Math.max(val.floatValue(), normalizedScore)));
        }
    }
}

