/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.pipeline;

import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.semanticsearch.impl.NLUEntityContext;
import com.ibm.smarts.semanticsearch.impl.SearchContext;
import com.ibm.smarts.semanticsearch.pipeline.IAnnotator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NlpAnnotator
implements IAnnotator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NlpAnnotator.class);
    private SearchContext searchContext;

    public NlpAnnotator(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    @Override
    public void accept(NLUEntityContext nluContext) {
        List labels;
        TextInfo textInfo = null;
        String entityText = nluContext.getNluEntity().getText();
        if (entityText != null && !(labels = this.searchContext.getNlp().describeText(this.searchContext.getReqCtx(), new String[]{entityText})).isEmpty()) {
            textInfo = (TextInfo)labels.get(0);
        }
        if (textInfo != null) {
            PhraseInfo phraseInfo = (PhraseInfo)textInfo.getPhrases().get(0);
            nluContext.setNluPhraseInfo(phraseInfo);
        }
    }
}

