/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules;

import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.ContextCreationListener;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.ExtendedSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.SaturationUtils;
import org.semanticweb.elk.reasoner.saturation.conclusions.CombinedConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.Conclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionInsertionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionSourceUnsaturationVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.context.ContextStatistics;
import org.semanticweb.elk.reasoner.saturation.rules.DecompositionRuleApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.ForwardDecompositionRuleApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.RuleEngine;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.SimpleInterrupter;
import org.semanticweb.elk.util.logging.CachedTimeThread;

public class RuleApplicationFactory
extends SimpleInterrupter {
    protected static final Logger LOGGER_ = Logger.getLogger(RuleApplicationFactory.class);
    final SaturationState saturationState;
    private final SaturationStatistics aggregatedStats_ = new SaturationStatistics();
    private final boolean trackModifiedContexts_;

    public RuleApplicationFactory(SaturationState saturationState) {
        this(saturationState, false);
    }

    public RuleApplicationFactory(SaturationState saturationState, boolean trackModifiedContexts) {
        this.saturationState = saturationState;
        this.trackModifiedContexts_ = trackModifiedContexts;
    }

    public BaseEngine getDefaultEngine(ContextCreationListener listener, ContextModificationListener modListener) {
        return new DefaultEngine(listener, modListener);
    }

    public void finish() {
    }

    public SaturationStatistics getSaturationStatistics() {
        return this.aggregatedStats_;
    }

    public SaturationState getSaturationState() {
        return this.saturationState;
    }

    public class DefaultEngine
    extends BaseEngine {
        private final ExtendedSaturationStateWriter saturationStateWriter_;

        protected DefaultEngine(ExtendedSaturationStateWriter saturationStateWriter, SaturationStatistics localStatistics) {
            super(localStatistics);
            this.saturationStateWriter_ = saturationStateWriter;
        }

        protected DefaultEngine(ContextCreationListener listener, ContextModificationListener modListener) {
            this(listener, modListener, new SaturationStatistics());
        }

        private DefaultEngine(ContextCreationListener listener, ContextModificationListener modificationListener, SaturationStatistics localStatistics) {
            this(this$0.saturationState.getExtendedWriter(SaturationUtils.addStatsToContextCreationListener(listener, localStatistics.getContextStatistics()), SaturationUtils.addStatsToContextModificationListener(modificationListener, localStatistics.getContextStatistics()), SaturationUtils.getStatsAwareCompositionRuleAppVisitor(localStatistics.getRuleStatistics()), SaturationUtils.addStatsToConclusionVisitor(localStatistics.getConclusionStatistics()), this$0.trackModifiedContexts_), localStatistics);
        }

        public void submit(IndexedClassExpression job) {
            this.saturationStateWriter_.getCreateContext(job);
        }

        @Override
        protected ExtendedSaturationStateWriter getSaturationStateWriter() {
            return this.saturationStateWriter_;
        }

        @Override
        protected DecompositionRuleApplicationVisitor getDecompositionRuleApplicationVisitor() {
            ForwardDecompositionRuleApplicationVisitor visitor = new ForwardDecompositionRuleApplicationVisitor(this.saturationStateWriter_);
            return SaturationUtils.getStatsAwareDecompositionRuleAppVisitor(visitor, this.localStatistics.getRuleStatistics());
        }
    }

    public abstract class BaseEngine
    implements InputProcessor<IndexedClassExpression>,
    RuleEngine {
        private ConclusionVisitor<?> conclusionProcessor_;
        protected final SaturationStatistics localStatistics;
        protected final ContextStatistics localContextStatistics;

        protected BaseEngine(SaturationStatistics localStatistics) {
            this.localStatistics = localStatistics;
            this.localContextStatistics = localStatistics.getContextStatistics();
        }

        public void process() {
            Context nextContext;
            this.localContextStatistics.timeContextProcess -= CachedTimeThread.getCurrentTimeMillis();
            BasicSaturationStateWriter writer = this.getSaturationStateWriter();
            if (this.conclusionProcessor_ == null) {
                this.conclusionProcessor_ = this.getConclusionProcessor(writer);
            }
            while (!RuleApplicationFactory.this.isInterrupted() && (nextContext = writer.pollForActiveContext()) != null) {
                this.process(nextContext);
            }
            this.localContextStatistics.timeContextProcess += CachedTimeThread.getCurrentTimeMillis();
        }

        public void finish() {
            RuleApplicationFactory.this.aggregatedStats_.add(this.localStatistics);
            this.localStatistics.reset();
        }

        protected void process(Context context) {
            ++this.localContextStatistics.countProcessedContexts;
            Conclusion conclusion;
            while ((conclusion = context.takeToDo()) != null) {
                conclusion.accept(this.conclusionProcessor_, context);
            }
            return;
        }

        protected ConclusionVisitor<Boolean> getUsedConclusionsCountingVisitor(ConclusionVisitor<Boolean> ruleProcessor) {
            return SaturationUtils.getUsedConclusionCountingProcessor(ruleProcessor, this.localStatistics);
        }

        protected ConclusionVisitor<Boolean> getBaseConclusionProcessor(BasicSaturationStateWriter saturationStateWriter) {
            return new CombinedConclusionVisitor(new ConclusionInsertionVisitor(), this.getUsedConclusionsCountingVisitor(new ConclusionApplicationVisitor(saturationStateWriter, SaturationUtils.getStatsAwareCompositionRuleAppVisitor(this.localStatistics.getRuleStatistics()), SaturationUtils.getStatsAwareDecompositionRuleAppVisitor(this.getDecompositionRuleApplicationVisitor(), this.localStatistics.getRuleStatistics()))));
        }

        protected ConclusionVisitor<?> getConclusionProcessor(BasicSaturationStateWriter saturationStateWriter) {
            CombinedConclusionVisitor result = this.getBaseConclusionProcessor(saturationStateWriter);
            if (RuleApplicationFactory.this.trackModifiedContexts_) {
                result = new CombinedConclusionVisitor(result, new ConclusionSourceUnsaturationVisitor(saturationStateWriter));
            }
            return SaturationUtils.getProcessedConclusionCountingProcessor(result, this.localStatistics);
        }

        protected abstract DecompositionRuleApplicationVisitor getDecompositionRuleApplicationVisitor();

        protected abstract BasicSaturationStateWriter getSaturationStateWriter();
    }
}

