/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.combinations.generator.internal;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.combinations.generator.api.IDataSet;
import com.ibm.smarts.combinations.generator.api.IFilter;
import com.ibm.smarts.combinations.generator.internal.DataSet;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.value.DoubleValue;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.decor.ValueDecoration;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.schema.TextInfo;
import com.ibm.smarts.schema.UsageType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class DataColumn
implements IDataColumn {
    private static final int DEFAULT_QUANTITY = 0;
    private static final int UNINITIALIZED_INT = Integer.MIN_VALUE;
    private static final double UNINITIALIZED_DOUBLE = Double.MIN_VALUE;
    private static final double DEFAULT_DENSITY = 0.0;
    private static final double DEFAULT_MIN = Double.MIN_VALUE;
    private static final double DEFAULT_MAX = Double.MIN_VALUE;
    private static final int DEFAULT_NULL_COUNT = 0;
    private static final double DEFAULT_MEAN = 1.0000000001;
    private static final double DEFAULT_STD_DEV = 1.0000000001;
    private ColumnInfo ci;
    private DataSet dataset;
    private int quantity = Integer.MIN_VALUE;
    private double density = Double.MIN_VALUE;
    private Value mean = new DoubleValue(1.0000000001);
    private Value stdDev = new DoubleValue(1.0000000001);
    private Value min = new DoubleValue(Double.MIN_VALUE);
    private Value max = new DoubleValue(Double.MIN_VALUE);
    private int nullCount = Integer.MIN_VALUE;
    private boolean nullable = false;
    private List<IDataColumn> hierarchy = null;
    private List<IDataColumn> parentHierarchy = new ArrayList<IDataColumn>();
    private IFilter filter = null;
    private boolean isPrimary = false;

    public DataColumn(ColumnInfo ci) {
        this.ci = ci;
    }

    public DataColumn(ColumnInfo ci, DataSet dataset, IFilter filter) {
        this.ci = ci;
        this.dataset = dataset;
        this.filter = filter;
    }

    public DataColumn(ColumnInfo ci, DataSet dataset, IFilter filter, boolean isPrimary) {
        this.ci = ci;
        this.dataset = dataset;
        this.filter = filter;
        this.isPrimary = isPrimary;
    }

    public DataColumn(ColumnInfo ci, DataSet dataset, List<IDataColumn> parentHierarchy, IFilter filter, boolean isPrimary) {
        this.ci = ci;
        this.dataset = dataset;
        this.parentHierarchy = parentHierarchy;
        this.filter = filter;
        this.isPrimary = isPrimary;
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    @Override
    public IDataSet getDataSet() {
        return this.dataset;
    }

    @Override
    public String getId() {
        return this.ci.getId();
    }

    @Override
    public String getIdForExpression() {
        return this.ci.getIdForExpression();
    }

    @Override
    public String getName() {
        return this.ci.getName();
    }

    @Override
    public String getDescription() {
        return this.ci.getDescription();
    }

    @Override
    public TextInfo getLabel() {
        return this.ci.getLabel();
    }

    @Override
    public DataType getDataType() {
        return this.ci.getDataType();
    }

    @Override
    public UsageType getUsageType() {
        if (this.ci.getSemanticInfo() == null || this.ci.getSemanticInfo().getUsage() == null) {
            return UsageType.AUTOMATIC;
        }
        return this.ci.getSemanticInfo().getUsage();
    }

    @Override
    public SemanticInfo getSemanticInfo() {
        return this.ci.getSemanticInfo();
    }

    @Override
    public List<String> getSamples() {
        return this.ci.getSamples();
    }

    @Override
    public List<String> getSampleDistinctValues() {
        return this.ci.getSampleDistinctValues();
    }

    @Override
    public List<Integer> getSampleDistinctValueCounts() {
        return this.ci.getSampleDistinctValueCounts();
    }

    @Override
    public List<Statistic> getStatistics() {
        return this.ci.getStatistics();
    }

    @Override
    public List<Statistic> getSampleStatistics() {
        return this.ci.getSampleStatistics();
    }

    @Override
    public List<ValueDecoration> getValueDecorations() {
        return this.ci.getValueDecorations();
    }

    @Override
    public String getExpression() {
        return this.ci.getExpression();
    }

    @Override
    public List<String> getFlatListOfConcepts() {
        if (this.ci.getSemanticInfo() == null) {
            return Collections.emptyList();
        }
        return this.getFlattenedConceptsList(ConceptsRegistry.instance().getConcepts(this.ci.getSemanticInfo().getConcepts().stream().map(ConceptInfo::getConceptID).collect(Collectors.toList())));
    }

    @Override
    public boolean hasConcept(String conceptID) {
        if (this.ci.getSemanticInfo() == null) {
            return false;
        }
        LinkedList queue = new LinkedList();
        queue.addAll(ConceptsRegistry.instance().getConcepts(this.ci.getSemanticInfo().getConcepts().stream().map(ConceptInfo::getConceptID).collect(Collectors.toList())));
        while (!queue.isEmpty()) {
            Concept c = (Concept)queue.poll();
            if (c.getIRI().equals(conceptID)) {
                return true;
            }
            queue.addAll(c.getParents());
        }
        return false;
    }

    @Override
    public boolean hasAnyOfTheseConcepts(List<String> conceptIDs) {
        LinkedList queue = new LinkedList();
        if (this.ci.getSemanticInfo() == null) {
            return false;
        }
        queue.addAll(ConceptsRegistry.instance().getConcepts(this.ci.getSemanticInfo().getConcepts().stream().map(ConceptInfo::getConceptID).collect(Collectors.toList())));
        while (!queue.isEmpty()) {
            Concept c = (Concept)queue.poll();
            if (conceptIDs.contains(c.getIRI())) {
                return true;
            }
            queue.addAll(c.getParents());
        }
        return false;
    }

    private List<String> getFlattenedConceptsList(List<Concept> c) {
        HashSet<String> conceptsList = new HashSet<String>();
        for (Concept concept : c) {
            if (concept == null) continue;
            conceptsList.add(concept.getIRI());
            if (concept.getParents().isEmpty()) continue;
            conceptsList.addAll(concept.getAncestors().stream().map(Concept::getIRI).collect(Collectors.toList()));
        }
        return conceptsList.stream().collect(Collectors.toList());
    }

    @Override
    public boolean hasStatistic(StatisticType statType) {
        for (Statistic stat : this.ci.getStatistics()) {
            if (!stat.getType().equals((Object)statType) || stat.getValue() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getQuantity() {
        if (this.quantity == Integer.MIN_VALUE) {
            this.quantity = 0;
            for (Statistic stat : this.ci.getStatistics()) {
                if (!stat.getType().equals((Object)StatisticType.DISTINCT_COUNT) || stat.getValue() == null) continue;
                if (this.filter != null) {
                    this.quantity = Math.min(stat.getValue().intValue(), this.filter.getSelectedValuesCount());
                    break;
                }
                this.quantity = stat.getValue().intValue();
                break;
            }
        }
        return this.quantity;
    }

    @Override
    public boolean isQuantityUndefined() {
        if (this.quantity == Integer.MIN_VALUE) {
            this.quantity = this.getQuantity();
        }
        return this.quantity == 0;
    }

    @Override
    public Value getMean() {
        if (Double.compare(this.mean.doubleValue(), 1.0000000001) == 0) {
            for (Statistic stat : this.ci.getStatistics()) {
                if (!stat.getType().equals((Object)StatisticType.MEAN) || stat.getValue() == null) continue;
                this.mean = stat.getValue();
                break;
            }
        }
        return this.mean;
    }

    @Override
    public Value getStdDev() {
        if (Double.compare(this.stdDev.doubleValue(), 1.0000000001) == 0) {
            for (Statistic stat : this.ci.getStatistics()) {
                if (!stat.getType().equals((Object)StatisticType.STDDEV) || stat.getValue() == null) continue;
                this.stdDev = stat.getValue();
                break;
            }
        }
        return this.stdDev;
    }

    @Override
    public double getDensity() {
        if (Double.compare(this.density, Double.MIN_VALUE) == 0) {
            this.density = 0.0;
            for (Statistic stat : this.ci.getStatistics()) {
                if (!stat.getType().equals((Object)StatisticType.DENSITY) || stat.getValue() == null) continue;
                this.density = stat.getValue().doubleValue();
                break;
            }
        }
        return this.density;
    }

    @Override
    public Value getMin() {
        if (Double.compare(this.min.doubleValue(), Double.MIN_VALUE) == 0) {
            for (Statistic stat : this.ci.getStatistics()) {
                if (!stat.getType().equals((Object)StatisticType.MIN_VALUE) || stat.getValue() == null) continue;
                this.min = stat.getValue();
                break;
            }
        }
        return this.min;
    }

    @Override
    public Value getMax() {
        if (Double.compare(this.max.doubleValue(), Double.MIN_VALUE) == 0) {
            for (Statistic stat : this.ci.getStatistics()) {
                if (!stat.getType().equals((Object)StatisticType.MAX_VALUE) || stat.getValue() == null) continue;
                this.max = stat.getValue();
                break;
            }
        }
        return this.max;
    }

    @Override
    public boolean isNullable() {
        if (this.nullCount == Integer.MIN_VALUE) {
            this.nullCount = 0;
            for (Statistic stat : this.ci.getStatistics()) {
                if (!stat.getType().equals((Object)StatisticType.NULL_COUNT) || stat.getValue() == null) continue;
                this.nullCount = stat.getValue().intValue();
                if (this.filter != null) {
                    this.nullable = !this.filter.excludesNulls();
                    break;
                }
                this.nullable = this.nullCount > 0;
                break;
            }
        }
        return this.nullable;
    }

    @Override
    public boolean isHierchical() {
        return this.hierarchy != null;
    }

    @Override
    public void setHierarchy(List<IDataColumn> hierarchy) {
        this.hierarchy = hierarchy;
    }

    @Override
    public List<IDataColumn> getHierarchy() {
        if (!this.isHierchical()) {
            return Collections.emptyList();
        }
        return this.hierarchy;
    }

    public String toString() {
        return this.ci.getName();
    }

    @Override
    public IDataColumn shallowCopy() {
        DataColumn res = new DataColumn(this.ci);
        res.quantity = this.quantity;
        res.dataset = this.dataset;
        res.parentHierarchy = this.parentHierarchy;
        res.filter = this.filter;
        return res;
    }

    @Override
    public List<IDataColumn> getParentHierarchy() {
        return this.parentHierarchy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ci == null ? 0 : this.ci.hashCode());
        result = 31 * result + (this.dataset == null ? 0 : this.dataset.hashCode());
        result = 31 * result + (this.hierarchy == null ? 0 : this.hierarchy.hashCode());
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataColumn other = (DataColumn)obj;
        if (this.ci == null ? other.ci != null : !this.ci.equals(other.ci)) {
            return false;
        }
        if (this.dataset == null ? other.dataset != null : !this.dataset.equals(other.dataset)) {
            return false;
        }
        if (this.hierarchy == null ? other.hierarchy != null : !this.hierarchy.equals(other.hierarchy)) {
            return false;
        }
        return !(this.filter == null ? other.filter != null : !this.filter.equals(other.filter));
    }

    @Override
    public void setParentHierarchy(List<IDataColumn> hierarchy) {
        this.parentHierarchy = hierarchy;
    }
}

