/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.configtest.TrustRootUnitTest;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.DefaultAdditionalInfoHandler;
import com.cognos.accman.jcam.crypto.casync.CaFreshnessHandler;
import com.cognos.accman.jcam.crypto.casync.CaSyncHandler;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CAMKeyStore;
import com.cognos.accman.jcam.crypto.misc.CAMStatusHandler;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapperException;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.misc.KeyStoreManager;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.jcam.crypto.misc.KeyStoreWriter;
import com.cognos.accman.jcam.crypto.misc.KeysAlreadyExistException;
import com.cognos.accman.res.MessageSet;
import com.cognos.crconfig.ICnfgFeedback;
import java.io.File;
import java.security.PrivateKey;
import java.util.Locale;
import java.util.ResourceBundle;

public class ConfiguringSession
extends DefaultAdditionalInfoHandler {
    private String serviceID;
    private ResourceBundle m_resource = null;
    private ICnfgFeedback m_feedback = null;

    ConfiguringSession(String serviceID) {
        this.serviceID = serviceID;
        this.m_resource = ResourceBundle.getBundle("jcam_errors", Locale.getDefault());
    }

    public void configure() throws CAMCryptoException {
        new IPFTraceFunction("configure", this).logEntry();
        Configuration config = Configuration.getInstance();
        if (config.getWeAreCM() && !this.checkAndWarnReganeratingKeystores()) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        try {
            KeyStoreManager ksMgr = KeyStoreManager.getInstance();
            CAMKeyStore store = ksMgr.getCAKeystore("ca");
            store.updateParameters(config.getCAMKeystoreLocation(), config.getCAKeyPassword(), config.getCAFormat(), config.getAsymmKeystoreProviderName());
            this.genCAKeyPairs();
            this.genKeyPairs();
            this.genCSK();
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("configure", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("configure", this).logExit();
    }

    private boolean checkAndWarnReganeratingKeystores() throws CAMCryptoException {
        ICnfgFeedback feedback;
        Configuration config = Configuration.getInstance();
        String caFileName = config.getCAMKeystoreLocation();
        File caFile = new File(caFileName);
        if (caFile.exists()) {
            return true;
        }
        CAMStatusHandler csh = CAMStatusHandler.getInstance();
        csh.addKeystoreFreshness();
        Integer ksFreshness = csh.getKeystoreFreshness();
        if (ksFreshness > 2 && (feedback = config.getConfigFeedback()) != null) {
            String defaultAnswer = new String("0");
            String msgCapation = CAMCryptoUtilities.extractMsgString(MessageSet.getMessage("CAM_CRP_regenerating_keys_warning_caption"));
            String msg1 = CAMCryptoUtilities.extractMsgString(MessageSet.getMessage("CAM_CRP_regenerating_keys_warning_msg1"));
            String msg2 = CAMCryptoUtilities.extractMsgString(MessageSet.getMessage("CAM_CRP_regenerating_keys_warning_msg2"));
            String msgConfirmation = CAMCryptoUtilities.extractMsgString(MessageSet.getMessage("CAM_CRP_regenerating_keys_warning_confirmation"));
            String szCnfgMsg = "<prompt name=\"Warning\"><caption>" + msgCapation + "</caption>" + "<type>warning</type>" + "<paragraph>" + msg1 + "</paragraph>" + "<paragraph>" + msg2 + "</paragraph>" + "<confirmation>" + msgConfirmation + "</confirmation>" + "<default>" + defaultAnswer + "</default>" + "</prompt>";
            String response = feedback.prompt(szCnfgMsg);
            if (response.compareToIgnoreCase("1") == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean configure(ICnfgFeedback feedback) throws CAMCryptoException {
        new IPFTraceFunction("configure", this).logEntry();
        boolean bRetFlag = false;
        if (feedback == null) {
            new IPFTraceFunction("configure", this).logExit();
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        Configuration config = Configuration.getInstance();
        if (config == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        config.setConfigFeedback(feedback);
        this.m_feedback = feedback;
        String s = null;
        TrustRootUnitTest trustRootUnitTest = new TrustRootUnitTest();
        trustRootUnitTest.getClass();
        int ret = 5;
        ret = trustRootUnitTest.test();
        trustRootUnitTest.getClass();
        if (ret == 5) {
            s = this.m_resource != null ? this.m_resource.getString("CAM_CRP_config_test_different_trustroot") : "CAM-CRP-1315: Current configuration points to a different Trust Domain than originally configured.\nCannot find Resouce Bundle.";
            feedback.showError(s);
            bRetFlag = false;
        } else {
            bRetFlag = true;
        }
        if (!bRetFlag) {
            new IPFTraceFunction("configure", this).logExit();
            return bRetFlag;
        }
        this.configure();
        new IPFTraceFunction("configure", this).logExit();
        return bRetFlag;
    }

    private boolean genKeyPairs() throws CAMCryptoException {
        new IPFTraceFunction("genKeyPairs", this).logEntry();
        Configuration config = Configuration.getInstance();
        if (config.getWeAreCM() || config.isStandaloneCA() || config.getUsingThirdPartyCA()) {
            return false;
        }
        boolean camCryptoKeyChanged = true;
        try {
            try {
                this.generateKeyPairAndSaveKeystoreIfRequired("encryption");
            }
            catch (KeysAlreadyExistException e) {
                camCryptoKeyChanged = false;
            }
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("genKeyPairs", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("genKeyPairs", this).logExit();
        return camCryptoKeyChanged;
    }

    private void generateKeyPairAndSaveKeystoreIfRequired(String alias) throws CryptoWrapperException, CAMCryptoException {
        PrivateKey privKey = null;
        try {
            privKey = KeyStoreReader.getEncryptionPrivateKey();
            if (privKey == null) {
                this.generateKeyPairAndSaveKeystore(alias);
            }
        }
        catch (CAMCryptoException e) {
            this.generateKeyPairAndSaveKeystore(alias);
        }
    }

    private void generateKeyPairAndSaveKeystore(String alias) throws CAMCryptoException, CryptoWrapperException {
        KeyStoreWriter.createKeyPairAndAddToKeystore(alias);
        CaFreshnessHandler cafresh = CaFreshnessHandler.getInstance();
        if (cafresh.needSync()) {
            try {
                CaSyncHandler cash = CaSyncHandler.getInstance();
                cash.synchronizeCaCerts();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void genCSK() throws CAMCryptoException {
        new IPFTraceFunction("genCSK", this).logEntry();
        try {
            try {
                KeyStoreWriter.createCSK();
            }
            catch (KeysAlreadyExistException keysAlreadyExistException) {}
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("genCSK", this).logExit(e);
            throw e;
        }
        new IPFTraceFunction("genCSK", this).logExit();
    }

    private boolean genCAKeyPairs() throws CAMCryptoException {
        block5: {
            new IPFTraceFunction("genCAKeyPairs", this).logEntry();
            try {
                Configuration config = Configuration.getInstance();
                if (config.getUsingThirdPartyCA()) {
                    KeyStoreManager ksMgr = KeyStoreManager.getInstance();
                    ksMgr.getCAKeystore("ca");
                    break block5;
                }
                if (!config.getWeAreCM() && !config.isStandaloneCA()) break block5;
                try {
                    KeyStoreWriter.createCAKeyPair();
                }
                catch (KeysAlreadyExistException e) {
                    return false;
                }
            }
            catch (CAMCryptoException e) {
                new IPFAuditFunction("genCAKeyPairs", this).logExit(e);
                throw e;
            }
        }
        new IPFTraceFunction("genCAKeyPairs", this).logExit();
        return true;
    }
}

