/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.casync;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.casync.CaCacheMessaging;
import com.cognos.accman.jcam.crypto.casync.CaCacheWrapper;
import com.cognos.accman.jcam.crypto.casync.CaFreshnessHandler;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CAMKeyStore;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.jcam.crypto.misc.KeyStoreManager;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.res.MessageSet;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import java.util.function.Predicate;

public class CaSyncHandler {
    static IPFTraceLogger caTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CA");
    private Vector<X509Certificate> caCacheCerts = null;
    private CaCacheWrapper caCache = null;
    private boolean didWeUploadOurTrustStoreToCM = false;
    private static CaSyncHandler singleton = null;
    private boolean bNeedSave = true;
    private Vector<X509Certificate> caSystemCertsCache = null;

    private CaSyncHandler() {
        caTraceLogger.logEnter();
        this.didWeUploadOurTrustStoreToCM = false;
        this.caCacheCerts = new Vector();
        caTraceLogger.logExit(true);
    }

    public static synchronized CaSyncHandler getInstance() throws CAMCryptoException {
        caTraceLogger.logEnter();
        if (singleton == null) {
            singleton = new CaSyncHandler();
        }
        caTraceLogger.logExit(true);
        return singleton;
    }

    public void synchronizeCaCerts() throws CAMCryptoException {
        caTraceLogger.logEnter();
        this.pushLocalKeyStoreToCS();
        this.getCertsFromCS();
        if (this.bNeedSave) {
            this.writeLocal2Disk();
        }
        CaFreshnessHandler cafh = CaFreshnessHandler.getInstance();
        cafh.updateLocalFreshness();
        caTraceLogger.logExit(true);
    }

    public Vector getLocalCSCache() throws CAMCryptoException {
        if (this.caCacheCerts.size() <= 0) {
            this.synchronizeCaCerts();
        }
        return this.caCacheCerts;
    }

    private Vector getRemoteCSCache() throws CAMCryptoException {
        return this.transmitCAGetRequestForTest();
    }

    public boolean isSameTrustRoot() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        if (config.getWeAreCM() || config.isStandaloneCA()) {
            return true;
        }
        try {
            KeyStoreManager ksMgr = KeyStoreManager.getInstance();
            if (!ksMgr.isCAKeystoreValid()) {
                return true;
            }
        }
        catch (CAMCryptoException e1) {
            caTraceLogger.logExit(e1);
            return true;
        }
        Certificate encCert = null;
        X509Certificate encIssuerCA = null;
        try {
            encCert = KeyStoreReader.getEncryptionCertificate();
            encIssuerCA = KeyStoreReader.getIssuerCA(encCert);
        }
        catch (CAMCryptoException cAMCryptoException) {
            // empty catch block
        }
        Vector cas = null;
        try {
            cas = this.getRemoteCSCache();
        }
        catch (CAMCryptoException e2) {
            caTraceLogger.logExit(e2);
            throw e2;
        }
        boolean issuerFound = false;
        if (encCert != null) {
            if (encIssuerCA != null) {
                issuerFound = this.findCACert(cas, encIssuerCA);
            }
        } else {
            return true;
        }
        caTraceLogger.logExit(issuerFound);
        return issuerFound;
    }

    boolean findCACert(Vector remoteCAs, Certificate issuerCA) {
        boolean issuerFound = false;
        Enumeration e = remoteCAs.elements();
        while (e.hasMoreElements() && !issuerFound) {
            Certificate c = (Certificate)e.nextElement();
            if (!c.equals(issuerCA)) continue;
            caTraceLogger.logExit(true);
            issuerFound = true;
        }
        return issuerFound;
    }

    public void addCertToCSwithCaCache(byte[] cert) throws CAMCryptoException {
        caTraceLogger.logEnter();
        try {
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacache_digest_alg_not_found"));
                caTraceLogger.logExit(cce);
                throw cce;
            }
            md.update(cert);
            String key = new String(CryptoWrapper.encodeBase64(md.digest()));
            this.setupCaCache();
            if (this.caCache.getData(key) == null) {
                X509Certificate x509Cert = CryptoWrapper.decodeCert(cert);
                if (CAMCryptoUtilities.isCertAllowedInCS(x509Cert, caTraceLogger)) {
                    caTraceLogger.trace("adding ca cert: " + key + " - dn: " + x509Cert.getSubjectDN().getName());
                    this.caCache.addData(key, cert);
                } else {
                    caTraceLogger.trace("not adding ca cert: " + key + " - dn: " + x509Cert.getSubjectDN().getName());
                }
            }
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cacert_add_error"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        caTraceLogger.logExit(true);
    }

    public boolean addCertToCS(X509Certificate cert) throws CAMCryptoException {
        byte[] encodedCert;
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        try {
            encodedCert = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            caTraceLogger.trace("Error getting encoded information from cert.");
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cert_encoding"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        boolean ret = false;
        if (config.getWeAreCM() && !config.getWeAreTheConfigTool()) {
            this.addCertToCSwithCaCache(encodedCert);
            ret = true;
        } else {
            try {
                this.transmitCAAddRequest(encodedCert);
                ret = true;
            }
            catch (Exception e) {
                ret = false;
            }
        }
        caTraceLogger.logExit(ret);
        return ret;
    }

    private void getCertsFromCS() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        if (config.getWeAreCM() && !config.getWeAreTheConfigTool()) {
            this.syncCACache2Local();
        } else {
            this.transmitCAGetRequest();
        }
        caTraceLogger.logExit(true);
    }

    private void transmitCAGetRequest() throws CAMCryptoException {
        caTraceLogger.logEnter();
        try {
            CaCacheMessaging caCacheMessaging = new CaCacheMessaging();
            caTraceLogger.trace("Creating request.");
            byte[] baGet = caCacheMessaging.createGetRequest();
            caTraceLogger.trace("Creating BIBus wrapper.");
            String xmlMsg = caCacheMessaging.createBibusWrapper(baGet);
            caTraceLogger.trace("Transmitting request.");
            byte[] resp = caCacheMessaging.sendRequest(xmlMsg);
            caTraceLogger.trace("Remove BIBus wrapper.");
            byte[] payload = caCacheMessaging.removeBibusWrapper(resp);
            caTraceLogger.trace("Parsing response.");
            this.caCacheCerts = caCacheMessaging.parseGetResponse(payload);
        }
        catch (CAMCryptoException e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_ca_get_request_error"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        catch (CertificateParsingException e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_ca_get_request_error"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        caTraceLogger.logExit(true);
    }

    private boolean transmitCAAddRequest(byte[] cert) throws CAMCryptoException {
        caTraceLogger.logEnter();
        try {
            CaCacheMessaging caCacheMessaging = new CaCacheMessaging();
            caTraceLogger.trace("Creating request.");
            byte[] baGet = caCacheMessaging.createAddRequest(cert);
            caTraceLogger.trace("Creating BIBus Wrapper.");
            String xmlMsg = caCacheMessaging.createBibusWrapper(baGet);
            caTraceLogger.trace("Send request.");
            byte[] resp = caCacheMessaging.sendRequest(xmlMsg);
            caTraceLogger.trace("Remove response BIBus wrapper.");
            byte[] payload = caCacheMessaging.removeBibusWrapper(resp);
            caTraceLogger.trace("Parsing add response.");
            boolean addFlag = caCacheMessaging.parseAddResponse(payload);
            caTraceLogger.logExit(addFlag);
            return addFlag;
        }
        catch (CAMCryptoException e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_ca_add_request_error"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
    }

    private Vector<X509Certificate> transmitCAGetRequestForTest() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Vector<X509Certificate> testCaCacheCerts = null;
        try {
            CaCacheMessaging caCacheMessaging = new CaCacheMessaging();
            byte[] baGet = caCacheMessaging.createGetTestRequest();
            String xmlMsg = caCacheMessaging.createBibusWrapper(baGet);
            byte[] resp = caCacheMessaging.sendRequest(xmlMsg);
            byte[] payload = caCacheMessaging.removeBibusWrapper(resp);
            testCaCacheCerts = caCacheMessaging.parseGetResponse(payload);
        }
        catch (CAMCryptoException e) {
            CAMCryptoException cce = new CAMCryptoException(e.getRootCause(), MessageSet.getMessage("CAM_CRP_ca_get_request_error"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        catch (CertificateParsingException e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_ca_get_request_error"));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        caTraceLogger.logExit(Integer.toString(testCaCacheCerts.size()));
        return testCaCacheCerts;
    }

    private synchronized void setupCaCache() throws CAMCryptoException {
        caTraceLogger.logEnter();
        if (this.caCache == null) {
            this.caCache = CaCacheWrapper.getInstance();
        }
        caTraceLogger.logExit(true);
    }

    private synchronized void syncCACache2Local() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Vector<X509Certificate> caCacheCerts_backup = new Vector<X509Certificate>(this.caCacheCerts);
        this.caCacheCerts = new Vector();
        this.setupCaCache();
        String[] certDataKeys = this.caCache.getAllDataKeys();
        Exception firstError = null;
        for (String certDataKey : certDataKeys) {
            try {
                X509Certificate cert = CryptoWrapper.decodeCert(this.caCache.getData(certDataKey));
                if (CAMCryptoUtilities.isCertAllowedInCS(cert, caTraceLogger)) {
                    caTraceLogger.trace("caching ca cert: " + certDataKey + " - dn: " + cert.getSubjectDN().getName());
                    this.caCacheCerts.add(cert);
                    continue;
                }
                caTraceLogger.trace("deleting cert: " + certDataKey + " - dn: " + cert.getSubjectDN().getName());
                this.caCache.deleteData(certDataKey);
            }
            catch (Exception e) {
                caTraceLogger.trace("error loading cert: " + certDataKey, e);
                if (firstError != null) continue;
                firstError = e;
            }
        }
        this.bNeedSave = caCacheCerts_backup.size() != this.caCacheCerts.size() || !this.caCacheCerts.containsAll(caCacheCerts_backup);
        if (firstError != null && this.caCacheCerts.size() <= 0) {
            CAMCryptoException cce = new CAMCryptoException(firstError);
            caTraceLogger.logExit(cce);
            throw cce;
        }
        caTraceLogger.logExit(true);
    }

    public synchronized Vector<X509Certificate> getLocallyGeneratedCerts() throws CAMCryptoException {
        caTraceLogger.logEnter();
        KeyStoreManager ksMgr = KeyStoreManager.getInstance();
        Vector caPubublisherCerts = ksMgr.getCAPublishers();
        Vector caCerts = ksMgr.getCACertificates();
        if (this.caSystemCertsCache != null) {
            caTraceLogger.trace("returning system certs from cache. System certs size = " + this.caSystemCertsCache.size());
            caTraceLogger.logExit(!this.caSystemCertsCache.isEmpty());
            return new Vector<X509Certificate>(this.caSystemCertsCache);
        }
        final HashSet publisherSet = caPubublisherCerts == null ? new HashSet() : new HashSet(caPubublisherCerts);
        HashSet<X509Certificate> caCertsSet = caCerts == null ? new HashSet<X509Certificate>() : new HashSet(caCerts);
        caCertsSet.removeIf(new Predicate<X509Certificate>(){

            @Override
            public boolean test(X509Certificate c) {
                boolean inCaPublisher = publisherSet.contains(c);
                boolean isCaCert = c.getBasicConstraints() != -1;
                String logLine = String.format("isCaCert=%b, inCaPublisher=%b, SubjectDN=%s, issuerDn=%s, serial=%s", isCaCert, inCaPublisher, c.getSubjectDN().getName(), c.getIssuerDN().getName(), c.getSerialNumber().toString());
                caTraceLogger.trace(logLine);
                return inCaPublisher || !isCaCert;
            }
        });
        this.caSystemCertsCache = new Vector(caCertsSet);
        caTraceLogger.trace("System certs size = " + this.caSystemCertsCache.size());
        caTraceLogger.logExit(!this.caSystemCertsCache.isEmpty());
        return this.caSystemCertsCache;
    }

    private synchronized void writeLocal2Disk() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        KeyStoreManager ksm = KeyStoreManager.getInstance();
        CAMKeyStore store = ksm.getCAKeystore("ca");
        store.lock();
        store.loadKeyStore();
        try {
            Enumeration<X509Certificate> e = this.caCacheCerts.elements();
            while (e.hasMoreElements()) {
                X509Certificate o = e.nextElement();
                if (o == null || !(o instanceof Certificate)) continue;
                store.addTrustedCert(o);
            }
            store.saveKeyStore();
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_save_keystore_error", new String[]{config.getCAMKeystoreLocation()}));
            caTraceLogger.logExit(cce);
            throw cce;
        }
        finally {
            store.unlock();
        }
        caTraceLogger.logExit(true);
    }

    private void pushLocalKeyStoreToCS() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        if (config.getUsingThirdPartyCA()) {
            return;
        }
        if (!this.didWeUploadOurTrustStoreToCM) {
            boolean ok = false;
            try {
                X509Certificate cert;
                Certificate[] certArray = KeyStoreReader.getAllCertificates();
                for (int i = 0; i < certArray.length && (!CAMCryptoUtilities.isCertAllowedInCS(cert = (X509Certificate)certArray[i], caTraceLogger) || (ok = this.addCertToCS(cert))); ++i) {
                }
            }
            catch (CAMCryptoException cce) {
                CAMCryptoException cce1 = new CAMCryptoException(cce, MessageSet.getMessage("CAM_CRP_cacert_upload_error"));
                caTraceLogger.logExit(cce1);
                throw cce1;
            }
            this.didWeUploadOurTrustStoreToCM = ok;
        }
        caTraceLogger.logExit(true);
    }
}

