/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.security.Provider;
import java.security.Security;

public class CryptoProviderManager {
    private static CryptoProviderManager _instance = new CryptoProviderManager();

    private CryptoProviderManager() {
        try {
            String PROTOCOL_PACKAGES = "java.protocol.handler.pkgs";
            String PROTOCOL_HANDLER = JVMEnvironment.getInstance().getHttpsProtocolHandler();
            String packages = System.getProperty("java.protocol.handler.pkgs");
            if (packages == null) {
                packages = PROTOCOL_HANDLER;
                System.setProperty("java.protocol.handler.pkgs", packages);
            } else if (packages.indexOf(PROTOCOL_HANDLER) == -1) {
                packages = packages + "|" + PROTOCOL_HANDLER;
                System.setProperty("java.protocol.handler.pkgs", packages);
            }
        }
        catch (CAMCryptoException cAMCryptoException) {
            // empty catch block
        }
    }

    public static CryptoProviderManager getInstance() {
        return _instance;
    }

    public synchronized void loadJavaSecurityProvider() throws CAMCryptoException {
        try {
            JVMEnvironment.getInstance().addJCESecurityProvider();
            Provider bc = Security.getProvider("BC");
            if (bc == null) {
                Class<?> bcClass = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                Provider p = (Provider)bcClass.newInstance();
                Security.addProvider(p);
            } else {
                double version = bc.getVersion();
                if (version != 1.59) {
                    Security.removeProvider("BC");
                    Class<?> bcClass = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                    Provider p = (Provider)bcClass.newInstance();
                    Security.addProvider(p);
                }
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_provider_check_error"));
        }
    }

    public synchronized void configureSecurityProviders() throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        try {
            JVMEnvironment.getInstance().addJSSESecurityProvider();
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_provider_check_error"));
        }
    }
}

