/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.internal.ontology.api.function;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.logging.PerformanceLogger;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.KnowledgeDiscoveryClientFactory;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.pipeline.internal.Task;
import com.ibm.smarts.pipeline.progress.TaskStatus;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.store.api.provider.IInMemoryModuleStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassifyColumnsTaskImpl
extends Task<SmartsTaskContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassifyColumnsTaskImpl.class);
    public static final String ATTR_CLASSIFY_SCOPE = "classifyScope";

    public TaskStatus execute(SmartsTaskContext context) {
        SmartsModule classifiedSm;
        KnowledgeDiscoveryClientFactory clientFactory;
        String moduleId = context.getSmartsModuleId();
        String datasetId = context.getDatasetId();
        PerformanceLogger.get().info((Object)(moduleId + "." + datasetId));
        RequestContext rc = context.getRequestContext();
        IStoreProvider storeProvider = context.getStoreProvider();
        SmartsModule storedSm = this.getModuleStore(storeProvider, rc).getSmartsModulePart(moduleId, datasetId);
        if (storedSm == null) {
            throw new InternalException("Smarts module '" + moduleId + "' not found in store", new Object[0]);
        }
        if (storedSm.getDatasets().isEmpty()) {
            throw new InternalException("Dataset '" + datasetId + "' not found in smarts module '" + moduleId + "'", new Object[0]);
        }
        DatasetInfo storedDs = (DatasetInfo)storedSm.getDatasets().get(0);
        List columns = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)storedDs);
        if (columns.stream().allMatch(c -> c.getSamples().isEmpty())) {
            LOGGER.info("no samples - smarts.ontology.classifyColumnConcepts for " + context.getSmartsModuleId() + ", " + context.getDatasetId());
        }
        try {
            clientFactory = KnowledgeDiscoveryClientFactory.getInstance();
        }
        catch (IllegalStateException ex) {
            throw new InternalException(ex.getMessage(), new Object[0]);
        }
        DeltaAnalysisScope classifyScope = context.getDeltaAnalysisScope(DeltaAnalysisScope.ScopedTask.CLASSIFY);
        if (classifyScope != null) {
            rc.setAttribute(ATTR_CLASSIFY_SCOPE, (Object)classifyScope);
        }
        if ((classifiedSm = clientFactory.getOntologyClient().classify(rc, storedSm)) == null) {
            throw new InternalException("Dataset '" + datasetId + "' in smarts module '" + moduleId + "' failed classification", new Object[0]);
        }
        DatasetInfo classifiedDs = (DatasetInfo)classifiedSm.getDatasets().get(0);
        ClassifyColumnsTaskImpl.setGroupingColumnInfo(context, classifiedDs);
        if (classifyScope != null) {
            rc.removeAttribute(ATTR_CLASSIFY_SCOPE);
        }
        PerformanceLogger.get().info((Object)(moduleId + "." + datasetId));
        return null;
    }

    private IInMemoryModuleStore getModuleStore(IStoreProvider storeProvider, RequestContext rc) {
        return storeProvider.getModuleStore(rc);
    }

    private static void setGroupingColumnInfo(SmartsTaskContext context, DatasetInfo datasetInfo) {
        List groupingColumns = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)datasetInfo).stream().map(c -> {
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.setId(c.getId());
            columnInfo.setIdForExpression(c.getIdForExpression());
            SemanticInfo si = new SemanticInfo();
            si.getConcepts().addAll(c.getSemanticInfo().getConcepts().stream().filter(con -> ConceptsUtil.getOntologyId((ConceptInfo)con).equals("http://www.ibm.com/ontologies/waca/domain/common")).collect(Collectors.toList()));
            columnInfo.setSemanticInfo(si);
            return columnInfo;
        }).collect(Collectors.toList());
        if (!groupingColumns.isEmpty()) {
            context.setProperty("globalGroupingColumnInfo", groupingColumns);
        }
    }
}

