/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.builder;

import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityEnum;
import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.smarts.modelling.util.ModuleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class BusinessModuleBuilder {
    public Module buildBusinessModule(String identifier, List<QuerySubject> targetQuerySubjects, Module baseModule, boolean includeQuerySubjects) {
        ObjectFactory factory = new ObjectFactory();
        Module outputModule = factory.createModule();
        outputModule.setIdentifier(identifier);
        outputModule.setLabel(identifier);
        BusinessModuleBuilder.addUses(outputModule, baseModule.getContainer(), baseModule.getIdentifier());
        if (baseModule.getExpressionLocale() == null || "".equals(baseModule.getExpressionLocale())) {
            outputModule.setExpressionLocale("en-us");
        } else {
            outputModule.setExpressionLocale(baseModule.getExpressionLocale());
        }
        if (includeQuerySubjects) {
            HashSet<String> tableNames = new HashSet<String>();
            HashMap<String, List<Relationship>> nameToRelationShip = new HashMap<String, List<Relationship>>();
            for (QuerySubject factTable : targetQuerySubjects) {
                String tableID = factTable.getIdentifier();
                tableNames.add(tableID);
                nameToRelationShip.put(tableID, new ArrayList());
            }
            Map<String, QuerySubject> lookupDictionary = ModuleUtil.createIDToQuerySubjectDictionary(baseModule);
            BusinessModuleBuilder.populateDictionary(baseModule, nameToRelationShip, lookupDictionary);
            for (QuerySubject factTable : targetQuerySubjects) {
                QuerySubject factTableClone = BusinessModuleBuilder.cloneQSAndAdjustExpression(factTable);
                outputModule.getQuerySubject().add(factTableClone);
                for (Relationship relationship : (List)nameToRelationShip.get(factTable.getIdentifier())) {
                    BusinessModuleBuilder.processRelationship(outputModule, relationship, tableNames, lookupDictionary);
                }
            }
        }
        return outputModule;
    }

    public static void addUses(Module module, String moduleContainer, String moduleId) {
        module.getUse().add((moduleContainer == null ? "" : moduleContainer + ".") + moduleId);
    }

    private static void populateDictionary(Module baseModule, Map<String, List<Relationship>> nameToRelationShip, Map<String, QuerySubject> lookupDictionary) {
        baseModule.basicGetRelationship().stream().forEach(relationship -> Stream.of(relationship.getLeft().getRef(), relationship.getRight().getRef()).forEach(refName -> BusinessModuleBuilder.addRelationship(relationship, refName, nameToRelationShip, lookupDictionary)));
    }

    private static void addRelationship(Relationship relationship, String refName, Map<String, List<Relationship>> nameToRelationShip, Map<String, QuerySubject> lookupDictionary) {
        if (nameToRelationShip.keySet().contains(refName)) {
            QuerySubject oppositeTable;
            CardinalityType currentSide = null;
            CardinalityType oppositeSide = null;
            if (relationship.getLeft().getRef().equals(refName)) {
                currentSide = relationship.getLeft();
                oppositeSide = relationship.getRight();
            } else if (relationship.getRight().getRef().equals(refName)) {
                currentSide = relationship.getRight();
                oppositeSide = relationship.getLeft();
            }
            List<Relationship> ralationShipsOfInterest = nameToRelationShip.get(refName);
            if ((currentSide.getMaxcard() == CardinalityEnum.MANY || currentSide.getMaxcard() == CardinalityEnum.ONE && oppositeSide.getMaxcard() == CardinalityEnum.ONE) && (oppositeTable = lookupDictionary.get(oppositeSide.getRef())) != null) {
                ralationShipsOfInterest.add(relationship);
            }
        }
    }

    private static QuerySubject cloneQSAndAdjustExpression(QuerySubject toClone) {
        QuerySubject qs = ModuleUtil.cloneQuerySubject(toClone);
        for (ItemType item : qs.getItem()) {
            QueryItem qi = item.getQueryItem();
            if (qi == null) continue;
            qi.setExpression(qi.getIdentifier());
        }
        return qs;
    }

    private static void processRelationship(Module module, Relationship relationship, Set<String> tableNames, Map<String, QuerySubject> lookupDictionary) {
        Relationship cloneRelationship = ModuleUtil.cloneRelationship(relationship);
        module.getRelationship().add(cloneRelationship);
        Stream.of(relationship.getLeft().getRef(), relationship.getRight().getRef()).forEach(refName -> {
            if (!tableNames.contains(refName)) {
                QuerySubject qs = (QuerySubject)lookupDictionary.get(refName);
                qs = BusinessModuleBuilder.cloneQSAndAdjustExpression(qs);
                module.getQuerySubject().add(qs);
                tableNames.add((String)refName);
            }
        });
    }
}

