/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.designer;

import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.MatchedFeature;
import com.ibm.smarts.schema.TextInfo;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MatchedDataset {
    private String id;
    private Float score;
    private List<MatchedFeature> matchedFeatures;
    private String coveredText;
    private List<TextInfo> textInfo;
    private Set<String> tokens = Collections.emptySet();
    private DatasetInfo dataset;

    public MatchedDataset(String id) {
        this.id = id;
    }

    public MatchedDataset(String id, DatasetInfo dataset) {
        this.id = id;
        this.dataset = dataset;
    }

    public MatchedDataset(String id, Float score, String coveredText, List<TextInfo> textInfo, List<MatchedFeature> matchedFeatures) {
        this.id = id;
        this.score = score;
        this.coveredText = coveredText;
        this.matchedFeatures = matchedFeatures;
        this.textInfo = textInfo;
        this.tokens = textInfo.stream().flatMap(t -> t.getPhrases().stream()).flatMap(p -> p.getTokens().stream()).map(tkn -> tkn.getLemma()).collect(Collectors.toSet());
    }

    public String getId() {
        return this.id;
    }

    public Float getScore() {
        return this.score;
    }

    public List<MatchedFeature> getMatchedFeatures() {
        return this.matchedFeatures;
    }

    public List<TextInfo> getTextInfo() {
        return this.textInfo;
    }

    public DatasetInfo getDataset() {
        return this.dataset;
    }

    public void setDataset(DatasetInfo dataset) {
        this.dataset = dataset;
    }

    public Set<String> getTokens() {
        return this.tokens;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MatchedDataset) {
            return this.id.equals(((MatchedDataset)obj).getId());
        }
        return false;
    }
}

