/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.designer;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.modelling.designer.MatchedDataset;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.schema.FeatureType;
import com.ibm.smarts.schema.MatchReason;
import com.ibm.smarts.schema.MatchedEntity;
import com.ibm.smarts.schema.MatchedFeature;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchedEntityPkg {
    private final Logger LOGGER = LoggerFactory.getLogger(MatchedEntityPkg.class);
    private MatchedEntity matchedEntity;
    private List<MatchedDataset> groups;

    public MatchedEntityPkg(List<MatchedEntity> matchedEntities, RequestContext ctx, SmartNLP nlp) {
        this.matchedEntity = matchedEntities.get(0);
        for (int i = 1; i < matchedEntities.size(); ++i) {
            this.matchedEntity.getMatchedFeatures().addAll(matchedEntities.get(i).getMatchedFeatures());
        }
        this.groups = this.groupByQuerySubject(this.matchedEntity, ctx, nlp);
    }

    private List<MatchedDataset> groupByQuerySubject(MatchedEntity matchedEntity, RequestContext ctx, SmartNLP nlp) {
        return matchedEntity.getMatchedFeatures().stream().filter(f -> f.getFeature().getDatasetRef() != null).collect(Collectors.groupingBy(f -> f.getFeature().getDatasetRef())).entrySet().stream().map(e -> {
            List textInfos = Collections.emptyList();
            try {
                textInfos = nlp.describeText(ctx, new String[]{matchedEntity.getCoveredText()});
            }
            catch (Exception ex) {
                this.LOGGER.error(String.format("nlp could not understand the text {%s} :-( ", matchedEntity.getCoveredText()));
            }
            return new MatchedDataset((String)e.getKey(), this.aggregateFeatureScore((List)e.getValue()), matchedEntity.getCoveredText(), textInfos, (List)e.getValue());
        }).sorted(Comparator.comparing(MatchedDataset::getScore).reversed()).collect(Collectors.toList());
    }

    private Float aggregateFeatureScore(List<MatchedFeature> features) {
        Float score = Float.valueOf(0.0f);
        Map<FeatureType, List<MatchedFeature>> byType = features.stream().collect(Collectors.groupingBy(MatchedFeature::getFeatureType));
        List dsFeature = byType.getOrDefault(FeatureType.DATASET_NAME, Collections.emptyList());
        if (!dsFeature.isEmpty()) {
            score = ((MatchedFeature)dsFeature.get(0)).getMatchReason().equals((Object)MatchReason.FULL) ? Float.valueOf(score.floatValue() + 50.0f * (1.0f + ((MatchedFeature)dsFeature.get(0)).getConfidence())) : (((MatchedFeature)dsFeature.get(0)).getMatchReason().equals((Object)MatchReason.PARTIAL_NAME) || ((MatchedFeature)dsFeature.get(0)).getMatchReason().equals((Object)MatchReason.PARTIAL_LEMMA) ? Float.valueOf(score.floatValue() + 20.0f * (1.0f + ((MatchedFeature)dsFeature.get(0)).getConfidence())) : Float.valueOf(score.floatValue() + (1.0f + ((MatchedFeature)dsFeature.get(0)).getConfidence())));
        }
        Map<String, Map<MatchReason, Long>> featureMatchReasons = byType.getOrDefault(FeatureType.COLUMN_NAME, Collections.emptyList()).stream().collect(Collectors.groupingBy(f -> f.getFeature().getColumnInfoRef(), Collectors.groupingBy(MatchedFeature::getMatchReason, Collectors.counting())));
        HashMap featureScores = new HashMap();
        featureMatchReasons.forEach((k, v) -> {
            Long s = 0L;
            for (MatchReason k1 : v.keySet()) {
                Long v1 = (Long)v.get(k1);
                if (k1.equals((Object)MatchReason.FULL)) {
                    s = s + 10L * v1;
                    continue;
                }
                if (k1.equals((Object)MatchReason.PARTIAL_NAME)) {
                    s = s + 3L * v1;
                    continue;
                }
                if (k1.equals((Object)MatchReason.PARTIAL_LEMMA)) {
                    s = s + 2L * v1;
                    continue;
                }
                if (!k1.equals((Object)MatchReason.PARTIAL_CONCEPT)) continue;
                s = s + v1;
            }
            featureScores.put(k, s);
        });
        List scoreList = featureScores.values().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        for (int i = 0; i < scoreList.size(); ++i) {
            score = i > 2 ? Float.valueOf(score.floatValue() + (float)((Long)scoreList.get(i) / (long)i)) : Float.valueOf(score.floatValue() + (float)((Long)scoreList.get(i)).longValue());
        }
        if (scoreList.size() > 10) {
            score = Float.valueOf(score.floatValue() * (10.0f / (float)scoreList.size()));
        }
        return score;
    }

    public MatchedEntity getMatchedEntity() {
        return this.matchedEntity;
    }

    public List<MatchedDataset> getGroups() {
        return this.groups;
    }
}

