/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.designer.join;

import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityEnum;
import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertyType;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.modelling.designer.MatchedDataset;
import com.ibm.smarts.modelling.designer.join.rules.RestrictCardinality;
import com.ibm.smarts.modelling.designer.join.rules.RestrictDataItemName;
import com.ibm.smarts.modelling.designer.join.rules.RestrictDataItemValuesOverlapping;
import com.ibm.smarts.modelling.designer.join.rules.ScoringDriver;
import com.ibm.smarts.modelling.util.ModuleUtil;
import com.ibm.smarts.modelling.util.TempUtil;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BaseObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.FeatureType;
import com.ibm.smarts.schema.ItemType;
import com.ibm.smarts.schema.MatchReason;
import com.ibm.smarts.schema.MatchedFeature;
import com.ibm.smarts.schema.SemanticSearchResult;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.UsageType;
import com.ibm.smarts.schema.util.JAXBHelper;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.store.api.TypeNames;
import com.ibm.smarts.store.api.config.StoreConfig;
import com.ibm.smarts.store.api.provider.IFeatureStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.IRecordResult;
import com.ibm.smarts.store.api.query.IStoreQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinPathAdvisor {
    public static final String SYSTEM_DISCOVERED = "SystemDiscovered";
    public static final double MIN_JOIN_SCORE = 0.55;
    private static final double MINIMUM_DIFF_REQUIREMENT = 0.6;
    private final double mMinJoinScore;
    private final ScoringDriver scoringDriver = new ScoringDriver();
    private final IStoreProvider moduleStore;
    private final RequestContext requestContext;
    private final String moduleStoreID;
    private final SmartsModule smartsModule;
    private final Map<String, List<MatchedDataset>> matchedDatasetCache;
    private static final Logger LOGGER = LoggerFactory.getLogger(JoinPathAdvisor.class);

    public JoinPathAdvisor(RequestContext requestContext, double minJoinScore, IStoreProvider storeProvider, String moduleID) {
        this(requestContext, minJoinScore, new HashMap<String, List<MatchedDataset>>(), storeProvider, moduleID);
    }

    public JoinPathAdvisor(RequestContext requestContext, double minJoinScore, Map<String, List<MatchedDataset>> matchedDatasetCache, IStoreProvider storeProvider, String moduleID) {
        this.requestContext = requestContext;
        this.mMinJoinScore = minJoinScore;
        this.moduleStore = storeProvider;
        this.moduleStoreID = moduleID;
        this.smartsModule = this.getSmartsModuleFromStore(this.moduleStoreID);
        this.matchedDatasetCache = matchedDatasetCache;
    }

    public boolean addJoinsToModuleIfDiscovered(Module module, Set<MatchedDataset> aCandidateGroup, SemanticSearchResult intentMatchingCandidates) {
        boolean bJoinAdded = false;
        List candidates = aCandidateGroup.stream().sorted(Comparator.comparing(MatchedDataset::getScore).reversed()).collect(Collectors.toList());
        for (int i = 0; i < candidates.size(); ++i) {
            MatchedDataset targetI = (MatchedDataset)candidates.get(i);
            String querySubjectI = targetI.getId();
            DatasetInfo targetDatasetI = this.getDatasetInfo(querySubjectI, this.smartsModule);
            if (targetDatasetI == null) continue;
            targetI.setDataset(targetDatasetI);
            List relatedDatasetsI = this.matchedDatasetCache.computeIfAbsent(targetI.getId(), k -> this.collectJoinCandidate(targetI, this.moduleStoreID));
            if (aCandidateGroup.size() == 1) {
                bJoinAdded = this.addJoinsToModuleIfDiscovered(module, targetI, relatedDatasetsI, intentMatchingCandidates);
                continue;
            }
            for (int j = i + 1; j < candidates.size(); ++j) {
                List<Relationship> discoveredRelationships;
                MatchedDataset targetJ = (MatchedDataset)candidates.get(j);
                String querySubjectJ = targetJ.getId();
                DatasetInfo targetDatasetJ = this.getDatasetInfo(querySubjectJ, this.smartsModule);
                if (targetDatasetJ == null) continue;
                targetJ.setDataset(targetDatasetJ);
                if (!JoinPathAdvisor.isJoinedDirectly(targetI.getDataset(), targetJ.getDataset(), ModuleUtil.getJoinGraphMap(module)) && !(discoveredRelationships = this.suggestJoins(targetI.getDataset(), targetJ.getDataset())).isEmpty()) {
                    bJoinAdded = module.getRelationship().addAll(discoveredRelationships) || bJoinAdded;
                }
                List relatedDatasetsJ = this.matchedDatasetCache.computeIfAbsent(targetJ.getId(), k -> this.collectJoinCandidate(targetJ, this.moduleStoreID));
                Map<String, List<MatchedDataset>> groupsByMembership = JoinPathAdvisor.groupJoinCandidatesByMembership((Pair<String, List<MatchedDataset>>)new ImmutablePair((Object)targetI.getId(), (Object)relatedDatasetsI), (Pair<String, List<MatchedDataset>>)new ImmutablePair((Object)targetJ.getId(), (Object)relatedDatasetsJ));
                bJoinAdded = this.addJoinsToModuleIfDiscovered(module, targetI, targetJ, groupsByMembership, "", intentMatchingCandidates) || bJoinAdded;
                bJoinAdded = this.addJoinsToModuleIfDiscovered(module, targetI, targetJ, groupsByMembership, targetI.getId(), intentMatchingCandidates) || bJoinAdded;
                bJoinAdded = this.addJoinsToModuleIfDiscovered(module, targetI, targetJ, groupsByMembership, targetJ.getId(), intentMatchingCandidates) || bJoinAdded;
            }
        }
        return bJoinAdded;
    }

    private boolean addJoinsToModuleIfDiscovered(Module module, MatchedDataset joinTargetA, MatchedDataset joinTargetB, Map<String, List<MatchedDataset>> groupsByMembership, String groupKey, SemanticSearchResult intentMatchingCandidates) {
        boolean bJoinAdded = false;
        Map<String, Set<String>> joinGraph = ModuleUtil.getJoinGraphMap(module);
        boolean bFoundJoinPath = JoinPathAdvisor.hasOneToNJoinPath(joinTargetA.getDataset(), joinTargetB.getDataset(), module, joinGraph);
        boolean isCommonCandidateGroup = groupKey.isEmpty();
        boolean isTargetAGroup = isCommonCandidateGroup || groupKey.equals(joinTargetA.getDataset().getId());
        boolean isTargetBGroup = isCommonCandidateGroup || groupKey.equals(joinTargetB.getDataset().getId());
        List<MatchedDataset> joinCandidates = groupsByMembership.get(groupKey);
        MatchedDataset joinTarget = groupKey.equals(joinTargetA.getId()) ? joinTargetA : joinTargetB;
        List sortedJoinCandidates = joinCandidates.stream().sorted(Comparator.comparingInt(a -> JoinPathAdvisor.getRelevanceScore(joinTarget, a))).collect(Collectors.toList());
        for (MatchedDataset joinCandidate : sortedJoinCandidates) {
            ArrayList<Relationship> discoveredRelationships = new ArrayList<Relationship>();
            if (isCommonCandidateGroup && !bFoundJoinPath) {
                boolean bFoundPotentialJoinPath = true;
                if (!JoinPathAdvisor.isJoinedDirectly(joinCandidate.getDataset(), joinTargetA.getDataset(), joinGraph)) {
                    boolean bl = bFoundPotentialJoinPath = bFoundPotentialJoinPath && discoveredRelationships.addAll(this.suggestJoins(joinCandidate.getDataset(), joinTargetA.getDataset()));
                }
                if (!JoinPathAdvisor.isJoinedDirectly(joinCandidate.getDataset(), joinTargetB.getDataset(), joinGraph)) {
                    boolean bl = bFoundPotentialJoinPath = bFoundPotentialJoinPath && discoveredRelationships.addAll(this.suggestJoins(joinCandidate.getDataset(), joinTargetB.getDataset()));
                }
                if (bFoundPotentialJoinPath) {
                    bJoinAdded = module.getRelationship().addAll(discoveredRelationships) || bJoinAdded;
                    discoveredRelationships.clear();
                    joinGraph = ModuleUtil.getJoinGraphMap(module);
                    bFoundJoinPath = JoinPathAdvisor.hasOneToNJoinPath(joinTargetA.getDataset(), joinTargetB.getDataset(), module, joinGraph);
                }
            } else {
                if (isTargetAGroup && !JoinPathAdvisor.isJoinedDirectly(joinCandidate.getDataset(), joinTargetA.getDataset(), joinGraph) && this.isOrthogonal(joinCandidate, joinTargetA)) {
                    discoveredRelationships.addAll(this.suggestJoins(joinCandidate.getDataset(), joinTargetA.getDataset()));
                }
                if (isTargetBGroup && !JoinPathAdvisor.isJoinedDirectly(joinCandidate.getDataset(), joinTargetB.getDataset(), joinGraph) && this.isOrthogonal(joinCandidate, joinTargetB)) {
                    discoveredRelationships.addAll(this.suggestJoins(joinCandidate.getDataset(), joinTargetB.getDataset()));
                }
            }
            bJoinAdded = module.getRelationship().addAll(discoveredRelationships) || bJoinAdded;
        }
        return bJoinAdded;
    }

    private DatasetInfo getDatasetInfoFromStore(String qsID, String moduleStoreID) {
        SmartsModule smartsModule = this.getSmartsModuleFromStore(moduleStoreID);
        return this.getDatasetInfo(qsID, smartsModule);
    }

    private SmartsModule getSmartsModuleFromStore(String moduleStoreID) {
        StoreConfig config = new StoreConfig(this.requestContext.locale, TypeNames.DDS);
        IRecord record = this.moduleStore.getPersistenceProvider(config).get(this.requestContext, moduleStoreID, Collections.emptyList(), SmartsModuleOptions.DEFAULT_GET_PATTERN);
        return record != null ? (SmartsModule)record.getRecord() : null;
    }

    private DatasetInfo getDatasetInfo(String qsID, SmartsModule smartsModule) {
        return smartsModule.getDatasets().stream().filter(d -> d.getId().equals(qsID)).findFirst().orElse(null);
    }

    private List<MatchedDataset> collectJoinCandidate(MatchedDataset target, String moduleStoreID) {
        CharSequence[] searchQuery = (String[])SmartsModuleUtil.getFlattenedColumns((BaseItemObject)target.getDataset()).stream().filter(c -> c.getUsage().equals((Object)UsageType.IDENTIFIER)).map(BaseObject::getId).filter(RestrictDataItemName::isValidDataItemName).toArray(String[]::new);
        if (searchQuery.length == 0) {
            return Collections.emptyList();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Target: \t" + String.join((CharSequence)", ", target.getId()));
            LOGGER.debug("SearchQuery: \t" + String.join((CharSequence)", ", searchQuery));
        }
        IFeatureStore featureStore = this.moduleStore.getFeatureStore(this.requestContext);
        IStoreQuery sq = featureStore.getQueryBuilder().addFilter("assetRef", new String[]{moduleStoreID}).addFilter("columnInfoRef", (String[])searchQuery).build();
        List searchResult = featureStore.executeSearch(sq);
        return this.groupFeatureSearchResult(searchResult, target.getId());
    }

    private List<MatchedDataset> groupFeatureSearchResult(List<IRecordResult<Feature>> searchResult, String exclude) {
        Map<String, List<Feature>> m = searchResult.stream().filter(f -> !((Feature)f.getRecord().getRecord()).getDatasetRef().equals(exclude)).map(e -> (Feature)e.getRecord().getRecord()).collect(Collectors.groupingBy(Feature::getDatasetRef));
        return m.entrySet().stream().map(e -> {
            DatasetInfo dataset = new DatasetInfo();
            dataset.setId((String)e.getKey());
            List columns = ((List)e.getValue()).stream().map(Feature::getColumnInfo).map(c -> {
                try {
                    return (ColumnInfo)JAXBHelper.unmarshalFromJSON(ColumnInfo.class, (String)c);
                }
                catch (IOException e1) {
                    return null;
                }
            }).collect(Collectors.toList());
            List items = columns.stream().map(c -> {
                ItemType item = new ItemType();
                item.setColumn(c);
                return item;
            }).collect(Collectors.toList());
            dataset.getItem().addAll(items);
            return dataset;
        }).map(d -> new MatchedDataset(d.getId(), (DatasetInfo)d)).collect(Collectors.toList());
    }

    private boolean addJoinsToModuleIfDiscovered(Module module, MatchedDataset joinTarget, List<MatchedDataset> joinCandidates, SemanticSearchResult intentMatchingCandidates) {
        boolean bJoinAdded = false;
        Map<String, Set<String>> joinGraph = ModuleUtil.getJoinGraphMap(module);
        List sortedJoinCandidates = joinCandidates.stream().sorted(Comparator.comparingInt(a -> JoinPathAdvisor.getRelevanceScore(joinTarget, a))).collect(Collectors.toList());
        for (MatchedDataset joinCandidate : sortedJoinCandidates) {
            ArrayList<Relationship> discoveredRelationships = new ArrayList<Relationship>();
            if (!JoinPathAdvisor.isJoinedDirectly(joinCandidate.getDataset(), joinTarget.getDataset(), joinGraph) && this.isOrthogonal(joinCandidate, joinTarget)) {
                discoveredRelationships.addAll(this.suggestJoins(joinCandidate.getDataset(), joinTarget.getDataset()));
            }
            bJoinAdded = module.getRelationship().addAll(discoveredRelationships) || bJoinAdded;
        }
        return bJoinAdded;
    }

    public List<Relationship> suggestJoinsQS(List<String> querySubjects) {
        if (querySubjects.size() < 2) {
            return Collections.emptyList();
        }
        ArrayList<DatasetInfo> joinCandidates = new ArrayList<DatasetInfo>();
        for (String qs : querySubjects) {
            DatasetInfo ds = this.getDatasetInfo(qs, this.smartsModule);
            if (ds == null) {
                LOGGER.info("Can not find DatasetInfo of " + qs + " in SmartsModule of " + this.moduleStoreID);
                continue;
            }
            joinCandidates.add(ds);
        }
        if (joinCandidates.size() < 2) {
            return Collections.emptyList();
        }
        return this.suggestJoins(joinCandidates);
    }

    public List<Relationship> suggestJoins(List<DatasetInfo> joinCandidates) {
        ArrayList<Relationship> joins = new ArrayList<Relationship>();
        for (int i = 0; i < joinCandidates.size(); ++i) {
            DatasetInfo analyticsI = joinCandidates.get(i);
            for (int j = i + 1; j < joinCandidates.size(); ++j) {
                DatasetInfo analyticsJ = joinCandidates.get(j);
                joins.addAll(this.suggestJoins(analyticsI, analyticsJ));
            }
        }
        return joins;
    }

    private List<Relationship> suggestJoins(DatasetInfo qLeft, DatasetInfo qRight) {
        ArrayList<Relationship> joins = new ArrayList<Relationship>();
        ArrayList<Triple<Double, ColumnInfo, ColumnInfo>> links = new ArrayList<Triple<Double, ColumnInfo, ColumnInfo>>();
        ArrayList<Pair<String, Double>> details = new ArrayList<Pair<String, Double>>();
        LOGGER.trace("Start to suggest join between query subject '{}' and query subject '{}'.", new Object[]{qLeft.getId(), qRight.getId()});
        List leftColumns = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)qLeft);
        List rightColumns = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)qRight);
        for (ColumnInfo qi1 : leftColumns) {
            if (qi1.getUsage() == null || qi1.getUsage().equals((Object)UsageType.FACT)) continue;
            for (ColumnInfo qi2 : rightColumns) {
                if (qi2.getUsage() == null || qi2.getUsage().equals((Object)UsageType.FACT)) continue;
                LOGGER.trace("Start to evaluate join between query item '{}' and query item '{}'", new Object[]{qi1.getId(), qi2.getId()});
                details.clear();
                double score = this.scoringDriver.score(qi1, qi2, details);
                if (score >= this.mMinJoinScore) {
                    ImmutableTriple link = new ImmutableTriple((Object)score, (Object)qi1, (Object)qi2);
                    links.add((Triple<Double, ColumnInfo, ColumnInfo>)link);
                }
                if (LOGGER.isTraceEnabled()) {
                    StringBuilder builder = new StringBuilder();
                    details.stream().forEach(p -> builder.append(p.toString()));
                    LOGGER.trace(builder.toString());
                }
                LOGGER.trace("Finished evaluating join between query item '{}' and query item '{}', with total score {}.", new Object[]{qi1.getId(), qi2.getId(), score});
            }
        }
        List<Triple<Double, ColumnInfo, ColumnInfo>> validLinks = this.filterByDataAttribute(links, details);
        if (!validLinks.isEmpty()) {
            List<Triple<Double, ColumnInfo, ColumnInfo>> effectiveLinks = Collections.singletonList(validLinks.stream().max(Comparator.comparing(Triple::getLeft)).get());
            joins.addAll(JoinPathAdvisor.buildRelationship(qLeft.getId(), qRight.getId(), effectiveLinks));
            if (LOGGER.isTraceEnabled()) {
                StringBuilder builder = new StringBuilder();
                joins.stream().forEach(r -> builder.append(ModuleUtil.relationshipToString(r)).append("\n"));
                LOGGER.trace("Created joins: '{}'.", (Object)builder.toString());
            }
        } else {
            LOGGER.trace("No joins are created between query subject '{}' and query subject '{}'.", new Object[]{qLeft.getId(), qRight.getId()});
        }
        LOGGER.trace("Finished suggesting join between query subject '{}' and query subject '{}'.", new Object[]{qLeft.getId(), qRight.getId()});
        return joins;
    }

    private List<Triple<Double, ColumnInfo, ColumnInfo>> filterByDataAttribute(List<Triple<Double, ColumnInfo, ColumnInfo>> links, List<Pair<String, Double>> details) {
        if (links.isEmpty()) {
            return Collections.emptyList();
        }
        ScoringDriver driver = new ScoringDriver(new RestrictCardinality(), new RestrictDataItemValuesOverlapping());
        return links.stream().filter(p -> Double.compare(driver.score((ColumnInfo)p.getMiddle(), (ColumnInfo)p.getRight(), details), 0.0) > 0).collect(Collectors.toList());
    }

    private static boolean isJoinedDirectly(DatasetInfo a, DatasetInfo b, Map<String, Set<String>> joinGraph) {
        String aId = a.getId();
        String bId = b.getId();
        boolean aToB = joinGraph.containsKey(aId) ? joinGraph.get(aId).contains(bId) : false;
        boolean bToA = joinGraph.containsKey(bId) ? joinGraph.get(bId).contains(aId) : false;
        return aToB || bToA;
    }

    private static Map<String, List<MatchedDataset>> groupJoinCandidatesByMembership(Pair<String, List<MatchedDataset>> aCandidates, Pair<String, List<MatchedDataset>> bCandidates) {
        HashMap<String, List<MatchedDataset>> groups = new HashMap<String, List<MatchedDataset>>();
        groups.put("", new ArrayList());
        groups.put((String)aCandidates.getLeft(), new ArrayList());
        groups.put((String)bCandidates.getLeft(), new ArrayList());
        Set aCandidateNames = ((List)aCandidates.getRight()).stream().map(m -> m.getDataset().getId()).collect(Collectors.toSet());
        Set bCandidateNames = ((List)bCandidates.getRight()).stream().map(m -> m.getDataset().getId()).collect(Collectors.toSet());
        ((List)aCandidates.getRight()).stream().forEach(a -> {
            if (bCandidateNames.contains(a.getId())) {
                Set names = ((List)groups.get("")).stream().map(m -> m.getDataset().getId()).collect(Collectors.toSet());
                if (!names.contains(a.getId())) {
                    ((List)groups.get("")).add(JoinPathAdvisor.mergeDatasetInfo(a, bCandidates));
                }
            } else {
                ((List)groups.get(aCandidates.getLeft())).add(a);
            }
        });
        ((List)bCandidates.getRight()).stream().forEach(b -> {
            if (aCandidateNames.contains(b.getId())) {
                Set names = ((List)groups.get("")).stream().map(m -> m.getDataset().getId()).collect(Collectors.toSet());
                if (!names.contains(b.getId())) {
                    ((List)groups.get("")).add(JoinPathAdvisor.mergeDatasetInfo(b, aCandidates));
                }
            } else {
                ((List)groups.get(bCandidates.getLeft())).add(b);
            }
        });
        return groups;
    }

    private static List<Relationship> buildRelationship(String leftQS, String rightQS, List<Triple<Double, ColumnInfo, ColumnInfo>> links) {
        ObjectFactory factory = new ObjectFactory();
        boolean leftIsPK = false;
        boolean rightIsPK = false;
        Relationship relation = factory.createRelationship();
        ModuleUtil.setRelationshipIDandLabel(relation, leftQS, rightQS);
        for (Triple<Double, ColumnInfo, ColumnInfo> alink : links) {
            ColumnInfo leftFeature = (ColumnInfo)alink.getMiddle();
            ColumnInfo rightFeature = (ColumnInfo)alink.getRight();
            if (TempUtil.isPKFeature(leftFeature)) {
                leftIsPK = true;
            }
            if (TempUtil.isPKFeature(rightFeature)) {
                rightIsPK = true;
            }
            Relationship.Link link = factory.createRelationshipLink();
            link.setLeftRef(((ColumnInfo)alink.getMiddle()).getId());
            link.setRightRef(((ColumnInfo)alink.getRight()).getId());
            relation.getLink().add(link);
        }
        if (!leftIsPK && !rightIsPK) {
            return Collections.emptyList();
        }
        CardinalityType left = factory.createCardinalityType();
        left.setRef(leftQS);
        CardinalityType right = factory.createCardinalityType();
        right.setRef(rightQS);
        if (leftIsPK) {
            left.setMincard(CardinalityEnum.ONE);
            left.setMaxcard(CardinalityEnum.ONE);
        } else {
            left.setMincard(CardinalityEnum.ONE);
            left.setMaxcard(CardinalityEnum.MANY);
        }
        if (rightIsPK) {
            right.setMincard(CardinalityEnum.ONE);
            right.setMaxcard(CardinalityEnum.ONE);
        } else {
            right.setMincard(CardinalityEnum.ONE);
            right.setMaxcard(CardinalityEnum.MANY);
        }
        relation.setLeft(left);
        relation.setRight(right);
        PropertyType property = factory.createPropertyType();
        property.setName(SYSTEM_DISCOVERED);
        property.setValue(Boolean.TRUE.toString());
        relation.getProperty().add(property);
        return Arrays.asList(relation);
    }

    private static MatchedDataset mergeDatasetInfo(MatchedDataset a, Pair<String, List<MatchedDataset>> bCandidates) {
        Set aColumnNames = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)a.getDataset()).stream().map(BaseObject::getId).collect(Collectors.toSet());
        MatchedDataset bCand = ((List)bCandidates.getRight()).stream().filter(b -> b.getId().equals(a.getId())).findFirst().orElse(null);
        SmartsModuleUtil.getFlattenedColumns((BaseItemObject)bCand.getDataset()).stream().forEach(f -> {
            if (!aColumnNames.contains(f.getId())) {
                ItemType item = new ItemType();
                item.setColumn(f);
                a.getDataset().getItem().add(item);
            }
        });
        return a;
    }

    private static int getRelevanceScore(MatchedDataset joinTarget, MatchedDataset joinCandidate) {
        Set<String> joinTargetKeywords = joinTarget.getTokens();
        Set<String> joinCandidateKeywords = joinCandidate.getTokens();
        joinCandidateKeywords.retainAll(joinTargetKeywords);
        return joinCandidateKeywords.size();
    }

    private boolean isOrthogonal(MatchedDataset joinCandidate, MatchedDataset target) {
        Set<String> targetKeywords = target.getTokens();
        Set<String> joinCandidateKeywords = joinCandidate.getTokens();
        joinCandidateKeywords.retainAll(targetKeywords);
        if (joinCandidateKeywords.isEmpty()) {
            return true;
        }
        int targetKeywordScore = 1;
        int candidateKeywordScore = 1;
        for (String keyword : joinCandidateKeywords) {
            Set tokens;
            target.getMatchedFeatures().sort(Comparator.comparing(MatchedFeature::getConfidence));
            for (MatchedFeature f : target.getMatchedFeatures()) {
                if (f.getMatchReason().equals((Object)MatchReason.FULL) || f.getMatchReason().equals((Object)MatchReason.PARTIAL_CONCEPT)) {
                    return false;
                }
                if (!f.getFeatureType().equals((Object)FeatureType.COLUMN_NAME)) continue;
                try {
                    ColumnInfo targetFeature = (ColumnInfo)JAXBHelper.unmarshalFromJSON(ColumnInfo.class, (String)f.getFeature().getColumnInfo());
                    tokens = targetFeature.getLabel().getPhrases().stream().flatMap(p -> p.getTokens().stream()).map(t -> t.getText()).filter(t -> !t.equals(keyword)).collect(Collectors.toSet());
                    if (!f.getMatchReason().equals((Object)MatchReason.PARTIAL_NAME)) continue;
                    tokens.remove(keyword);
                    targetKeywordScore += tokens.size() * 3;
                }
                catch (IOException e) {
                    LOGGER.error("Can not unmarshal ColumnInfo \"" + f.getFeature().getColumnInfo() + "\"" + e);
                }
            }
            joinCandidate.getMatchedFeatures().sort(Comparator.comparing(MatchedFeature::getConfidence));
            for (MatchedFeature f : joinCandidate.getMatchedFeatures()) {
                if (f.getMatchReason().equals((Object)MatchReason.FULL) || f.getMatchReason().equals((Object)MatchReason.PARTIAL_CONCEPT)) {
                    return false;
                }
                if (!f.getFeatureType().equals((Object)FeatureType.COLUMN_NAME)) continue;
                try {
                    ColumnInfo joinCandidateFeature = (ColumnInfo)JAXBHelper.unmarshalFromJSON(ColumnInfo.class, (String)f.getFeature().getColumnInfo());
                    tokens = joinCandidateFeature.getLabel().getPhrases().stream().flatMap(p -> p.getTokens().stream()).map(t -> t.getText()).filter(t -> !t.equals(keyword)).collect(Collectors.toSet());
                    if (!f.getMatchReason().equals((Object)MatchReason.PARTIAL_NAME)) continue;
                    tokens.remove(keyword);
                    candidateKeywordScore += tokens.size() * 3;
                }
                catch (IOException e) {
                    LOGGER.error("Can not unmarshal ColumnInfo \"" + f.getFeature().getColumnInfo() + "\"" + e);
                }
            }
        }
        double diff = (double)Math.abs(targetKeywordScore - candidateKeywordScore) / (double)Math.max(targetKeywordScore, candidateKeywordScore);
        return diff > 0.6;
    }

    private static boolean hasOneToNJoinPath(DatasetInfo left, DatasetInfo right, Module module, Map<String, Set<String>> joinGraph) {
        String rightID;
        String leftID = left.getId();
        return ModuleUtil.hasOneToNJoinPath(module, leftID, rightID = right.getId(), joinGraph) || ModuleUtil.hasOneToNJoinPath(module, rightID, leftID, joinGraph);
    }
}

