/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.designer.join.rules;

import com.ibm.smarts.modelling.designer.join.rules.ScoringRule;
import com.ibm.smarts.modelling.util.TempUtil;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class MatchAttributeConcept
implements ScoringRule {
    @Override
    public String getDescription() {
        return "Data item attribute concept are matching.";
    }

    @Override
    public double getScore() {
        return 0.1;
    }

    @Override
    public double score(ColumnInfo q1, ColumnInfo q2, List<Pair<String, Double>> scoringLog) {
        Optional<ConceptInfo> q1AttributeConceptInfo = TempUtil.getAttributeConcept(q1);
        if (!q1AttributeConceptInfo.isPresent()) {
            return ScoringRule.logScore(0.0, q1.getId() + " has unknown attriture concept.", scoringLog);
        }
        Concept q1AttributeConcept = ConceptsRegistry.instance().getConcept(q1AttributeConceptInfo.get().getConceptID());
        if (q1AttributeConcept == null) {
            return ScoringRule.logScore(0.0, q1.getId() + " has attriture concept that is not in the ConceptsRegistry.", scoringLog);
        }
        Set q1IDs = q1AttributeConcept.getParents().stream().map(Concept::getIRI).collect(Collectors.toSet());
        q1IDs.add(q1AttributeConceptInfo.get().getConceptID());
        Optional<ConceptInfo> q2AttributeConceptInfo = TempUtil.getAttributeConcept(q2);
        if (!q2AttributeConceptInfo.isPresent()) {
            return ScoringRule.logScore(0.0, q2.getId() + " has unknown attriture concept.", scoringLog);
        }
        Concept q2AttributeConcept = ConceptsRegistry.instance().getConcept(q2AttributeConceptInfo.get().getConceptID());
        if (q2AttributeConcept == null) {
            return ScoringRule.logScore(0.0, q2.getId() + " has attriture concept that is not in the ConceptsRegistry.", scoringLog);
        }
        Set q2IDs = q2AttributeConcept.getParents().stream().map(Concept::getIRI).collect(Collectors.toSet());
        q2IDs.add(q2AttributeConceptInfo.get().getConceptID());
        if (q2IDs.contains(q1AttributeConceptInfo.get().getConceptID()) || q1IDs.contains(q2AttributeConceptInfo.get().getConceptID())) {
            return ScoringRule.logScore(this.getScore(), this.getDescription(), scoringLog);
        }
        return ScoringRule.logScore(0.0, "Data item attribute concept are different.", scoringLog);
    }
}

