/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.designer.join.rules;

import com.ibm.smarts.modelling.designer.join.rules.ScoringRule;
import com.ibm.smarts.modelling.util.TempUtil;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class MatchCategoryConcept
implements ScoringRule {
    private static String ENTITY = "http://www.ibm.com/ontologies/waca/domain/common#Entity";

    @Override
    public String getDescription() {
        return "Data item category concept are matching.";
    }

    @Override
    public double getScore() {
        return 0.1;
    }

    @Override
    public double score(ColumnInfo qi1, ColumnInfo qi2, List<Pair<String, Double>> scoringLog) {
        if (!qi1.getUsage().equals((Object)qi2.getUsage())) {
            return ScoringRule.logScore(-0.5, this.getDescription(), scoringLog);
        }
        Optional<ConceptInfo> qi1CategoryConceptInfo = TempUtil.getCategoryConcept(qi1);
        Optional<ConceptInfo> qi2CategoryConceptInfo = TempUtil.getCategoryConcept(qi2);
        if (qi1CategoryConceptInfo.isPresent() && qi2CategoryConceptInfo.isPresent()) {
            Concept qi1CategoryConcept = ConceptsRegistry.instance().getConcept(qi1CategoryConceptInfo.get().getConceptID());
            Concept qi2CategoryConcept = ConceptsRegistry.instance().getConcept(qi2CategoryConceptInfo.get().getConceptID());
            if (qi1CategoryConcept != null && qi2CategoryConcept != null) {
                if (qi1CategoryConceptInfo.get().getConceptID().equals(ENTITY) && qi2CategoryConceptInfo.get().getConceptID().equals(ENTITY)) {
                    return ScoringRule.logScore(0.0, "Both query items have generic concept.", scoringLog);
                }
                if (qi1CategoryConceptInfo.get().getConceptID().equals(ENTITY) || qi2CategoryConceptInfo.get().getConceptID().equals(ENTITY)) {
                    return ScoringRule.logScore(-0.2, "One of the query items has generic concept.", scoringLog);
                }
                Set q1IDs = qi1CategoryConcept.getParents().stream().map(Concept::getIRI).collect(Collectors.toSet());
                q1IDs.add(qi1CategoryConceptInfo.get().getConceptID());
                Set q2IDs = qi2CategoryConcept.getParents().stream().map(Concept::getIRI).collect(Collectors.toSet());
                q2IDs.add(qi2CategoryConceptInfo.get().getConceptID());
                if (q2IDs.contains(qi1CategoryConceptInfo.get().getConceptID()) || q1IDs.contains(qi2CategoryConceptInfo.get().getConceptID())) {
                    return ScoringRule.logScore(this.getScore(), this.getDescription(), scoringLog);
                }
                return ScoringRule.logScore(0.0, "Query items have different category concept.", scoringLog);
            }
            return ScoringRule.logScore(-0.2, "The category concept for one of the query items is not in the ConceptsRegistry.", scoringLog);
        }
        return ScoringRule.logScore(-0.2, "One of the query items has no category concept.", scoringLog);
    }
}

