/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.designer.join.rules;

import com.ibm.smarts.modelling.designer.join.rules.ScoringRule;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TokenInfo;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class MatchDataItemName
implements ScoringRule {
    private static final String UNKNOWN_POS = "unknown";

    @Override
    public String getDescription() {
        return "Data item names are matching.";
    }

    @Override
    public double getScore() {
        return 0.4;
    }

    @Override
    public double score(ColumnInfo q1, ColumnInfo q2, List<Pair<String, Double>> scoringLog) {
        double matchingScore = this.getNameMatchingScore(q1, q2);
        if (Double.compare(matchingScore, 0.0) > 0) {
            return ScoringRule.logScore(this.getScore() * matchingScore, this.getDescription(), scoringLog);
        }
        return ScoringRule.logScore(0.0, "Data item names are different.", scoringLog);
    }

    private double getNameMatchingScore(ColumnInfo column1, ColumnInfo column2) {
        List commonLemmas;
        int i;
        List groupTokens = ((Stream)((PhraseInfo)column1.getLabel().getPhrases().get(0)).getTokens().stream().sequential()).filter(t -> !t.getPOS().equalsIgnoreCase(UNKNOWN_POS)).map(TokenInfo::getLemma).collect(Collectors.toList());
        List columnTokens = ((Stream)((PhraseInfo)column2.getLabel().getPhrases().get(0)).getTokens().stream().sequential()).filter(t -> !t.getPOS().equalsIgnoreCase(UNKNOWN_POS)).map(TokenInfo::getLemma).collect(Collectors.toList());
        for (i = 0; i < Math.min(groupTokens.size(), columnTokens.size()) && ((String)groupTokens.get(i)).equals(columnTokens.get(i)); ++i) {
        }
        List groupLemmas = groupTokens.subList(i, groupTokens.size());
        List columnLemmas = columnTokens.subList(i, columnTokens.size());
        double numWords = Math.max(groupLemmas.size(), columnLemmas.size());
        if (Double.compare(numWords, 0.0) == 0) {
            return 1.0;
        }
        if (groupLemmas.size() >= columnLemmas.size()) {
            groupLemmas.retainAll(columnLemmas);
            commonLemmas = groupLemmas;
        } else {
            columnLemmas.retainAll(groupLemmas);
            commonLemmas = columnLemmas;
        }
        return (double)commonLemmas.size() / numWords;
    }
}

