/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.designer.join.rules;

import com.ibm.smarts.modelling.designer.join.rules.ScoringRule;
import com.ibm.smarts.schema.ColumnInfo;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;

public class RestrictDataItemName
implements ScoringRule {
    private static final String[] patterns = new String[]{"row.*?guid.*", "row.*?id.*", "row.*?key.*", "_row_id"};
    private static final Pattern[] CASE_INSENSITIVE_PATTERNS = new Pattern[patterns.length];

    @Override
    public String getDescription() {
        return "Data item names are allowed.";
    }

    @Override
    public double getScore() {
        return 0.0;
    }

    @Override
    public double score(ColumnInfo q1, ColumnInfo q2, List<Pair<String, Double>> scoringLog) {
        for (Pattern p : CASE_INSENSITIVE_PATTERNS) {
            if (p.matcher(q1.getId()).matches()) {
                return ScoringRule.logScore(-1.0, q1.getId() + " is a prohibit name.", scoringLog);
            }
            if (!p.matcher(q2.getId()).matches()) continue;
            return ScoringRule.logScore(-1.0, q2.getId() + " is a prohibit name.", scoringLog);
        }
        return this.getScore();
    }

    public static boolean isValidDataItemName(String name) {
        for (Pattern p : CASE_INSENSITIVE_PATTERNS) {
            if (!p.matcher(name).matches()) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < patterns.length; ++i) {
            RestrictDataItemName.CASE_INSENSITIVE_PATTERNS[i] = Pattern.compile(patterns[i], 2);
        }
    }
}

