/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.designer.join.rules;

import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.value.Value;
import com.ibm.smarts.model.value.ValueStatus;
import com.ibm.smarts.modelling.designer.join.rules.ScoringRule;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.StatisticType;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class RestrictDataItemValuesOverlapping
implements ScoringRule {
    @Override
    public String getDescription() {
        return "Data items have overlapping values.";
    }

    @Override
    public double getScore() {
        return 0.1;
    }

    @Override
    public double score(ColumnInfo q1, ColumnInfo q2, List<Pair<String, Double>> scoringLog) {
        block7: {
            Value q1Min = q1.getStatistics().stream().filter(s -> StatisticType.MIN_VALUE.equals((Object)s.getType())).filter(s -> s.getValue() != null && s.getValue().getStatus().equals((Object)ValueStatus.OK)).map(s -> s.getValue()).findFirst().orElse(null);
            Value q1Max = q1.getStatistics().stream().filter(s -> StatisticType.MAX_VALUE.equals((Object)s.getType())).filter(s -> s.getValue() != null && s.getValue().getStatus().equals((Object)ValueStatus.OK)).map(s -> s.getValue()).findFirst().orElse(null);
            Value q2Min = q2.getStatistics().stream().filter(s -> StatisticType.MIN_VALUE.equals((Object)s.getType())).filter(s -> s.getValue() != null && s.getValue().getStatus().equals((Object)ValueStatus.OK)).map(s -> s.getValue()).findFirst().orElse(null);
            Value q2Max = q1.getStatistics().stream().filter(s -> StatisticType.MAX_VALUE.equals((Object)s.getType())).filter(s -> s.getValue() != null && s.getValue().getStatus().equals((Object)ValueStatus.OK)).map(s -> s.getValue()).findFirst().orElse(null);
            DataType q1DataType = q1.getDataType();
            DataType q2DataType = q2.getDataType();
            if (q1DataType == null || q2DataType == null) {
                return ScoringRule.logScore(-1.0, "One of the data items has unknown data type.", scoringLog);
            }
            if (!q1DataType.isString() && (q1Min == null || q1Max == null) || !q2DataType.isString() && (q2Min == null || q2Max == null)) {
                return ScoringRule.logScore(-1.0, "One of the data items has unknown statistics values.", scoringLog);
            }
            if (q1DataType.equals(q2DataType)) {
                if (q1DataType.isNumeric()) {
                    try {
                        BigDecimal q1MinNumber = new BigDecimal(q1Min.stringValue());
                        BigDecimal q1MaxNumber = new BigDecimal(q1Max.stringValue());
                        BigDecimal q2MinNumber = new BigDecimal(q2Min.stringValue());
                        BigDecimal q2MaxNumber = new BigDecimal(q2Max.stringValue());
                        if (Math.max(q1MinNumber.longValue(), q2MinNumber.longValue()) <= Math.min(q1MaxNumber.longValue(), q2MaxNumber.longValue())) {
                            return this.getScore();
                        }
                        break block7;
                    }
                    catch (NumberFormatException e) {
                        return ScoringRule.logScore(-1.0, e.toString(), scoringLog);
                    }
                }
                return ScoringRule.logScore(this.getScore(), this.getDescription(), scoringLog);
            }
        }
        return ScoringRule.logScore(-1.0, "Data item values are not overlapping.", scoringLog);
    }
}

