/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.designer.join.rules;

import com.ibm.smarts.modelling.designer.join.rules.MatchAttributeConcept;
import com.ibm.smarts.modelling.designer.join.rules.MatchCategoryConcept;
import com.ibm.smarts.modelling.designer.join.rules.MatchDataItemName;
import com.ibm.smarts.modelling.designer.join.rules.MatchIdentifier;
import com.ibm.smarts.modelling.designer.join.rules.RestrictDataItemName;
import com.ibm.smarts.modelling.designer.join.rules.ScoringRule;
import com.ibm.smarts.schema.ColumnInfo;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class ScoringDriver {
    private final List<ScoringRule> mRules;

    public ScoringDriver() {
        this.mRules = Arrays.asList(new MatchDataItemName(), new RestrictDataItemName(), new MatchIdentifier(), new MatchAttributeConcept(), new MatchCategoryConcept());
    }

    public ScoringDriver(ScoringRule ... rules) {
        this.mRules = Arrays.asList(rules);
    }

    public ScoringDriver addRule(ScoringRule rule) {
        this.mRules.add(rule);
        return this;
    }

    public double score(ColumnInfo qi1, ColumnInfo qi2, List<Pair<String, Double>> detail) {
        double total = 0.0;
        for (ScoringRule rule : this.mRules) {
            double score = rule.score(qi1, qi2, detail);
            total += score;
            if (!(score <= -1.0)) continue;
            break;
        }
        return total;
    }
}

