/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.designer.module;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.modelling.builder.BusinessModuleBuilder;
import com.ibm.smarts.modelling.designer.MatchedDataset;
import com.ibm.smarts.modelling.designer.MatchedEntityPkg;
import com.ibm.smarts.modelling.designer.join.JoinPathAdvisor;
import com.ibm.smarts.modelling.designer.module.CandidateProposalGenerator;
import com.ibm.smarts.modelling.util.ModuleUtil;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.schema.MatchedEntity;
import com.ibm.smarts.schema.SemanticSearchResult;
import com.ibm.smarts.semanticsearch.api.SemanticSearchService;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.google.common.graph.ImmutableGraph;

public class BusinessModuleDesigner {
    private static final int CANDIDATEGROUPSIZELIMIT = 50;
    private final SemanticSearchService semanticSearchService;
    private final IStoreProvider moduleStore;
    private final SmartNLP nlp;
    private static final String OPEN_SCRIPT = "<script>";
    private static final String CLOSE_SCRIPT = "</script>";
    private static final int MAX_INTENT_LEN = 300;
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessModuleDesigner.class);

    public BusinessModuleDesigner(SemanticSearchService semanticSearchService, IStoreProvider storeProvider, SmartNLP nlp) {
        this.semanticSearchService = semanticSearchService;
        this.moduleStore = storeProvider;
        this.nlp = nlp;
    }

    public List<Module> getModuleProposals(RequestContext requestContext, String intent, String moduleID, Module module, int maxNumberOfProposal) {
        Instant start = Instant.now();
        if (intent.startsWith(OPEN_SCRIPT) && intent.endsWith(CLOSE_SCRIPT)) {
            return Collections.EMPTY_LIST;
        }
        if (intent.length() > 300) {
            throw new IllegalArgumentException("Intent is too long, must be 300 characters or less.");
        }
        boolean includeQuerySubjects = true;
        SemanticSearchResult searchResult = this.semanticSearchService.deepSearch(requestContext, intent, null, new String[]{moduleID});
        LinkedHashSet uniquePhrasesInOriginalOrder = new LinkedHashSet();
        ((Stream)searchResult.getMatchedEntity().stream().sequential()).filter(e -> !e.getMatchedFeatures().isEmpty()).map(MatchedEntity::getCoveredText).forEach(p -> uniquePhrasesInOriginalOrder.add(p));
        Map<String, List<MatchedEntity>> phraseToMatchedEntityMap = searchResult.getMatchedEntity().stream().filter(e -> !e.getMatchedFeatures().isEmpty()).collect(Collectors.groupingBy(MatchedEntity::getCoveredText));
        ArrayList<MatchedEntityPkg> aggregatedSearchResult = new ArrayList<MatchedEntityPkg>();
        uniquePhrasesInOriginalOrder.forEach(phrase -> {
            List phraseMatches = (List)phraseToMatchedEntityMap.get(phrase);
            aggregatedSearchResult.add(new MatchedEntityPkg(phraseMatches, requestContext, this.nlp));
        });
        TreeMap<Float, Set> candidateProposals = new TreeMap<Float, Set>();
        for (Pair<Float, Set<MatchedDataset>> aCandidateProposal : new CandidateProposalGenerator(aggregatedSearchResult)) {
            Set group = (Set)aCandidateProposal.getRight();
            float groupScore = ((Float)aCandidateProposal.getLeft()).floatValue();
            Set previous = candidateProposals.put(Float.valueOf(groupScore), group);
            while (previous != null) {
                previous = candidateProposals.put(Float.valueOf(groupScore += 1.0E-4f), previous);
            }
            if (candidateProposals.size() <= 50) continue;
            candidateProposals.pollFirstEntry();
        }
        boolean autoJoinDiscoveryEnabled = ModuleUtil.isAutoJoinDiscoveryRequired(module);
        boolean i = false;
        HashMap<String, List<MatchedDataset>> matchedDatasetCache = new HashMap<String, List<MatchedDataset>>(candidateProposals.descendingKeySet().size());
        TreeMap<Float, Object> finalProposals = new TreeMap<Float, Object>();
        for (Float groupScore : candidateProposals.descendingKeySet()) {
            Set aCandidateProposal = (Set)candidateProposals.get(groupScore);
            Pair<Float, Set<MatchedDataset>> finalProposal = this.getStarSchema(requestContext, matchedDatasetCache, aCandidateProposal, searchResult, moduleID, module, autoJoinDiscoveryEnabled && !i);
            Float finalProposalScore = (Float)finalProposal.getLeft();
            Set previous = (Set)finalProposals.put(finalProposalScore, finalProposal.getRight());
            while (previous != null && !previous.equals(finalProposal.getRight())) {
                finalProposalScore = Float.valueOf(finalProposalScore.floatValue() + 1.0E-4f);
                previous = finalProposals.put(finalProposalScore, previous);
            }
        }
        BusinessModuleBuilder moduleBuilder = new BusinessModuleBuilder();
        int iProposal = 0;
        ArrayList<Module> proposals = new ArrayList<Module>();
        for (Float groupScoreKey : finalProposals.descendingKeySet()) {
            Set group = (Set)finalProposals.get(groupScoreKey);
            ArrayList<QuerySubject> querySubjects = new ArrayList<QuerySubject>();
            for (MatchedDataset groupMember : group) {
                String identifier = groupMember.getId();
                QuerySubject qs = ModuleUtil.getQuerySubject(identifier, module);
                if (qs == null) continue;
                querySubjects.add(qs);
            }
            if (querySubjects.isEmpty()) continue;
            Module proposal = moduleBuilder.buildBusinessModule("StartingPoint" + ++iProposal, querySubjects, module, includeQuerySubjects);
            if (proposal != null) {
                if (module.getIdentifier().endsWith(".base")) {
                    groupScoreKey = Float.valueOf(groupScoreKey.floatValue() - 0.1f);
                }
                proposal.setDescription("Confidence Score = " + (float)(1.0 - Math.exp(-groupScoreKey.floatValue())));
                if (proposal.getMetadataTreeViewFocus() != null) {
                    proposal.getMetadataTreeViewFocus().setIntent(intent);
                }
                proposals.add(proposal);
            }
            if (proposals.size() < maxNumberOfProposal) continue;
            break;
        }
        LOGGER.info(String.format("Invoked feature search %s times", matchedDatasetCache.size()));
        LOGGER.info(String.format("getModuleProposals with intent [%s] for [%s] elapsed [%s] ms", intent, module.getIdentifier(), Duration.between(start, Instant.now()).toMillis()));
        return proposals;
    }

    private Pair<Float, Set<MatchedDataset>> getStarSchema(RequestContext requestContext, Map<String, List<MatchedDataset>> matchedDatasetCache, Set<MatchedDataset> aCandidateGroup, SemanticSearchResult intentMatchingCandidates, String moduleStoreID, Module module, boolean autoJoinDiscoveryEnabled) {
        JoinPathAdvisor advisor;
        boolean bJoinAdded;
        Pair<Float, Set<MatchedDataset>> joinedQSGroup = this.getStarSchema(aCandidateGroup, module);
        if (autoJoinDiscoveryEnabled && ((Set)joinedQSGroup.getRight()).size() == 1 && (bJoinAdded = (advisor = new JoinPathAdvisor(requestContext, 0.55, matchedDatasetCache, this.moduleStore, moduleStoreID)).addJoinsToModuleIfDiscovered(module, aCandidateGroup, intentMatchingCandidates))) {
            joinedQSGroup = this.getStarSchema(aCandidateGroup, module);
        }
        return joinedQSGroup;
    }

    private Pair<Float, Set<MatchedDataset>> getStarSchema(Set<MatchedDataset> contents, Module module) {
        HashSet<MatchedDataset> unit = new HashSet<MatchedDataset>();
        List nodes = contents.stream().map(MatchedDataset::getId).collect(Collectors.toList());
        ImmutableGraph<String> graph = ModuleUtil.getJoinGraph(module);
        HashSet<String> group = new HashSet<String>();
        String source = (String)nodes.get(0);
        group.add(source);
        for (int i = 1; i < nodes.size(); ++i) {
            if (group.contains(nodes.get(i))) continue;
            HashSet intersection = new HashSet(group);
            List<String> path = ModuleUtil.getShortestJoinPath(source, (String)nodes.get(i), graph);
            intersection.retainAll(path);
            if (intersection.isEmpty()) continue;
            group.addAll(path);
            source = (String)nodes.get(i);
        }
        Float groupScore = Float.valueOf(0.0f);
        for (String node : group) {
            Optional<MatchedDataset> content = contents.stream().filter(c -> node.equals(c.getId())).findFirst();
            if (content.isPresent()) {
                groupScore = Float.valueOf(groupScore.floatValue() + content.get().getScore().floatValue());
                unit.add(content.get());
                continue;
            }
            groupScore = Float.valueOf(groupScore.floatValue() + 0.1f);
            unit.add(new MatchedDataset(node));
        }
        return new ImmutablePair((Object)groupScore, unit);
    }
}

