/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.designer.module;

import com.ibm.smarts.modelling.designer.MatchedDataset;
import com.ibm.smarts.modelling.designer.MatchedEntityPkg;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CandidateProposalGenerator
implements Iterable<Pair<Float, Set<MatchedDataset>>> {
    private List<MatchedEntityPkg> data;
    private int[] pos;

    public CandidateProposalGenerator(List<MatchedEntityPkg> aggregatedSearchResult) {
        this.data = aggregatedSearchResult;
        this.pos = new int[this.data.size()];
        for (int i = 0; i < this.pos.length; ++i) {
            this.pos[i] = 0;
        }
    }

    @Override
    public Iterator<Pair<Float, Set<MatchedDataset>>> iterator() {
        return new Iterator<Pair<Float, Set<MatchedDataset>>>(){

            @Override
            public boolean hasNext() {
                return CandidateProposalGenerator.this.pos.length > 0 && CandidateProposalGenerator.this.pos[0] < ((MatchedEntityPkg)CandidateProposalGenerator.this.data.get(0)).getGroups().size();
            }

            @Override
            public Pair<Float, Set<MatchedDataset>> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return CandidateProposalGenerator.this.getNext();
            }
        };
    }

    private Pair<Float, Set<MatchedDataset>> getNext() {
        int i;
        HashSet<MatchedDataset> aGroup = new HashSet<MatchedDataset>();
        float groupScore = 0.0f;
        for (i = 0; i < this.pos.length; ++i) {
            MatchedDataset aCandidate = this.data.get(i).getGroups().get(this.pos[i]);
            while (aGroup.contains(aCandidate)) {
                groupScore += aCandidate.getScore().floatValue();
                if (this.pos[i] >= this.data.get(i).getGroups().size() - 1) break;
                this.pos[i] = this.pos[i] + 1;
                aCandidate = this.data.get(i).getGroups().get(this.pos[i]);
            }
            if (aGroup.contains(aCandidate)) continue;
            groupScore += aCandidate.getScore().floatValue();
            aGroup.add(aCandidate);
        }
        for (i = this.pos.length - 1; i >= 0; --i) {
            this.pos[i] = this.pos[i] + 1;
            if (this.pos[i] < this.data.get(i).getGroups().size()) break;
            if (i <= 0) continue;
            this.pos[i] = 0;
        }
        return new ImmutablePair((Object)Float.valueOf(groupScore), aGroup);
    }
}

