/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.modelling.impl;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.smarts.core.lifecycle.IComponentLifecycle;
import com.ibm.smarts.core.lifecycle.IComponentLifecycleOperations;
import com.ibm.smarts.core.lifecycle.ILifecycleManager;
import com.ibm.smarts.core.lifecycle.IManagedLifecycle;
import com.ibm.smarts.core.lifecycle.LifecycleManager;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.modelling.api.ModellingService;
import com.ibm.smarts.modelling.designer.join.JoinPathAdvisor;
import com.ibm.smarts.modelling.designer.module.BusinessModuleDesigner;
import com.ibm.smarts.nlp.api.SmartNLP;
import com.ibm.smarts.semanticsearch.api.SemanticSearchService;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModellingServiceImpl
implements ModellingService,
IComponentLifecycle,
IManagedLifecycle {
    private final Logger LOGGER = LoggerFactory.getLogger(ModellingServiceImpl.class);
    private final LifecycleManager clh;
    private final SemanticSearchService semanticSearchService;
    private final IStoreProvider moduleStore;
    private final SmartNLP nlp;

    public ModellingServiceImpl(SemanticSearchService semanticSearchService, IStoreProvider storeProvider, SmartNLP nlp) {
        this.semanticSearchService = semanticSearchService;
        this.moduleStore = storeProvider;
        this.nlp = nlp;
        this.clh = new LifecycleManager((IComponentLifecycle)this, new IComponentLifecycleOperations[0]);
    }

    public ILifecycleManager getLifecycleManager() {
        return this.clh;
    }

    public void initialize(RequestContext rc) {
        this.LOGGER.info("<TCL> Component initialize ModellingService");
    }

    public void shutDown(RequestContext rc) {
        this.LOGGER.info("<TCL> Component shutdown ModellingService");
    }

    @Override
    public List<Module> getModuleProposals(RequestContext requestContext, String intent, String moduleID, Module module, int maxNumberOfProposal) {
        BusinessModuleDesigner designer = new BusinessModuleDesigner(this.semanticSearchService, this.moduleStore, this.nlp);
        return designer.getModuleProposals(requestContext, intent, moduleID, module, maxNumberOfProposal);
    }

    @Override
    public Module getJoinProposals(RequestContext requestContext, String moduleID, List<String> qsNames, int maxNumberOfJoinsBetweenTwoTables) {
        JoinPathAdvisor advisor = new JoinPathAdvisor(requestContext, 0.55, this.moduleStore, moduleID);
        Module proposal = new Module();
        proposal.getRelationship().addAll(advisor.suggestJoinsQS(qsNames));
        return proposal;
    }
}

